/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.dataflow;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import edu.uci.ics.hyracks.storage.am.common.api.IIndex;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexAccessor;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexDataflowHelper;
import edu.uci.ics.hyracks.storage.am.common.api.IModificationOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.api.ITupleFilter;
import edu.uci.ics.hyracks.storage.am.common.api.ITupleFilterFactory;
import edu.uci.ics.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import edu.uci.ics.hyracks.storage.am.common.exceptions.TreeIndexNonExistentKeyException;
import edu.uci.ics.hyracks.storage.am.common.impls.NoOpOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.IndexOperation;
import edu.uci.ics.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import java.nio.ByteBuffer;

public class IndexInsertUpdateDeleteOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    protected final IIndexOperatorDescriptor opDesc;
    protected final IHyracksTaskContext ctx;
    protected final IIndexDataflowHelper indexHelper;
    protected final IRecordDescriptorProvider recordDescProvider;
    protected final IndexOperation op;
    protected final PermutingFrameTupleReference tuple = new PermutingFrameTupleReference();
    protected FrameTupleAccessor accessor;
    protected FrameTupleReference frameTuple;
    protected ByteBuffer writeBuffer;
    protected IIndexAccessor indexAccessor;
    protected ITupleFilter tupleFilter;
    protected IModificationOperationCallback modCallback;

    public IndexInsertUpdateDeleteOperatorNodePushable(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, int[] fieldPermutation, IRecordDescriptorProvider recordDescProvider, IndexOperation op) {
        this.opDesc = opDesc;
        this.ctx = ctx;
        this.indexHelper = opDesc.getIndexDataflowHelperFactory().createIndexDataflowHelper(opDesc, ctx, partition);
        this.recordDescProvider = recordDescProvider;
        this.op = op;
        this.tuple.setFieldPermutation(fieldPermutation);
    }

    public void open() throws HyracksDataException {
        RecordDescriptor inputRecDesc = this.recordDescProvider.getInputRecordDescriptor(this.opDesc.getActivityId(), 0);
        this.accessor = new FrameTupleAccessor(this.ctx.getFrameSize(), inputRecDesc);
        this.writeBuffer = this.ctx.allocateFrame();
        this.writer.open();
        this.indexHelper.open();
        IIndex index = this.indexHelper.getIndexInstance();
        try {
            this.modCallback = this.opDesc.getModificationOpCallbackFactory().createModificationOperationCallback(this.indexHelper.getResourceID(), index, this.ctx);
            this.indexAccessor = index.createAccessor(this.modCallback, NoOpOperationCallback.INSTANCE);
            ITupleFilterFactory tupleFilterFactory = this.opDesc.getTupleFilterFactory();
            if (tupleFilterFactory != null) {
                this.tupleFilter = tupleFilterFactory.createTupleFilter(this.indexHelper.getTaskContext());
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            this.indexHelper.close();
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            try {
                if (this.tupleFilter != null) {
                    this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                    if (!this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
                }
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                switch (this.op) {
                    case INSERT: {
                        try {
                            this.indexAccessor.insert((ITupleReference)this.tuple);
                        }
                        catch (TreeIndexDuplicateKeyException e) {}
                        break;
                    }
                    case UPDATE: {
                        this.indexAccessor.update((ITupleReference)this.tuple);
                        break;
                    }
                    case UPSERT: {
                        this.indexAccessor.upsert((ITupleReference)this.tuple);
                        break;
                    }
                    case DELETE: {
                        try {
                            this.indexAccessor.delete((ITupleReference)this.tuple);
                        }
                        catch (TreeIndexNonExistentKeyException e) {}
                        break;
                    }
                    default: {
                        throw new HyracksDataException("Unsupported operation " + (Object)((Object)this.op) + " in tree index InsertUpdateDelete operator");
                    }
                }
                continue;
            }
            catch (HyracksDataException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        System.arraycopy(buffer.array(), 0, this.writeBuffer.array(), 0, buffer.capacity());
        FrameUtils.flushFrame((ByteBuffer)this.writeBuffer, (IFrameWriter)this.writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HyracksDataException {
        try {
            this.writer.close();
        }
        finally {
            this.indexHelper.close();
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }
}

