/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.dataflow;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.storage.am.common.api.IIndex;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexDataflowHelper;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexLifecycleManager;
import edu.uci.ics.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.util.IndexFileNameUtil;
import edu.uci.ics.hyracks.storage.common.file.ILocalResourceFactory;
import edu.uci.ics.hyracks.storage.common.file.ILocalResourceRepository;
import edu.uci.ics.hyracks.storage.common.file.LocalResource;
import edu.uci.ics.hyracks.storage.common.file.ResourceIdFactory;
import java.io.File;
import java.io.IOException;

public abstract class IndexDataflowHelper
implements IIndexDataflowHelper {
    protected final IIndexOperatorDescriptor opDesc;
    protected final IHyracksTaskContext ctx;
    protected final IIndexLifecycleManager lcManager;
    protected final ILocalResourceRepository localResourceRepository;
    protected final ResourceIdFactory resourceIdFactory;
    protected final FileReference file;
    protected final int partition;
    protected final int ioDeviceId;
    protected IIndex index;

    public IndexDataflowHelper(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition) {
        this.opDesc = opDesc;
        this.ctx = ctx;
        this.lcManager = opDesc.getLifecycleManagerProvider().getLifecycleManager(ctx);
        this.localResourceRepository = opDesc.getStorageManager().getLocalResourceRepository(ctx);
        this.resourceIdFactory = opDesc.getStorageManager().getResourceIdFactory(ctx);
        this.partition = partition;
        this.ioDeviceId = opDesc.getFileSplitProvider().getFileSplits()[partition].getIODeviceId();
        this.file = new FileReference(new File(IndexFileNameUtil.prepareFileName(opDesc.getFileSplitProvider().getFileSplits()[partition].getLocalFile().getFile().getPath(), this.ioDeviceId)));
    }

    protected abstract IIndex createIndexInstance() throws HyracksDataException;

    @Override
    public IIndex getIndexInstance() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws HyracksDataException {
        IIndexLifecycleManager iIndexLifecycleManager = this.lcManager;
        synchronized (iIndexLifecycleManager) {
            long resourceID = this.getResourceID();
            this.index = this.lcManager.getIndex(resourceID);
            if (this.index != null) {
                this.lcManager.unregister(resourceID);
            } else {
                this.index = this.createIndexInstance();
            }
            if (resourceID != -1L) {
                this.localResourceRepository.deleteResourceByName(this.file.getFile().getPath());
            }
            this.index.create();
            try {
                resourceID = this.resourceIdFactory.createId();
                ILocalResourceFactory localResourceFactory = this.opDesc.getLocalResourceFactoryProvider().getLocalResourceFactory();
                this.localResourceRepository.insert(localResourceFactory.createLocalResource(resourceID, this.file.getFile().getPath(), this.partition));
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
            this.lcManager.register(resourceID, this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws HyracksDataException {
        IIndexLifecycleManager iIndexLifecycleManager = this.lcManager;
        synchronized (iIndexLifecycleManager) {
            long resourceID = this.getResourceID();
            if (resourceID == -1L) {
                throw new HyracksDataException("Index does not have a valid resource ID. Has it been created yet?");
            }
            this.index = this.lcManager.getIndex(resourceID);
            if (this.index == null) {
                this.index = this.createIndexInstance();
                this.lcManager.register(resourceID, this.index);
            }
            this.lcManager.open(resourceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HyracksDataException {
        IIndexLifecycleManager iIndexLifecycleManager = this.lcManager;
        synchronized (iIndexLifecycleManager) {
            this.lcManager.close(this.getResourceID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws HyracksDataException {
        IIndexLifecycleManager iIndexLifecycleManager = this.lcManager;
        synchronized (iIndexLifecycleManager) {
            long resourceID = this.getResourceID();
            this.index = this.lcManager.getIndex(resourceID);
            if (this.index != null) {
                this.lcManager.unregister(resourceID);
            } else {
                this.index = this.createIndexInstance();
            }
            if (resourceID != -1L) {
                this.localResourceRepository.deleteResourceByName(this.file.getFile().getPath());
            }
            this.index.destroy();
        }
    }

    @Override
    public FileReference getFileReference() {
        return this.file;
    }

    @Override
    public long getResourceID() throws HyracksDataException {
        LocalResource localResource = this.localResourceRepository.getResourceByName(this.file.getFile().getPath());
        if (localResource == null) {
            return -1L;
        }
        return localResource.getResourceId();
    }

    @Override
    public IHyracksTaskContext getTaskContext() {
        return this.ctx;
    }
}

