/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.dataflow;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.storage.am.common.api.IIndex;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexBulkLoader;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexDataflowHelper;
import edu.uci.ics.hyracks.storage.am.common.api.IndexException;
import edu.uci.ics.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import java.nio.ByteBuffer;

public class IndexBulkLoadOperatorNodePushable
extends AbstractUnaryInputSinkOperatorNodePushable {
    private final IIndexOperatorDescriptor opDesc;
    private final IHyracksTaskContext ctx;
    private final float fillFactor;
    private final boolean verifyInput;
    private final long numElementsHint;
    private final boolean checkIfEmptyIndex;
    private final IIndexDataflowHelper indexHelper;
    private FrameTupleAccessor accessor;
    private IIndex index;
    private IIndexBulkLoader bulkLoader;
    private IRecordDescriptorProvider recDescProvider;
    private PermutingFrameTupleReference tuple = new PermutingFrameTupleReference();

    public IndexBulkLoadOperatorNodePushable(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, int[] fieldPermutation, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, IRecordDescriptorProvider recordDescProvider) {
        this.opDesc = opDesc;
        this.ctx = ctx;
        this.indexHelper = opDesc.getIndexDataflowHelperFactory().createIndexDataflowHelper(opDesc, ctx, partition);
        this.fillFactor = fillFactor;
        this.verifyInput = verifyInput;
        this.numElementsHint = numElementsHint;
        this.checkIfEmptyIndex = checkIfEmptyIndex;
        this.recDescProvider = recordDescProvider;
        this.tuple.setFieldPermutation(fieldPermutation);
    }

    public void open() throws HyracksDataException {
        RecordDescriptor recDesc = this.recDescProvider.getInputRecordDescriptor(this.opDesc.getActivityId(), 0);
        this.accessor = new FrameTupleAccessor(this.ctx.getFrameSize(), recDesc);
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        try {
            this.bulkLoader = this.index.createBulkLoader(this.fillFactor, this.verifyInput, this.numElementsHint, this.checkIfEmptyIndex);
        }
        catch (Exception e) {
            this.indexHelper.close();
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
            try {
                this.bulkLoader.add((ITupleReference)this.tuple);
                continue;
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    public void close() throws HyracksDataException {
        try {
            this.bulkLoader.end();
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
        finally {
            this.indexHelper.close();
        }
    }

    public void fail() throws HyracksDataException {
    }
}

