/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.data;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.INumeric;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import edu.uci.ics.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;

public class PointablePrimitiveValueProviderFactory
implements IPrimitiveValueProviderFactory {
    private static final long serialVersionUID = 1L;
    private final IPointableFactory pf;

    public PointablePrimitiveValueProviderFactory(IPointableFactory pf) {
        this.pf = pf;
    }

    @Override
    public IPrimitiveValueProvider createPrimitiveValueProvider() {
        final IPointable p = this.pf.createPointable();
        ITypeTraits traits = this.pf.getTypeTraits();
        assert (traits.isFixedLength());
        final int length = traits.getFixedLength();
        return new IPrimitiveValueProvider(){

            @Override
            public double getValue(byte[] bytes, int offset) {
                p.set(bytes, offset, length);
                return ((INumeric)p).doubleValue();
            }
        };
    }
}

