/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.util;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.FDsAndEquivClassesVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import edu.uci.ics.hyracks.algebricks.core.config.AlgebricksConfig;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;

public class PhysicalOptimizationsUtil {
    public static void computeFDsAndEquivalenceClasses(AbstractLogicalOperator op, IOptimizationContext ctx) throws AlgebricksException {
        FDsAndEquivClassesVisitor visitor = new FDsAndEquivClassesVisitor();
        HashSet<ILogicalOperator> visitSet = new HashSet<ILogicalOperator>();
        PhysicalOptimizationsUtil.computeFDsAndEqClassesWithVisitorRec(op, ctx, visitor, visitSet);
    }

    private static void computeFDsAndEqClassesWithVisitorRec(AbstractLogicalOperator op, IOptimizationContext ctx, FDsAndEquivClassesVisitor visitor, Set<ILogicalOperator> visitSet) throws AlgebricksException {
        NestedTupleSourceOperator nts;
        ILogicalOperator source;
        visitSet.add((ILogicalOperator)op);
        for (Mutable i : op.getInputs()) {
            PhysicalOptimizationsUtil.computeFDsAndEqClassesWithVisitorRec((AbstractLogicalOperator)i.getValue(), ctx, visitor, visitSet);
        }
        if (op.hasNestedPlans()) {
            for (ILogicalPlan p : ((AbstractOperatorWithNestedPlans)op).getNestedPlans()) {
                for (Mutable r : p.getRoots()) {
                    AbstractLogicalOperator rootOp = (AbstractLogicalOperator)r.getValue();
                    PhysicalOptimizationsUtil.computeFDsAndEqClassesWithVisitorRec(rootOp, ctx, visitor, visitSet);
                }
            }
        }
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE && !visitSet.contains(source = (ILogicalOperator)((Mutable)((ILogicalOperator)(nts = (NestedTupleSourceOperator)op).getDataSourceReference().getValue()).getInputs().get(0)).getValue())) {
            PhysicalOptimizationsUtil.computeFDsAndEqClassesWithVisitorRec((AbstractLogicalOperator)source, ctx, visitor, visitSet);
        }
        op.accept((ILogicalOperatorVisitor)visitor, (Object)ctx);
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine("--> op. type = " + op.getOperatorTag() + "\n" + "    equiv. classes = " + ctx.getEquivalenceClassMap((ILogicalOperator)op) + "\n" + "    FDs = " + ctx.getFDList((ILogicalOperator)op) + "\n");
    }
}

