/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class SimpleUnnestToProductRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN && op.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (!(op2 instanceof AbstractScanOperator) && !this.descOrSelfIsSourceScan(op2)) {
            return false;
        }
        if (!this.opsAreIndependent((ILogicalOperator)op, (ILogicalOperator)op2)) {
            return false;
        }
        InnerJoinOperator product = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE));
        EmptyTupleSourceOperator ets = new EmptyTupleSourceOperator();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)ets);
        MutableObject emptySrc = new MutableObject((Object)ets);
        List opInpList = op.getInputs();
        opInpList.clear();
        opInpList.add(emptySrc);
        product.getInputs().add(opRef2);
        product.getInputs().add(new MutableObject((Object)op));
        opRef.setValue((Object)product);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)product);
        return true;
    }

    private boolean descOrSelfIsSourceScan(AbstractLogicalOperator op2) {
        if (op2.getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        if (op2.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN && op2.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return true;
        }
        for (Mutable cRef : op2.getInputs()) {
            AbstractLogicalOperator alo = (AbstractLogicalOperator)cRef.getValue();
            if (!this.descOrSelfIsSourceScan(alo)) continue;
            return true;
        }
        return false;
    }

    private boolean opsAreIndependent(ILogicalOperator unnestOp, ILogicalOperator outer) throws AlgebricksException {
        ArrayList opUsedVars = new ArrayList();
        VariableUtilities.getUsedVariables((ILogicalOperator)unnestOp, opUsedVars);
        HashSet op2LiveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)outer, op2LiveVars);
        for (LogicalVariable usedVar : opUsedVars) {
            if (!op2LiveVars.contains(usedVar)) continue;
            return false;
        }
        return true;
    }
}

