/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.exceptions.NotImplementedException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IDataSource;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AggregatePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AssignPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.DataSourceScanPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.DistributeResultPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.EmptyTupleSourcePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.ExternalGroupByPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.InMemoryStableSortPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.IndexInsertDeletePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.InsertDeletePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.MicroPreclusteredGroupByPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.NestedTupleSourcePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.PreSortedDistinctByPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.PreclusteredGroupByPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.ReplicatePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.RunningAggregatePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.SinkPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.SinkWritePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.StableSortPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.StreamLimitPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.StreamProjectPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.StreamSelectPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.StringStreamingScriptPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.SubplanPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.UnionAllPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.UnnestPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.WriteResultPOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import edu.uci.ics.hyracks.algebricks.rewriter.util.JoinUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class SetAlgebricksPhysicalOperatorsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getPhysicalOperator() != null) {
            return false;
        }
        SetAlgebricksPhysicalOperatorsRule.computeDefaultPhysicalOp(op, true, context);
        return true;
    }

    private static void setPhysicalOperators(ILogicalPlan plan, boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        for (Mutable root : plan.getRoots()) {
            SetAlgebricksPhysicalOperatorsRule.computeDefaultPhysicalOp((AbstractLogicalOperator)root.getValue(), topLevelOp, context);
        }
    }

    private static void computeDefaultPhysicalOp(AbstractLogicalOperator op, boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        PhysicalOptimizationConfig physicalOptimizationConfig = context.getPhysicalOptimizationConfig();
        if (op.getPhysicalOperator() == null) {
            switch (op.getOperatorTag()) {
                case AGGREGATE: {
                    op.setPhysicalOperator((IPhysicalOperator)new AggregatePOperator());
                    break;
                }
                case ASSIGN: {
                    op.setPhysicalOperator((IPhysicalOperator)new AssignPOperator());
                    break;
                }
                case DISTINCT: {
                    DistinctOperator distinct = (DistinctOperator)op;
                    distinct.setPhysicalOperator((IPhysicalOperator)new PreSortedDistinctByPOperator(distinct.getDistinctByVarList()));
                    break;
                }
                case EMPTYTUPLESOURCE: {
                    op.setPhysicalOperator((IPhysicalOperator)new EmptyTupleSourcePOperator());
                    break;
                }
                case EXCHANGE: {
                    if (op.getPhysicalOperator() != null) break;
                    throw new AlgebricksException("Implementation for EXCHANGE operator was not set.");
                }
                case GROUP: {
                    ILogicalPlan p0;
                    GroupByOperator gby = (GroupByOperator)op;
                    if (gby.getNestedPlans().size() == 1 && (p0 = (ILogicalPlan)gby.getNestedPlans().get(0)).getRoots().size() == 1 && (gby.getAnnotations().get("USE_HASH_GROUP_BY") == Boolean.TRUE || gby.getAnnotations().get("USE_EXTERNAL_GROUP_BY") == Boolean.TRUE)) {
                        if (!topLevelOp) {
                            throw new NotImplementedException("External hash group-by for nested grouping is not implemented.");
                        }
                        ExternalGroupByPOperator externalGby = new ExternalGroupByPOperator(gby.getGroupByList(), physicalOptimizationConfig.getMaxFramesExternalGroupBy(), physicalOptimizationConfig.getExternalGroupByTableSize());
                        op.setPhysicalOperator((IPhysicalOperator)externalGby);
                        SetAlgebricksPhysicalOperatorsRule.generateMergeAggregationExpressions(gby, context);
                        break;
                    }
                    List gbyList = gby.getGroupByList();
                    ArrayList<LogicalVariable> columnList = new ArrayList<LogicalVariable>(gbyList.size());
                    for (Pair p : gbyList) {
                        ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
                        if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                        VariableReferenceExpression varRef = (VariableReferenceExpression)expr;
                        columnList.add(varRef.getVariableReference());
                    }
                    if (topLevelOp) {
                        op.setPhysicalOperator((IPhysicalOperator)new PreclusteredGroupByPOperator(columnList));
                        break;
                    }
                    op.setPhysicalOperator((IPhysicalOperator)new MicroPreclusteredGroupByPOperator(columnList));
                    break;
                }
                case INNERJOIN: {
                    JoinUtils.setJoinAlgorithmAndExchangeAlgo((AbstractBinaryJoinOperator)((InnerJoinOperator)op), context);
                    break;
                }
                case LEFTOUTERJOIN: {
                    JoinUtils.setJoinAlgorithmAndExchangeAlgo((AbstractBinaryJoinOperator)((LeftOuterJoinOperator)op), context);
                    break;
                }
                case LIMIT: {
                    op.setPhysicalOperator((IPhysicalOperator)new StreamLimitPOperator());
                    break;
                }
                case NESTEDTUPLESOURCE: {
                    op.setPhysicalOperator((IPhysicalOperator)new NestedTupleSourcePOperator());
                    break;
                }
                case ORDER: {
                    OrderOperator oo = (OrderOperator)op;
                    for (ILogicalPlan p : oo.getOrderExpressions()) {
                        ILogicalExpression e = (ILogicalExpression)((Mutable)p.second).getValue();
                        if (e.getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
                        throw new AlgebricksException("Order expression " + e + " has not been normalized.");
                    }
                    if (topLevelOp) {
                        op.setPhysicalOperator((IPhysicalOperator)new StableSortPOperator(physicalOptimizationConfig.getMaxFramesExternalSort()));
                        break;
                    }
                    op.setPhysicalOperator((IPhysicalOperator)new InMemoryStableSortPOperator());
                    break;
                }
                case PROJECT: {
                    op.setPhysicalOperator((IPhysicalOperator)new StreamProjectPOperator());
                    break;
                }
                case RUNNINGAGGREGATE: {
                    op.setPhysicalOperator((IPhysicalOperator)new RunningAggregatePOperator());
                    break;
                }
                case REPLICATE: {
                    op.setPhysicalOperator((IPhysicalOperator)new ReplicatePOperator());
                    break;
                }
                case SCRIPT: {
                    op.setPhysicalOperator((IPhysicalOperator)new StringStreamingScriptPOperator());
                    break;
                }
                case SELECT: {
                    op.setPhysicalOperator((IPhysicalOperator)new StreamSelectPOperator());
                    break;
                }
                case SUBPLAN: {
                    op.setPhysicalOperator((IPhysicalOperator)new SubplanPOperator());
                    break;
                }
                case UNIONALL: {
                    op.setPhysicalOperator((IPhysicalOperator)new UnionAllPOperator());
                    break;
                }
                case UNNEST: {
                    op.setPhysicalOperator((IPhysicalOperator)new UnnestPOperator());
                    break;
                }
                case DATASOURCESCAN: {
                    DataSourceScanOperator scan = (DataSourceScanOperator)op;
                    IDataSource dataSource = scan.getDataSource();
                    DataSourceScanPOperator dss = new DataSourceScanPOperator(dataSource);
                    IMetadataProvider mp = context.getMetadataProvider();
                    if (mp.scannerOperatorIsLeaf(dataSource)) {
                        dss.disableJobGenBelowMe();
                    }
                    op.setPhysicalOperator((IPhysicalOperator)dss);
                    break;
                }
                case WRITE: {
                    op.setPhysicalOperator((IPhysicalOperator)new SinkWritePOperator());
                    break;
                }
                case DISTRIBUTE_RESULT: {
                    op.setPhysicalOperator((IPhysicalOperator)new DistributeResultPOperator());
                    break;
                }
                case WRITE_RESULT: {
                    WriteResultOperator opLoad = (WriteResultOperator)op;
                    ArrayList<LogicalVariable> keys = new ArrayList<LogicalVariable>();
                    LogicalVariable payload = SetAlgebricksPhysicalOperatorsRule.getKeysAndLoad((Mutable<ILogicalExpression>)opLoad.getPayloadExpression(), opLoad.getKeyExpressions(), keys);
                    op.setPhysicalOperator((IPhysicalOperator)new WriteResultPOperator(opLoad.getDataSource(), payload, keys));
                    break;
                }
                case INSERT_DELETE: {
                    WriteResultOperator opLoad = (InsertDeleteOperator)op;
                    ArrayList<LogicalVariable> keys = new ArrayList();
                    LogicalVariable payload = SetAlgebricksPhysicalOperatorsRule.getKeysAndLoad((Mutable<ILogicalExpression>)opLoad.getPayloadExpression(), opLoad.getPrimaryKeyExpressions(), keys);
                    op.setPhysicalOperator((IPhysicalOperator)new InsertDeletePOperator(payload, keys, opLoad.getDataSource()));
                    break;
                }
                case INDEX_INSERT_DELETE: {
                    IndexInsertDeleteOperator opInsDel = (IndexInsertDeleteOperator)op;
                    ArrayList<LogicalVariable> primaryKeys = new ArrayList<LogicalVariable>();
                    ArrayList<LogicalVariable> secondaryKeys = new ArrayList<LogicalVariable>();
                    SetAlgebricksPhysicalOperatorsRule.getKeys(opInsDel.getPrimaryKeyExpressions(), primaryKeys);
                    SetAlgebricksPhysicalOperatorsRule.getKeys(opInsDel.getSecondaryKeyExpressions(), secondaryKeys);
                    op.setPhysicalOperator((IPhysicalOperator)new IndexInsertDeletePOperator(primaryKeys, secondaryKeys, opInsDel.getFilterExpression(), opInsDel.getDataSourceIndex()));
                    break;
                }
                case SINK: {
                    op.setPhysicalOperator((IPhysicalOperator)new SinkPOperator());
                }
            }
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans nested = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : nested.getNestedPlans()) {
                SetAlgebricksPhysicalOperatorsRule.setPhysicalOperators(p, false, context);
            }
        }
        for (Mutable opRef : op.getInputs()) {
            SetAlgebricksPhysicalOperatorsRule.computeDefaultPhysicalOp((AbstractLogicalOperator)opRef.getValue(), topLevelOp, context);
        }
    }

    private static void getKeys(List<Mutable<ILogicalExpression>> keyExpressions, List<LogicalVariable> keys) {
        for (Mutable<ILogicalExpression> kExpr : keyExpressions) {
            ILogicalExpression e = (ILogicalExpression)kExpr.getValue();
            if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                throw new NotImplementedException();
            }
            keys.add(((VariableReferenceExpression)e).getVariableReference());
        }
    }

    private static LogicalVariable getKeysAndLoad(Mutable<ILogicalExpression> payloadExpr, List<Mutable<ILogicalExpression>> keyExpressions, List<LogicalVariable> keys) {
        if (((ILogicalExpression)payloadExpr.getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            throw new NotImplementedException();
        }
        LogicalVariable payload = ((VariableReferenceExpression)payloadExpr.getValue()).getVariableReference();
        for (Mutable<ILogicalExpression> kExpr : keyExpressions) {
            ILogicalExpression e = (ILogicalExpression)kExpr.getValue();
            if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                throw new NotImplementedException();
            }
            keys.add(((VariableReferenceExpression)e).getVariableReference());
        }
        return payload;
    }

    private static void generateMergeAggregationExpressions(GroupByOperator gby, IOptimizationContext context) throws AlgebricksException {
        if (gby.getNestedPlans().size() != 1) {
            throw new AlgebricksException("External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        ILogicalPlan p0 = (ILogicalPlan)gby.getNestedPlans().get(0);
        if (p0.getRoots().size() != 1) {
            throw new AlgebricksException("External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        IMergeAggregationExpressionFactory mergeAggregationExpressionFactory = context.getMergeAggregationExpressionFactory();
        Mutable r0 = (Mutable)p0.getRoots().get(0);
        AggregateOperator aggOp = (AggregateOperator)r0.getValue();
        List aggFuncRefs = aggOp.getExpressions();
        int n = aggOp.getExpressions().size();
        ArrayList<MutableObject> mergeExpressionRefs = new ArrayList<MutableObject>();
        for (int i = 0; i < n; ++i) {
            ILogicalExpression mergeExpr = mergeAggregationExpressionFactory.createMergeAggregation((ILogicalExpression)((Mutable)aggFuncRefs.get(i)).getValue(), context);
            mergeExpressionRefs.add(new MutableObject((Object)mergeExpr));
        }
        aggOp.setMergeExpressions(mergeExpressionRefs);
    }
}

