/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Triple;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;

public class RemoveUnusedAssignAndAggregateRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean smthToRemove;
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        HashSet<LogicalVariable> toRemove = new HashSet<LogicalVariable>();
        this.collectUnusedAssignedVars((AbstractLogicalOperator)opRef.getValue(), toRemove, true, context);
        boolean bl = smthToRemove = !toRemove.isEmpty();
        if (smthToRemove) {
            this.removeUnusedAssigns(opRef, toRemove, context);
        }
        return !toRemove.isEmpty();
    }

    private void removeUnusedAssigns(Mutable<ILogicalOperator> opRef, Set<LogicalVariable> toRemove, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        while (this.removeFromAssigns(op, toRemove, context) == 0 && op.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            op = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
            opRef.setValue((Object)op);
        }
        for (Mutable cRef : op.getInputs()) {
            this.removeUnusedAssigns((Mutable<ILogicalOperator>)cRef, toRemove, context);
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opWithNest = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : opWithNest.getNestedPlans()) {
                for (Mutable r : p.getRoots()) {
                    this.removeUnusedAssigns((Mutable<ILogicalOperator>)r, toRemove, context);
                }
            }
        }
    }

    private int removeFromAssigns(AbstractLogicalOperator op, Set<LogicalVariable> toRemove, IOptimizationContext context) throws AlgebricksException {
        switch (op.getOperatorTag()) {
            case ASSIGN: {
                AssignOperator assign = (AssignOperator)op;
                if (this.removeUnusedVarsAndExprs(toRemove, assign.getVariables(), assign.getExpressions())) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assign);
                }
                return assign.getVariables().size();
            }
            case AGGREGATE: {
                AggregateOperator agg = (AggregateOperator)op;
                if (this.removeUnusedVarsAndExprs(toRemove, agg.getVariables(), agg.getExpressions())) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)agg);
                }
                return agg.getVariables().size();
            }
            case UNNEST: {
                UnnestOperator uOp = (UnnestOperator)op;
                LogicalVariable pVar = uOp.getPositionalVariable();
                if (pVar == null || !toRemove.contains(pVar)) break;
                uOp.setPositionalVariable(null);
                break;
            }
            case UNIONALL: {
                UnionAllOperator unionOp = (UnionAllOperator)op;
                if (this.removeUnusedVarsFromUnionAll(unionOp, toRemove)) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unionOp);
                }
                return unionOp.getVariableMappings().size();
            }
        }
        return -1;
    }

    private boolean removeUnusedVarsFromUnionAll(UnionAllOperator unionOp, Set<LogicalVariable> toRemove) {
        Iterator iter = unionOp.getVariableMappings().iterator();
        boolean modified = false;
        HashSet<Object> removeFromRemoveSet = new HashSet<Object>();
        while (iter.hasNext()) {
            Triple varMapping = (Triple)iter.next();
            if (toRemove.contains(varMapping.third)) {
                iter.remove();
                modified = true;
            }
            removeFromRemoveSet.add(varMapping.first);
            removeFromRemoveSet.add(varMapping.second);
        }
        toRemove.removeAll(removeFromRemoveSet);
        return modified;
    }

    private boolean removeUnusedVarsAndExprs(Set<LogicalVariable> toRemove, List<LogicalVariable> varList, List<Mutable<ILogicalExpression>> exprList) {
        boolean changed = false;
        Iterator<LogicalVariable> varIter = varList.iterator();
        Iterator<Mutable<ILogicalExpression>> exprIter = exprList.iterator();
        while (varIter.hasNext()) {
            LogicalVariable v = varIter.next();
            exprIter.next();
            if (!toRemove.contains(v)) continue;
            varIter.remove();
            exprIter.remove();
            changed = true;
        }
        return changed;
    }

    private void collectUnusedAssignedVars(AbstractLogicalOperator op, Set<LogicalVariable> toRemove, boolean first, IOptimizationContext context) throws AlgebricksException {
        if (!first) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        }
        for (Mutable c : op.getInputs()) {
            this.collectUnusedAssignedVars((AbstractLogicalOperator)c.getValue(), toRemove, false, context);
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opWithNested = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan plan : opWithNested.getNestedPlans()) {
                for (Mutable r : plan.getRoots()) {
                    this.collectUnusedAssignedVars((AbstractLogicalOperator)r.getValue(), toRemove, false, context);
                }
            }
        }
        boolean removeUsedVars = true;
        switch (op.getOperatorTag()) {
            case ASSIGN: {
                AssignOperator assign = (AssignOperator)op;
                toRemove.addAll(assign.getVariables());
                break;
            }
            case AGGREGATE: {
                AggregateOperator agg = (AggregateOperator)op;
                toRemove.addAll(agg.getVariables());
                break;
            }
            case UNNEST: {
                UnnestOperator uOp = (UnnestOperator)op;
                LogicalVariable pVar = uOp.getPositionalVariable();
                if (pVar == null) break;
                toRemove.add(pVar);
                break;
            }
            case UNIONALL: {
                UnionAllOperator unionOp = (UnionAllOperator)op;
                for (Triple varMapping : unionOp.getVariableMappings()) {
                    toRemove.add((LogicalVariable)varMapping.third);
                }
                removeUsedVars = false;
                break;
            }
        }
        if (removeUsedVars) {
            LinkedList used = new LinkedList();
            VariableUtilities.getUsedVariables((ILogicalOperator)op, used);
            toRemove.removeAll(used);
        }
    }
}

