/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.common.utils.Triple;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;

public class RemoveRedundantVariablesRule
implements IAlgebraicRewriteRule {
    private final VariableSubstitutionVisitor substVisitor = new VariableSubstitutionVisitor();
    private final Map<LogicalVariable, List<LogicalVariable>> equivalentVarsMap = new HashMap<LogicalVariable, List<LogicalVariable>>();
    protected boolean hasRun = false;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        this.equivalentVarsMap.clear();
        boolean modified = this.removeRedundantVariables(opRef, context);
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)opRef.getValue());
        }
        return modified;
    }

    private void updateEquivalenceClassMap(LogicalVariable lhs, LogicalVariable rhs) {
        List<LogicalVariable> equivalentVars = this.equivalentVarsMap.get(rhs);
        if (equivalentVars == null) {
            equivalentVars = new ArrayList<LogicalVariable>();
            equivalentVars.add(rhs);
            equivalentVars.add(lhs);
            this.equivalentVarsMap.put(rhs, equivalentVars);
        }
        this.equivalentVarsMap.put(lhs, equivalentVars);
        equivalentVars.get(0);
    }

    private boolean removeRedundantVariables(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        boolean modified = false;
        for (Mutable inputOpRef : op.getInputs()) {
            if (!this.removeRedundantVariables((Mutable<ILogicalOperator>)inputOpRef, context)) continue;
            modified = true;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOp = (AssignOperator)op;
            int numVars = assignOp.getVariables().size();
            for (int i = 0; i < numVars; ++i) {
                ILogicalExpression expr = (ILogicalExpression)((Mutable)assignOp.getExpressions().get(i)).getValue();
                if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                VariableReferenceExpression rhsVarRefExpr = (VariableReferenceExpression)expr;
                LogicalVariable lhs = (LogicalVariable)assignOp.getVariables().get(i);
                LogicalVariable rhs = rhsVarRefExpr.getVariableReference();
                this.updateEquivalenceClassMap(lhs, rhs);
            }
        }
        if (op.getOperatorTag() == LogicalOperatorTag.PROJECT) {
            if (this.replaceProjectVars((ProjectOperator)op)) {
                modified = true;
            }
        } else if (op.getOperatorTag() == LogicalOperatorTag.UNIONALL) {
            if (this.replaceUnionAllVars((UnionAllOperator)op)) {
                modified = true;
            }
        } else if (op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.substVisitor)) {
            modified = true;
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opWithNestedPlan = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan nestedPlan : opWithNestedPlan.getNestedPlans()) {
                for (Mutable rootRef : nestedPlan.getRoots()) {
                    if (!this.removeRedundantVariables((Mutable<ILogicalOperator>)rootRef, context)) continue;
                    modified = true;
                }
            }
        }
        if (op.getOperatorTag() == LogicalOperatorTag.GROUP && this.handleGroupByVarRemapping((GroupByOperator)op)) {
            modified = true;
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        }
        return modified;
    }

    private boolean handleGroupByVarRemapping(GroupByOperator groupOp) {
        boolean modified = false;
        block0: for (Pair gp : groupOp.getGroupByList()) {
            if (gp.first == null || ((ILogicalExpression)((Mutable)gp.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            LogicalVariable groupByVar = ((VariableReferenceExpression)((Mutable)gp.second).getValue()).getVariableReference();
            Iterator iter = groupOp.getDecorList().iterator();
            while (iter.hasNext()) {
                LogicalVariable dv;
                Pair dp = (Pair)iter.next();
                if (dp.first != null || ((ILogicalExpression)((Mutable)dp.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE || (dv = ((VariableReferenceExpression)((Mutable)dp.second).getValue()).getVariableReference()) != groupByVar) continue;
                List<LogicalVariable> equivalentVars = this.equivalentVarsMap.get(groupByVar);
                if (equivalentVars != null) {
                    equivalentVars.set(0, (LogicalVariable)gp.first);
                    this.equivalentVarsMap.put((LogicalVariable)gp.first, equivalentVars);
                } else {
                    this.updateEquivalenceClassMap((LogicalVariable)gp.first, groupByVar);
                }
                iter.remove();
                modified = true;
                continue block0;
            }
        }
        return modified;
    }

    private boolean replaceProjectVars(ProjectOperator op) throws AlgebricksException {
        List vars = op.getVariables();
        int size = vars.size();
        boolean modified = false;
        for (int i = 0; i < size; ++i) {
            LogicalVariable representative;
            LogicalVariable var = (LogicalVariable)vars.get(i);
            List<LogicalVariable> equivalentVars = this.equivalentVarsMap.get(var);
            if (equivalentVars == null || (representative = equivalentVars.get(0)) == var) continue;
            vars.set(i, equivalentVars.get(0));
            modified = true;
        }
        return modified;
    }

    private boolean replaceUnionAllVars(UnionAllOperator op) throws AlgebricksException {
        boolean modified = false;
        for (Triple varMapping : op.getVariableMappings()) {
            List<LogicalVariable> firstEquivalentVars = this.equivalentVarsMap.get(varMapping.first);
            List<LogicalVariable> secondEquivalentVars = this.equivalentVarsMap.get(varMapping.second);
            if (firstEquivalentVars != null) {
                varMapping.first = firstEquivalentVars.get(0);
                modified = true;
            }
            if (secondEquivalentVars == null) continue;
            varMapping.second = secondEquivalentVars.get(0);
            modified = true;
        }
        return modified;
    }

    private class VariableSubstitutionVisitor
    implements ILogicalExpressionReferenceTransform {
        private VariableSubstitutionVisitor() {
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) {
            ILogicalExpression e = (ILogicalExpression)exprRef.getValue();
            switch (((AbstractLogicalExpression)e).getExpressionTag()) {
                case VARIABLE: {
                    VariableReferenceExpression varRefExpr = (VariableReferenceExpression)e;
                    LogicalVariable var = varRefExpr.getVariableReference();
                    List equivalentVars = (List)RemoveRedundantVariablesRule.this.equivalentVarsMap.get(var);
                    if (equivalentVars == null) {
                        return false;
                    }
                    LogicalVariable representative = (LogicalVariable)equivalentVars.get(0);
                    if (representative != var) {
                        varRefExpr.setVariable(representative);
                        return true;
                    }
                    return false;
                }
                case FUNCTION_CALL: {
                    AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)e;
                    boolean modified = false;
                    for (Mutable arg : funcExpr.getArguments()) {
                        if (!this.transform((Mutable<ILogicalExpression>)arg)) continue;
                        modified = true;
                    }
                    return modified;
                }
            }
            return false;
        }
    }
}

