/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;

public class RemoveRedundantGroupByDecorVars
implements IAlgebraicRewriteRule {
    private final Set<LogicalVariable> vars = new HashSet<LogicalVariable>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        this.vars.clear();
        boolean modified = false;
        GroupByOperator groupOp = (GroupByOperator)op;
        Iterator iter = groupOp.getDecorList().iterator();
        while (iter.hasNext()) {
            Pair decor = (Pair)iter.next();
            if (decor.first != null || ((ILogicalExpression)((Mutable)decor.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            VariableReferenceExpression varRefExpr = (VariableReferenceExpression)((Mutable)decor.second).getValue();
            LogicalVariable var = varRefExpr.getVariableReference();
            if (this.vars.contains(var)) {
                iter.remove();
                modified = true;
                continue;
            }
            this.vars.add(var);
        }
        if (modified) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        }
        return modified;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }
}

