/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.mutable.Mutable;

public class PushSubplanWithAggregateDownThroughProductRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan = (SubplanOperator)op1;
        if (subplan.getNestedPlans().size() != 1) {
            return false;
        }
        ILogicalPlan p = (ILogicalPlan)subplan.getNestedPlans().get(0);
        if (p.getRoots().size() != 1) {
            return false;
        }
        Mutable r = (Mutable)p.getRoots().get(0);
        if (((AbstractLogicalOperator)r.getValue()).getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        HashSet free = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInSubplans((AbstractOperatorWithNestedPlans)subplan, free);
        Mutable op2Ref = (Mutable)op1.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op2Ref.getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op2;
        if (!OperatorPropertiesUtil.isAlwaysTrueCond((ILogicalExpression)((ILogicalExpression)join.getCondition().getValue()))) {
            return false;
        }
        Mutable b0Ref = (Mutable)op2.getInputs().get(0);
        ILogicalOperator b0 = (ILogicalOperator)b0Ref.getValue();
        ArrayList b0Scm = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)b0, b0Scm);
        if (b0Scm.containsAll(free)) {
            op2Ref.setValue((Object)b0);
            b0Ref.setValue((Object)op1);
            opRef.setValue((Object)op2);
            return true;
        }
        Mutable b1Ref = (Mutable)op2.getInputs().get(1);
        ILogicalOperator b1 = (ILogicalOperator)b1Ref.getValue();
        ArrayList b1Scm = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)b1, b1Scm);
        if (b1Scm.containsAll(free)) {
            op2Ref.setValue((Object)b1);
            b1Ref.setValue((Object)op1);
            opRef.setValue((Object)op2);
            return true;
        }
        return false;
    }
}

