/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.ListSet;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.Collection;
import org.apache.commons.lang3.mutable.Mutable;

public class LeftOuterJoinToInnerJoinRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        Mutable op2Ref = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op2Ref.getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        SelectOperator selectOp = (SelectOperator)op;
        LeftOuterJoinOperator joinOp = (LeftOuterJoinOperator)op2;
        ILogicalExpression condition = (ILogicalExpression)selectOp.getCondition().getValue();
        if (condition.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        ScalarFunctionCallExpression func = (ScalarFunctionCallExpression)condition;
        if (!this.convertable(func, joinOp)) {
            return false;
        }
        InnerJoinOperator newJoin = new InnerJoinOperator(joinOp.getCondition(), (Mutable)joinOp.getInputs().get(0), (Mutable)joinOp.getInputs().get(1));
        opRef.setValue((Object)newJoin);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newJoin);
        return true;
    }

    private boolean convertable(ScalarFunctionCallExpression func, LeftOuterJoinOperator join) throws AlgebricksException {
        if (func.getFunctionIdentifier() != AlgebricksBuiltinFunctions.NOT) {
            return false;
        }
        ILogicalExpression arg = (ILogicalExpression)((Mutable)func.getArguments().get(0)).getValue();
        if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        ScalarFunctionCallExpression func2 = (ScalarFunctionCallExpression)arg;
        if (func2.getFunctionIdentifier() != AlgebricksBuiltinFunctions.IS_NULL) {
            return false;
        }
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)func2.getArguments().get(0)).getValue();
        if (arg2.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        VariableReferenceExpression varExpr = (VariableReferenceExpression)arg2;
        LogicalVariable var = varExpr.getVariableReference();
        ListSet leftVars = new ListSet();
        ListSet rightVars = new ListSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)join.getInputs().get(0)).getValue()), (Collection)leftVars);
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)join.getInputs().get(1)).getValue()), (Collection)rightVars);
        return rightVars.contains((Object)var);
    }
}

