/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Triple;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class IntroduceProjectsRule
implements IAlgebraicRewriteRule {
    private final Set<LogicalVariable> usedVars = new HashSet<LogicalVariable>();
    private final Set<LogicalVariable> liveVars = new HashSet<LogicalVariable>();
    private final Set<LogicalVariable> producedVars = new HashSet<LogicalVariable>();
    private final List<LogicalVariable> projectVars = new ArrayList<LogicalVariable>();
    protected boolean hasRun = false;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.hasRun) {
            return false;
        }
        this.hasRun = true;
        return this.introduceProjects(null, -1, opRef, Collections.emptySet(), context);
    }

    protected boolean introduceProjects(AbstractLogicalOperator parentOp, int parentInputIndex, Mutable<ILogicalOperator> opRef, Set<LogicalVariable> parentUsedVars, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        boolean modified = false;
        this.usedVars.clear();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, this.usedVars);
        HashSet<LogicalVariable> parentsUsedVars = new HashSet<LogicalVariable>();
        parentsUsedVars.addAll(parentUsedVars);
        parentsUsedVars.addAll(this.usedVars);
        for (int i = 0; i < op.getInputs().size(); ++i) {
            Mutable inputOpRef = (Mutable)op.getInputs().get(i);
            if (!this.introduceProjects(op, i, (Mutable<ILogicalOperator>)inputOpRef, parentsUsedVars, context)) continue;
            modified = true;
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        }
        this.liveVars.clear();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, this.liveVars);
        this.producedVars.clear();
        VariableUtilities.getProducedVariables((ILogicalOperator)op, this.producedVars);
        this.liveVars.removeAll(this.producedVars);
        this.projectVars.clear();
        for (LogicalVariable liveVar : this.liveVars) {
            if (!parentsUsedVars.contains(liveVar)) continue;
            this.projectVars.add(liveVar);
        }
        if (this.projectVars.size() != this.liveVars.size()) {
            for (int i = 0; i < op.getInputs().size(); ++i) {
                ILogicalOperator childOp = (ILogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
                this.liveVars.clear();
                VariableUtilities.getLiveVariables((ILogicalOperator)childOp, this.liveVars);
                ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
                vars.addAll(this.projectVars);
                vars.retainAll(this.liveVars);
                if (vars.size() == this.liveVars.size()) continue;
                ProjectOperator projectOp = new ProjectOperator(vars);
                projectOp.getInputs().add(new MutableObject((Object)childOp));
                ((Mutable)op.getInputs().get(i)).setValue((Object)projectOp);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)projectOp);
                modified = true;
            }
        } else if (op.getOperatorTag() == LogicalOperatorTag.PROJECT) {
            this.liveVars.clear();
            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()), this.liveVars);
            ProjectOperator projectOp = (ProjectOperator)op;
            List projectVars = projectOp.getVariables();
            if (this.liveVars.size() == projectVars.size() && this.liveVars.containsAll(projectVars)) {
                boolean eliminateProject = true;
                if (parentOp.getOperatorTag() == LogicalOperatorTag.UNIONALL) {
                    eliminateProject = this.canEliminateProjectBelowUnion((UnionAllOperator)parentOp, projectOp, parentInputIndex);
                }
                if (eliminateProject) {
                    ((Mutable)parentOp.getInputs().get(parentInputIndex)).setValue(((Mutable)op.getInputs().get(0)).getValue());
                }
            }
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        }
        return modified;
    }

    private boolean canEliminateProjectBelowUnion(UnionAllOperator unionOp, ProjectOperator projectOp, int unionInputIndex) throws AlgebricksException {
        ArrayList orderedLiveVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)projectOp.getInputs().get(0)).getValue()), orderedLiveVars);
        int numVars = orderedLiveVars.size();
        for (int i = 0; i < numVars; ++i) {
            Triple varTriple = (Triple)unionOp.getVariableMappings().get(i);
            if (!(unionInputIndex == 0 ? varTriple.first != orderedLiveVars.get(i) : varTriple.second != orderedLiveVars.get(i))) continue;
            return false;
        }
        return true;
    }
}

