/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypingContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import edu.uci.ics.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import edu.uci.ics.hyracks.algebricks.core.config.AlgebricksConfig;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import edu.uci.ics.hyracks.algebricks.rewriter.util.PhysicalOptimizationsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class IntroduceGroupByForSubplanRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator b1;
        AbstractLogicalOperator op2;
        AbstractLogicalOperator op0 = (AbstractLogicalOperator)opRef.getValue();
        if (op0.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan = (SubplanOperator)op0;
        Iterator plansIter = subplan.getNestedPlans().iterator();
        ILogicalPlan p = null;
        while (plansIter.hasNext()) {
            p = (ILogicalPlan)plansIter.next();
        }
        if (p == null) {
            return false;
        }
        if (p.getRoots().size() != 1) {
            return false;
        }
        Mutable subplanRoot = (Mutable)p.getRoots().get(0);
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)subplanRoot.getValue();
        Mutable botRef = subplanRoot;
        if (op1.getOperatorTag() != LogicalOperatorTag.PROJECT) {
            op2 = op1;
        } else {
            ProjectOperator project = (ProjectOperator)op1;
            botRef = (Mutable)project.getInputs().get(0);
            op2 = (AbstractLogicalOperator)botRef.getValue();
        }
        if (op2.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator aggregate = (AggregateOperator)op2;
        HashSet<LogicalVariable> free = new HashSet<LogicalVariable>();
        VariableUtilities.getUsedVariables((ILogicalOperator)aggregate, free);
        Mutable op3Ref = (Mutable)aggregate.getInputs().get(0);
        AbstractLogicalOperator op3 = (AbstractLogicalOperator)op3Ref.getValue();
        while (op3.getInputs().size() == 1) {
            HashSet prod = new HashSet();
            VariableUtilities.getProducedVariables((ILogicalOperator)op3, prod);
            free.removeAll(prod);
            VariableUtilities.getUsedVariables((ILogicalOperator)op3, free);
            botRef = op3Ref;
            op3Ref = (Mutable)op3.getInputs().get(0);
            op3 = (AbstractLogicalOperator)op3Ref.getValue();
        }
        if (op3.getOperatorTag() != LogicalOperatorTag.INNERJOIN && op3.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op3;
        if (join.getCondition().getValue() == ConstantExpression.TRUE) {
            return false;
        }
        VariableUtilities.getUsedVariables((ILogicalOperator)join, free);
        AbstractLogicalOperator b0 = (AbstractLogicalOperator)((Mutable)join.getInputs().get(0)).getValue();
        NestedTupleSourceOperator outerNts = this.getNts(b0);
        if (outerNts == null && (outerNts = this.getNts(b1 = (AbstractLogicalOperator)((Mutable)join.getInputs().get(1)).getValue())) == null) {
            return false;
        }
        Set<LogicalVariable> pkVars = this.computeGbyVars((AbstractLogicalOperator)outerNts, free, context);
        if (pkVars == null || pkVars.size() < 1) {
            ILogicalOperator subplanInput = (ILogicalOperator)((Mutable)subplan.getInputs().get(0)).getValue();
            pkVars = new HashSet<LogicalVariable>();
            VariableUtilities.getLiveVariables((ILogicalOperator)subplanInput, pkVars);
        }
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine("Found FD for introducing group-by: " + pkVars);
        Mutable rightRef = (Mutable)join.getInputs().get(1);
        LogicalVariable testForNull = null;
        AbstractLogicalOperator right = (AbstractLogicalOperator)rightRef.getValue();
        switch (right.getOperatorTag()) {
            case UNNEST: {
                UnnestOperator innerUnnest = (UnnestOperator)right;
                testForNull = innerUnnest.getVariable();
                break;
            }
            case DATASOURCESCAN: {
                DataSourceScanOperator innerScan = (DataSourceScanOperator)right;
                if (innerScan.getVariables().size() != 1) break;
                testForNull = (LogicalVariable)innerScan.getVariables().get(0);
                break;
            }
        }
        if (testForNull == null) {
            testForNull = context.newVar();
            AssignOperator tmpAsgn = new AssignOperator(testForNull, (Mutable)new MutableObject((Object)ConstantExpression.TRUE));
            tmpAsgn.getInputs().add(new MutableObject(rightRef.getValue()));
            rightRef.setValue((Object)tmpAsgn);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)tmpAsgn);
        }
        IFunctionInfo finfoEq = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.IS_NULL);
        ScalarFunctionCallExpression isNullTest = new ScalarFunctionCallExpression(finfoEq, new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(testForNull))});
        IFunctionInfo finfoNot = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.NOT);
        ScalarFunctionCallExpression nonNullTest = new ScalarFunctionCallExpression(finfoNot, new Mutable[]{new MutableObject((Object)isNullTest)});
        SelectOperator selectNonNull = new SelectOperator((Mutable)new MutableObject((Object)nonNullTest));
        GroupByOperator g = new GroupByOperator();
        MutableObject newSubplanRef = new MutableObject((Object)subplan);
        NestedTupleSourceOperator nts = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)g));
        opRef.setValue((Object)g);
        selectNonNull.getInputs().add(new MutableObject((Object)nts));
        List prodInpList = ((ILogicalOperator)botRef.getValue()).getInputs();
        prodInpList.clear();
        prodInpList.add(new MutableObject((Object)selectNonNull));
        ALogicalPlanImpl gPlan = new ALogicalPlanImpl((Mutable)new MutableObject(subplanRoot.getValue()));
        g.getNestedPlans().add(gPlan);
        subplanRoot.setValue(op3Ref.getValue());
        g.getInputs().add(newSubplanRef);
        HashSet underVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)subplan.getInputs().get(0)).getValue()), underVars);
        underVars.removeAll(pkVars);
        Map<LogicalVariable, LogicalVariable> mappedVars = this.buildVarExprList(pkVars, context, g, g.getGroupByList());
        context.updatePrimaryKeys(mappedVars);
        for (LogicalVariable uv : underVars) {
            g.getDecorList().add(new Pair(null, (Object)new MutableObject((Object)new VariableReferenceExpression(uv))));
        }
        OperatorPropertiesUtil.typeOpRec((Mutable)subplanRoot, (IOptimizationContext)context);
        OperatorPropertiesUtil.typeOpRec((Mutable)((Mutable)gPlan.getRoots().get(0)), (IOptimizationContext)context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)g);
        return true;
    }

    private NestedTupleSourceOperator getNts(AbstractLogicalOperator op) {
        AbstractLogicalOperator alo = op;
        while (alo.getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
            if (alo.getInputs().size() != 1) {
                return null;
            }
            alo = (AbstractLogicalOperator)((Mutable)alo.getInputs().get(0)).getValue();
        }
        return (NestedTupleSourceOperator)alo;
    }

    protected Set<LogicalVariable> computeGbyVars(AbstractLogicalOperator op, Set<LogicalVariable> freeVars, IOptimizationContext context) throws AlgebricksException {
        PhysicalOptimizationsUtil.computeFDsAndEquivalenceClasses(op, context);
        List fdList = context.getFDList((ILogicalOperator)op);
        if (fdList == null) {
            return null;
        }
        ArrayList all = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, all);
        all.retainAll(freeVars);
        for (FunctionalDependency fd : fdList) {
            if (!fd.getTail().containsAll(all)) continue;
            return new HashSet<LogicalVariable>(fd.getHead());
        }
        return null;
    }

    private Map<LogicalVariable, LogicalVariable> buildVarExprList(Collection<LogicalVariable> vars, IOptimizationContext context, GroupByOperator g, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> outVeList) throws AlgebricksException {
        HashMap<LogicalVariable, LogicalVariable> m = new HashMap<LogicalVariable, LogicalVariable>();
        for (LogicalVariable ov : vars) {
            LogicalVariable newVar = context.newVar();
            VariableReferenceExpression varExpr = new VariableReferenceExpression(newVar);
            outVeList.add((Pair<LogicalVariable, Mutable<ILogicalExpression>>)new Pair((Object)ov, (Object)new MutableObject((Object)varExpr)));
            for (ILogicalPlan p : g.getNestedPlans()) {
                for (Mutable r : p.getRoots()) {
                    OperatorManipulationUtil.substituteVarRec((AbstractLogicalOperator)((AbstractLogicalOperator)r.getValue()), (LogicalVariable)ov, (LogicalVariable)newVar, (boolean)true, (ITypingContext)context);
                }
            }
            AbstractLogicalOperator opUnder = (AbstractLogicalOperator)((Mutable)g.getInputs().get(0)).getValue();
            OperatorManipulationUtil.substituteVarRec((AbstractLogicalOperator)opUnder, (LogicalVariable)ov, (LogicalVariable)newVar, (boolean)true, (ITypingContext)context);
            m.put(ov, newVar);
        }
        return m;
    }
}

