/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Triple;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.StreamProjectPOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class InsertProjectBeforeUnionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.UNIONALL) {
            return false;
        }
        UnionAllOperator opUnion = (UnionAllOperator)op;
        List varMap = opUnion.getVariableMappings();
        ArrayList<LogicalVariable> usedVariablesFromOne = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> usedVariablesFromTwo = new ArrayList<LogicalVariable>();
        for (Triple triple : varMap) {
            usedVariablesFromOne.add((LogicalVariable)triple.first);
            usedVariablesFromTwo.add((LogicalVariable)triple.second);
        }
        ArrayList<LogicalVariable> inputSchemaOne = new ArrayList<LogicalVariable>();
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)opUnion.getInputs().get(0)).getValue()), inputSchemaOne);
        ArrayList<LogicalVariable> inputSchemaTwo = new ArrayList<LogicalVariable>();
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)opUnion.getInputs().get(1)).getValue()), inputSchemaTwo);
        boolean rewritten = false;
        if (!this.isIdentical(usedVariablesFromOne, inputSchemaOne)) {
            this.insertProjectOperator(opUnion, 0, usedVariablesFromOne, context);
            rewritten = true;
        }
        if (!this.isIdentical(usedVariablesFromTwo, inputSchemaTwo)) {
            this.insertProjectOperator(opUnion, 1, usedVariablesFromTwo, context);
            rewritten = true;
        }
        return rewritten;
    }

    private void insertProjectOperator(UnionAllOperator opUnion, int branch, ArrayList<LogicalVariable> usedVariables, IOptimizationContext context) throws AlgebricksException {
        ProjectOperator projectOp = new ProjectOperator(usedVariables);
        ILogicalOperator parentOp = (ILogicalOperator)((Mutable)opUnion.getInputs().get(branch)).getValue();
        projectOp.getInputs().add(new MutableObject((Object)parentOp));
        ((Mutable)opUnion.getInputs().get(branch)).setValue((Object)projectOp);
        projectOp.setPhysicalOperator((IPhysicalOperator)new StreamProjectPOperator());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)projectOp);
        context.computeAndSetTypeEnvironmentForOperator(parentOp);
    }

    private boolean isIdentical(List<LogicalVariable> finalSchema, List<LogicalVariable> inputSchema) throws AlgebricksException {
        int inputSchemaSize;
        int finalSchemaSize = finalSchema.size();
        if (finalSchemaSize != (inputSchemaSize = inputSchema.size())) {
            return false;
        }
        for (int i = 0; i < finalSchemaSize; ++i) {
            LogicalVariable var2;
            LogicalVariable var1 = finalSchema.get(i);
            if (var1.equals((Object)(var2 = inputSchema.get(i)))) continue;
            return false;
        }
        return true;
    }
}

