/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.Iterator;
import org.apache.commons.lang3.mutable.Mutable;

public class InsertOuterJoinRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op0 = (AbstractLogicalOperator)opRef.getValue();
        if (op0.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan = (SubplanOperator)op0;
        Iterator plansIter = subplan.getNestedPlans().iterator();
        ILogicalPlan p = null;
        while (plansIter.hasNext()) {
            p = (ILogicalPlan)plansIter.next();
        }
        if (p == null) {
            return false;
        }
        if (p.getRoots().size() != 1) {
            return false;
        }
        Mutable subplanRoot = (Mutable)p.getRoots().get(0);
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)subplanRoot.getValue();
        Mutable opUnder = (Mutable)subplan.getInputs().get(0);
        if (OperatorPropertiesUtil.isNullTest((AbstractLogicalOperator)((AbstractLogicalOperator)opUnder.getValue()))) {
            return false;
        }
        switch (op1.getOperatorTag()) {
            case INNERJOIN: {
                InnerJoinOperator join = (InnerJoinOperator)op1;
                Mutable leftRef = (Mutable)join.getInputs().get(0);
                Mutable rightRef = (Mutable)join.getInputs().get(1);
                Mutable<ILogicalOperator> ntsRef = this.getNtsAtEndOfPipeline((Mutable<ILogicalOperator>)leftRef);
                if (ntsRef == null) {
                    ntsRef = this.getNtsAtEndOfPipeline((Mutable<ILogicalOperator>)rightRef);
                    if (ntsRef == null) {
                        return false;
                    }
                    Mutable t = leftRef;
                    leftRef = rightRef;
                    rightRef = t;
                }
                ntsRef.setValue(opUnder.getValue());
                LeftOuterJoinOperator loj = new LeftOuterJoinOperator(join.getCondition());
                loj.getInputs().add(leftRef);
                loj.getInputs().add(rightRef);
                opRef.setValue((Object)loj);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)loj);
                return true;
            }
            case LEFTOUTERJOIN: {
                LeftOuterJoinOperator join = (LeftOuterJoinOperator)op1;
                Mutable leftRef = (Mutable)join.getInputs().get(0);
                Mutable<ILogicalOperator> ntsRef = this.getNtsAtEndOfPipeline((Mutable<ILogicalOperator>)leftRef);
                if (ntsRef == null) {
                    return false;
                }
                ntsRef.setValue(opUnder.getValue());
                opRef.setValue((Object)join);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)join);
                return true;
            }
        }
        return false;
    }

    private Mutable<ILogicalOperator> getNtsAtEndOfPipeline(Mutable<ILogicalOperator> opRef) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return opRef;
        }
        if (op.getInputs().size() != 1) {
            return null;
        }
        return this.getNtsAtEndOfPipeline((Mutable<ILogicalOperator>)((Mutable)op.getInputs().get(0)));
    }
}

