/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;

public class InlineVariablesRule
implements IAlgebraicRewriteRule {
    protected Map<LogicalVariable, ILogicalExpression> varAssignRhs = new HashMap<LogicalVariable, ILogicalExpression>();
    protected InlineVariablesVisitor inlineVisitor = new InlineVariablesVisitor(this.varAssignRhs);
    protected Set<FunctionIdentifier> doNotInlineFuncs = new HashSet<FunctionIdentifier>();
    protected boolean hasRun = false;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.hasRun) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        this.prepare(context);
        boolean modified = this.inlineVariables(opRef, context);
        if (this.performFinalAction()) {
            modified = true;
        }
        this.hasRun = true;
        return modified;
    }

    protected void prepare(IOptimizationContext context) {
        this.varAssignRhs.clear();
        this.inlineVisitor.setContext(context);
    }

    protected boolean performBottomUpAction(AbstractLogicalOperator op) throws AlgebricksException {
        if (!op.requiresVariableReferenceExpressions()) {
            this.inlineVisitor.setOperator((ILogicalOperator)op);
            return op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.inlineVisitor);
        }
        return false;
    }

    protected boolean performFinalAction() throws AlgebricksException {
        return false;
    }

    protected boolean inlineVariables(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOp = (AssignOperator)op;
            List vars = assignOp.getVariables();
            List exprs = assignOp.getExpressions();
            for (int i = 0; i < vars.size(); ++i) {
                AbstractFunctionCallExpression funcExpr;
                ILogicalExpression expr = (ILogicalExpression)((Mutable)exprs.get(i)).getValue();
                if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && (this.doNotInlineFuncs.contains((funcExpr = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()) || !funcExpr.isFunctional())) continue;
                this.varAssignRhs.put((LogicalVariable)vars.get(i), (ILogicalExpression)((Mutable)exprs.get(i)).getValue());
            }
        }
        boolean modified = false;
        for (Mutable inputOpRef : op.getInputs()) {
            if (!this.inlineVariables((Mutable<ILogicalOperator>)inputOpRef, context)) continue;
            modified = true;
        }
        if (this.performBottomUpAction(op)) {
            modified = true;
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
            context.removeFromAlreadyCompared((ILogicalOperator)opRef.getValue());
        }
        return modified;
    }

    protected class InlineVariablesVisitor
    implements ILogicalExpressionReferenceTransform {
        private final Map<LogicalVariable, ILogicalExpression> varAssignRhs;
        private final Set<LogicalVariable> liveVars = new HashSet<LogicalVariable>();
        private final List<LogicalVariable> rhsUsedVars = new ArrayList<LogicalVariable>();
        private ILogicalOperator op;
        private IOptimizationContext context;
        private LogicalVariable targetVar;

        public InlineVariablesVisitor(Map<LogicalVariable, ILogicalExpression> varAssignRhs) {
            this.varAssignRhs = varAssignRhs;
        }

        public void setTargetVariable(LogicalVariable targetVar) {
            this.targetVar = targetVar;
        }

        public void setContext(IOptimizationContext context) {
            this.context = context;
        }

        public void setOperator(ILogicalOperator op) throws AlgebricksException {
            this.op = op;
            this.liveVars.clear();
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            ILogicalExpression e = (ILogicalExpression)exprRef.getValue();
            switch (((AbstractLogicalExpression)e).getExpressionTag()) {
                case VARIABLE: {
                    LogicalVariable var = ((VariableReferenceExpression)e).getVariableReference();
                    if (this.targetVar != null && var != this.targetVar) {
                        return false;
                    }
                    if (this.context.shouldNotBeInlined(var)) {
                        return false;
                    }
                    ILogicalExpression rhs = this.varAssignRhs.get(var);
                    if (rhs == null) {
                        return false;
                    }
                    if (this.liveVars.isEmpty()) {
                        VariableUtilities.getLiveVariables((ILogicalOperator)this.op, this.liveVars);
                    }
                    this.rhsUsedVars.clear();
                    rhs.getUsedVariables(this.rhsUsedVars);
                    for (LogicalVariable rhsUsedVar : this.rhsUsedVars) {
                        if (this.liveVars.contains(rhsUsedVar)) continue;
                        return false;
                    }
                    exprRef.setValue((Object)rhs.cloneExpression());
                    return true;
                }
                case FUNCTION_CALL: {
                    AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)e;
                    boolean modified = false;
                    for (Mutable arg : fce.getArguments()) {
                        if (!this.transform((Mutable<ILogicalExpression>)arg)) continue;
                        modified = true;
                    }
                    return modified;
                }
            }
            return false;
        }
    }
}

