/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import edu.uci.ics.hyracks.algebricks.rewriter.rules.InlineVariablesRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InlineSingleReferenceVariablesRule
extends InlineVariablesRule {
    protected Map<LogicalVariable, List<ILogicalOperator>> usedVarsMap = new HashMap<LogicalVariable, List<ILogicalOperator>>();
    protected List<LogicalVariable> usedVars = new ArrayList<LogicalVariable>();

    @Override
    protected void prepare(IOptimizationContext context) {
        super.prepare(context);
        this.usedVarsMap.clear();
        this.usedVars.clear();
    }

    @Override
    protected boolean performFinalAction() throws AlgebricksException {
        boolean modified = false;
        for (Map.Entry<LogicalVariable, List<ILogicalOperator>> entry : this.usedVarsMap.entrySet()) {
            ILogicalOperator op;
            if (entry.getValue().size() != 1 || (op = entry.getValue().get(0)).requiresVariableReferenceExpressions()) continue;
            this.inlineVisitor.setOperator(op);
            this.inlineVisitor.setTargetVariable(entry.getKey());
            if (op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.inlineVisitor)) {
                modified = true;
            }
            this.inlineVisitor.setTargetVariable(null);
        }
        return modified;
    }

    @Override
    protected boolean performBottomUpAction(AbstractLogicalOperator op) throws AlgebricksException {
        this.usedVars.clear();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, this.usedVars);
        for (LogicalVariable var : this.usedVars) {
            List<ILogicalOperator> opsUsingVar = this.usedVarsMap.get(var);
            if (opsUsingVar == null) {
                opsUsingVar = new ArrayList<ILogicalOperator>();
                this.usedVarsMap.put(var, opsUsingVar);
            }
            opsUsingVar.add((ILogicalOperator)op);
        }
        return false;
    }
}

