/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import edu.uci.ics.hyracks.algebricks.rewriter.rules.AbstractExtractExprRule;
import org.apache.commons.lang3.mutable.Mutable;

public class ExtractGbyExpressionsRule
extends AbstractExtractExprRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean fired;
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1)) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1);
        GroupByOperator g = (GroupByOperator)op1;
        boolean r1 = this.gbyExprWasRewritten(g, context);
        boolean r2 = this.decorExprWasRewritten(g, context);
        boolean bl = fired = r1 || r2;
        if (fired) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)g);
        }
        return fired;
    }

    private boolean gbyExprWasRewritten(GroupByOperator g, IOptimizationContext context) throws AlgebricksException {
        if (!this.gbyHasComplexExpr(g)) {
            return false;
        }
        Mutable opRef2 = (Mutable)g.getInputs().get(0);
        for (Pair gbyPair : g.getGroupByList()) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)gbyPair.second).getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
            LogicalVariable v = this.extractExprIntoAssignOpRef(expr, (Mutable<ILogicalOperator>)opRef2, context);
            ((Mutable)gbyPair.second).setValue((Object)new VariableReferenceExpression(v));
        }
        return true;
    }

    private boolean decorExprWasRewritten(GroupByOperator g, IOptimizationContext context) throws AlgebricksException {
        if (!this.decorHasComplexExpr(g)) {
            return false;
        }
        Mutable opRef2 = (Mutable)g.getInputs().get(0);
        for (Pair decorPair : g.getDecorList()) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)decorPair.second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            LogicalVariable v = this.extractExprIntoAssignOpRef(expr, (Mutable<ILogicalOperator>)opRef2, context);
            ((Mutable)decorPair.second).setValue((Object)new VariableReferenceExpression(v));
        }
        return true;
    }

    private boolean gbyHasComplexExpr(GroupByOperator g) {
        for (Pair gbyPair : g.getGroupByList()) {
            if (((ILogicalExpression)((Mutable)gbyPair.second).getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
            return true;
        }
        return false;
    }

    private boolean decorHasComplexExpr(GroupByOperator g) {
        for (Pair gbyPair : g.getDecorList()) {
            if (((ILogicalExpression)((Mutable)gbyPair.second).getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
            return true;
        }
        return false;
    }
}

