/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AssignPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.OneToOneExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.ReplicatePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.StreamProjectPOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class ExtractCommonOperatorsRule
implements IAlgebraicRewriteRule {
    private HashMap<Mutable<ILogicalOperator>, List<Mutable<ILogicalOperator>>> childrenToParents = new HashMap();
    private List<Mutable<ILogicalOperator>> roots = new ArrayList<Mutable<ILogicalOperator>>();
    private List<Mutable<ILogicalOperator>> joins = new ArrayList<Mutable<ILogicalOperator>>();
    private List<List<Mutable<ILogicalOperator>>> equivalenceClasses = new ArrayList<List<Mutable<ILogicalOperator>>>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.WRITE && op.getOperatorTag() != LogicalOperatorTag.WRITE_RESULT && op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return false;
        }
        if (!this.roots.contains(op)) {
            this.roots.add((Mutable<ILogicalOperator>)new MutableObject((Object)op));
        }
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.WRITE && op.getOperatorTag() != LogicalOperatorTag.WRITE_RESULT && op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return false;
        }
        boolean rewritten = false;
        boolean changed = false;
        if (this.roots.size() > 0) {
            do {
                changed = false;
                this.topDownMaterialization(this.roots);
                this.removeNonJoinBuildBranchCandidates();
                this.genCandidates(context);
                this.removeTrivialShare();
                this.removeNonJoinBuildBranchCandidates();
                if (this.equivalenceClasses.size() > 0) {
                    changed = this.rewrite(context);
                }
                if (!rewritten) {
                    rewritten = changed;
                }
                this.equivalenceClasses.clear();
                this.childrenToParents.clear();
                this.joins.clear();
            } while (changed);
            this.roots.clear();
        }
        return rewritten;
    }

    private void removeTrivialShare() {
        for (List<Mutable<ILogicalOperator>> candidates : this.equivalenceClasses) {
            for (int i = candidates.size() - 1; i >= 0; --i) {
                Mutable<ILogicalOperator> opRef = candidates.get(i);
                AbstractLogicalOperator aop = (AbstractLogicalOperator)opRef.getValue();
                if (aop.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
                    aop = (AbstractLogicalOperator)((Mutable)aop.getInputs().get(0)).getValue();
                }
                if (aop.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) continue;
                candidates.remove(i);
            }
        }
        for (int i = this.equivalenceClasses.size() - 1; i >= 0; --i) {
            if (this.equivalenceClasses.get(i).size() >= 2) continue;
            this.equivalenceClasses.remove(i);
        }
    }

    private void removeNonJoinBuildBranchCandidates() {
        for (List<Mutable<ILogicalOperator>> candidates : this.equivalenceClasses) {
            for (int i = candidates.size() - 1; i >= 0; --i) {
                Mutable<ILogicalOperator> opRef = candidates.get(i);
                boolean reserve = false;
                for (Mutable<ILogicalOperator> join : this.joins) {
                    if (!this.isInJoinBuildBranch(join, opRef)) continue;
                    reserve = true;
                }
                if (reserve) continue;
                candidates.remove(i);
            }
        }
        for (int i = this.equivalenceClasses.size() - 1; i >= 0; --i) {
            if (this.equivalenceClasses.get(i).size() >= 2) continue;
            this.equivalenceClasses.remove(i);
        }
    }

    private boolean isInJoinBuildBranch(Mutable<ILogicalOperator> joinRef, Mutable<ILogicalOperator> opRef) {
        Mutable buildBranch = (Mutable)((ILogicalOperator)joinRef.getValue()).getInputs().get(1);
        while (!buildBranch.equals(opRef)) {
            AbstractLogicalOperator aop = (AbstractLogicalOperator)buildBranch.getValue();
            if (aop.getOperatorTag() == LogicalOperatorTag.INNERJOIN || aop.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN || ((ILogicalOperator)buildBranch.getValue()).getInputs().size() == 0) {
                return false;
            }
            buildBranch = (Mutable)((ILogicalOperator)buildBranch.getValue()).getInputs().get(0);
        }
        return true;
    }

    private boolean rewrite(IOptimizationContext context) throws AlgebricksException {
        boolean changed = false;
        for (List<Mutable<ILogicalOperator>> members : this.equivalenceClasses) {
            if (!this.rewriteForOneEquivalentClass(members, context)) continue;
            changed = true;
        }
        return changed;
    }

    private boolean rewriteForOneEquivalentClass(List<Mutable<ILogicalOperator>> members, IOptimizationContext context) throws AlgebricksException {
        ArrayList<Mutable<ILogicalOperator>> group = new ArrayList<Mutable<ILogicalOperator>>();
        boolean rewritten = false;
        while (members.size() > 0) {
            group.clear();
            Mutable<ILogicalOperator> candidate = members.remove(members.size() - 1);
            group.add(candidate);
            for (int i = members.size() - 1; i >= 0; --i) {
                Mutable<ILogicalOperator> peer = members.get(i);
                if (!IsomorphismUtilities.isOperatorIsomorphic((ILogicalOperator)((ILogicalOperator)candidate.getValue()), (ILogicalOperator)((ILogicalOperator)peer.getValue()))) continue;
                group.add(peer);
                members.remove(i);
            }
            ReplicateOperator rop = new ReplicateOperator(group.size());
            rop.setPhysicalOperator((IPhysicalOperator)new ReplicatePOperator());
            rop.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            MutableObject ropRef = new MutableObject((Object)rop);
            AbstractLogicalOperator aopCandidate = (AbstractLogicalOperator)candidate.getValue();
            if (aopCandidate.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
                rop.getInputs().add(candidate);
            } else {
                ExchangeOperator beforeExchange = new ExchangeOperator();
                beforeExchange.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
                beforeExchange.getInputs().add(candidate);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)beforeExchange);
                rop.getInputs().add(new MutableObject((Object)beforeExchange));
            }
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)rop);
            List<Mutable<ILogicalOperator>> parents = this.childrenToParents.get(candidate);
            for (Mutable<ILogicalOperator> parentRef : parents) {
                AbstractLogicalOperator parent = (AbstractLogicalOperator)parentRef.getValue();
                int n = parent.getInputs().indexOf(candidate);
                if (parent.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
                    parent.getInputs().set(n, ropRef);
                    continue;
                }
                ExchangeOperator exchange = new ExchangeOperator();
                exchange.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
                exchange.getInputs().add(ropRef);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchange);
                parent.getInputs().set(n, new MutableObject((Object)exchange));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)parent);
            }
            ArrayList liveVarsNew = new ArrayList();
            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)candidate.getValue()), liveVarsNew);
            ArrayList<MutableObject> assignExprs = new ArrayList<MutableObject>();
            for (LogicalVariable logicalVariable : liveVarsNew) {
                assignExprs.add(new MutableObject((Object)new VariableReferenceExpression(logicalVariable)));
            }
            for (Mutable mutable : group) {
                if (mutable.equals(candidate)) continue;
                ArrayList liveVars = new ArrayList();
                HashMap variableMappingBack = new HashMap();
                IsomorphismUtilities.mapVariablesTopDown((ILogicalOperator)((ILogicalOperator)mutable.getValue()), (ILogicalOperator)((ILogicalOperator)candidate.getValue()), variableMappingBack);
                for (int i = 0; i < liveVarsNew.size(); ++i) {
                    liveVars.add(variableMappingBack.get(liveVarsNew.get(i)));
                }
                AssignOperator assignOperator = new AssignOperator(liveVars, assignExprs);
                assignOperator.setPhysicalOperator((IPhysicalOperator)new AssignPOperator());
                ProjectOperator projectOperator = new ProjectOperator(liveVars);
                projectOperator.setPhysicalOperator((IPhysicalOperator)new StreamProjectPOperator());
                ExchangeOperator exchOp = new ExchangeOperator();
                exchOp.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
                exchOp.getInputs().add(ropRef);
                assignOperator.getInputs().add(new MutableObject((Object)exchOp));
                projectOperator.getInputs().add(new MutableObject((Object)assignOperator));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchOp);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOperator);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)projectOperator);
                List<Mutable<ILogicalOperator>> parentOpList = this.childrenToParents.get(mutable);
                for (Mutable<ILogicalOperator> parentOpRef : parentOpList) {
                    AssignOperator childOp;
                    AbstractLogicalOperator parentOpNext;
                    AbstractLogicalOperator parentOp = (AbstractLogicalOperator)parentOpRef.getValue();
                    int index = parentOp.getInputs().indexOf(mutable);
                    if (parentOp.getOperatorTag() == LogicalOperatorTag.EXCHANGE && (parentOpNext = (AbstractLogicalOperator)this.childrenToParents.get(parentOpRef).get(0).getValue()).isMap()) {
                        index = parentOpNext.getInputs().indexOf(parentOpRef);
                        parentOp = parentOpNext;
                    }
                    ExchangeOperator exchg = new ExchangeOperator();
                    exchg.setPhysicalOperator((IPhysicalOperator)new OneToOneExchangePOperator());
                    Object object = childOp = parentOp.getOperatorTag() == LogicalOperatorTag.PROJECT ? assignOperator : projectOperator;
                    if (parentOp.isMap()) {
                        parentOp.getInputs().set(index, new MutableObject((Object)childOp));
                    } else {
                        exchg.getInputs().add(new MutableObject((Object)childOp));
                        parentOp.getInputs().set(index, new MutableObject((Object)exchg));
                    }
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchg);
                }
            }
            rewritten = true;
        }
        return rewritten;
    }

    private void genCandidates(IOptimizationContext context) throws AlgebricksException {
        ArrayList previousEquivalenceClasses = new ArrayList();
        while (this.equivalenceClasses.size() > 0) {
            previousEquivalenceClasses.clear();
            for (List<Mutable<ILogicalOperator>> candidates : this.equivalenceClasses) {
                ArrayList<Mutable<ILogicalOperator>> candidatesCopy = new ArrayList<Mutable<ILogicalOperator>>();
                candidatesCopy.addAll(candidates);
                previousEquivalenceClasses.add(candidatesCopy);
            }
            ArrayList<Mutable<ILogicalOperator>> currentLevelOpRefs = new ArrayList<Mutable<ILogicalOperator>>();
            for (List<Mutable<ILogicalOperator>> candidates : this.equivalenceClasses) {
                if (candidates.size() > 0) {
                    for (Mutable<ILogicalOperator> opRef : candidates) {
                        List<Mutable<ILogicalOperator>> refs = this.childrenToParents.get(opRef);
                        if (refs == null) continue;
                        currentLevelOpRefs.addAll(refs);
                    }
                }
                if (currentLevelOpRefs.size() == 0) continue;
                this.candidatesGrow(currentLevelOpRefs, candidates);
            }
            if (currentLevelOpRefs.size() == 0) break;
            this.prune(context);
        }
        if (this.equivalenceClasses.size() < 1 && previousEquivalenceClasses.size() > 0) {
            this.equivalenceClasses.addAll(previousEquivalenceClasses);
            this.prune(context);
        }
    }

    private void topDownMaterialization(List<Mutable<ILogicalOperator>> tops) {
        ArrayList<Mutable<ILogicalOperator>> candidates = new ArrayList<Mutable<ILogicalOperator>>();
        ArrayList<Mutable<ILogicalOperator>> nextLevel = new ArrayList<Mutable<ILogicalOperator>>();
        for (Mutable<ILogicalOperator> op : tops) {
            AbstractLogicalOperator aop = (AbstractLogicalOperator)op.getValue();
            if (!(aop.getOperatorTag() != LogicalOperatorTag.INNERJOIN && aop.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN || this.joins.contains(op))) {
                this.joins.add(op);
            }
            for (Mutable opRef : ((ILogicalOperator)op.getValue()).getInputs()) {
                List<Mutable<ILogicalOperator>> opRefList = this.childrenToParents.get(opRef);
                if (opRefList == null) {
                    opRefList = new ArrayList<Mutable<ILogicalOperator>>();
                    this.childrenToParents.put((Mutable<ILogicalOperator>)opRef, opRefList);
                    nextLevel.add((Mutable<ILogicalOperator>)opRef);
                }
                opRefList.add(op);
            }
            if (((ILogicalOperator)op.getValue()).getInputs().size() != 0) continue;
            candidates.add(op);
        }
        if (this.equivalenceClasses.size() > 0) {
            this.equivalenceClasses.get(0).addAll(candidates);
        } else {
            this.equivalenceClasses.add(candidates);
        }
        if (nextLevel.size() > 0) {
            this.topDownMaterialization(nextLevel);
        }
    }

    private void candidatesGrow(List<Mutable<ILogicalOperator>> opList, List<Mutable<ILogicalOperator>> candidates) {
        ArrayList<Mutable<ILogicalOperator>> previousCandidates = new ArrayList<Mutable<ILogicalOperator>>();
        previousCandidates.addAll(candidates);
        candidates.clear();
        boolean validCandidate = false;
        for (Mutable<ILogicalOperator> op : opList) {
            for (Mutable inputRef : ((ILogicalOperator)op.getValue()).getInputs()) {
                validCandidate = false;
                for (Mutable mutable : previousCandidates) {
                    if (!((ILogicalOperator)inputRef.getValue()).equals(mutable.getValue())) continue;
                    validCandidate = true;
                }
                if (validCandidate) continue;
                break;
            }
            if (!validCandidate) continue;
            candidates.add(op);
        }
    }

    private void prune(IOptimizationContext context) throws AlgebricksException {
        ArrayList previousEquivalenceClasses = new ArrayList();
        for (List<Mutable<ILogicalOperator>> list : this.equivalenceClasses) {
            ArrayList<Mutable<ILogicalOperator>> candidatesCopy = new ArrayList<Mutable<ILogicalOperator>>();
            candidatesCopy.addAll(list);
            previousEquivalenceClasses.add(candidatesCopy);
        }
        this.equivalenceClasses.clear();
        for (List<Object> list : previousEquivalenceClasses) {
            int i;
            boolean[] reserved = new boolean[list.size()];
            for (i = 0; i < reserved.length; ++i) {
                reserved[i] = false;
            }
            for (i = list.size() - 1; i >= 0; --i) {
                if (reserved[i]) continue;
                ArrayList<Object> equivalentClass = new ArrayList<Object>();
                ILogicalOperator candidate = (ILogicalOperator)((Mutable)list.get(i)).getValue();
                equivalentClass.add(list.get(i));
                for (int j = i - 1; j >= 0; --j) {
                    ILogicalOperator peer = (ILogicalOperator)((Mutable)list.get(j)).getValue();
                    if (!IsomorphismUtilities.isOperatorIsomorphic((ILogicalOperator)candidate, (ILogicalOperator)peer)) continue;
                    reserved[i] = true;
                    reserved[j] = true;
                    equivalentClass.add(list.get(j));
                }
                if (equivalentClass.size() <= 1) continue;
                this.equivalenceClasses.add(equivalentClass);
                Collections.reverse(equivalentClass);
            }
            for (i = list.size() - 1; i >= 0; --i) {
                if (reserved[i]) continue;
                list.remove(i);
            }
        }
    }
}

