/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.exceptions.NotImplementedException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.FDsAndEquivClassesVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AbstractStableSortPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.BroadcastPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.ExternalGroupByPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.HashPartitionExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.HashPartitionMergeExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.InMemoryStableSortPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.PreSortedDistinctByPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.PreclusteredGroupByPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.RandomMergeExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.RangePartitionPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.SortMergeExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.StableSortPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.DefaultNodeGroupDomain;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.INodeDomain;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.LocalGroupingProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.OrderColumn;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.OrderedPartitionedProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.PropertiesUtil;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.RandomPartitioningProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import edu.uci.ics.hyracks.algebricks.core.config.AlgebricksConfig;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import edu.uci.ics.hyracks.algebricks.rewriter.util.PhysicalOptimizationsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class EnforceStructuralPropertiesRule
implements IAlgebraicRewriteRule {
    private static final INodeDomain DEFAULT_DOMAIN = new DefaultNodeGroupDomain("__DEFAULT");
    private PhysicalOptimizationConfig physicalOptimizationConfig;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getPhysicalOperator() == null) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        List fds = context.getFDList((ILogicalOperator)op);
        if (fds != null && !fds.isEmpty()) {
            return false;
        }
        this.physicalOptimizationConfig = context.getPhysicalOptimizationConfig();
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> Optimizing operator " + op.getPhysicalOperator() + ".\n");
        PhysicalOptimizationsUtil.computeFDsAndEquivalenceClasses(op, context);
        StructuralPropertiesVector pvector = new StructuralPropertiesVector((IPartitioningProperty)new RandomPartitioningProperty(null), new LinkedList());
        boolean changed = this.physOptimizeOp(opRef, (IPhysicalPropertiesVector)pvector, false, context);
        op.computeDeliveredPhysicalProperties(context);
        AlgebricksConfig.ALGEBRICKS_LOGGER.finest(">>>> Structural properties for " + op.getPhysicalOperator() + ": " + op.getDeliveredPhysicalProperties() + "\n");
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
        return changed;
    }

    private boolean physOptimizePlan(ILogicalPlan plan, IPhysicalPropertiesVector pvector, boolean nestedPlan, IOptimizationContext context) throws AlgebricksException {
        boolean changed = false;
        for (Mutable root : plan.getRoots()) {
            if (this.physOptimizeOp((Mutable<ILogicalOperator>)root, pvector, nestedPlan, context)) {
                changed = true;
            }
            AbstractLogicalOperator op = (AbstractLogicalOperator)root.getValue();
            op.computeDeliveredPhysicalProperties(context);
            AlgebricksConfig.ALGEBRICKS_LOGGER.finest(">>>> Structural properties for " + op.getPhysicalOperator() + ": " + op.getDeliveredPhysicalProperties() + "\n");
        }
        return changed;
    }

    private boolean physOptimizeOp(Mutable<ILogicalOperator> opRef, IPhysicalPropertiesVector required, boolean nestedPlan, IOptimizationContext context) throws AlgebricksException {
        boolean changed = false;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        this.optimizeUsingConstraintsAndEquivClasses(op);
        PhysicalRequirements pr = op.getRequiredPhysicalPropertiesForChildren(required);
        IPhysicalPropertiesVector[] reqdProperties = null;
        if (pr != null) {
            reqdProperties = pr.getRequiredProperties();
        }
        boolean opIsRedundantSort = false;
        INodeDomain childrenDomain = null;
        int j = 0;
        for (Mutable childRef : op.getInputs()) {
            AbstractLogicalOperator child = (AbstractLogicalOperator)childRef.getValue();
            if (this.physOptimizeOp((Mutable<ILogicalOperator>)childRef, reqdProperties[j], nestedPlan, context)) {
                changed = true;
            }
            child.computeDeliveredPhysicalProperties(context);
            IPhysicalPropertiesVector delivered = child.getDeliveredPhysicalProperties();
            if (childrenDomain == null) {
                childrenDomain = delivered.getPartitioningProperty().getNodeDomain();
            } else {
                INodeDomain dom2 = delivered.getPartitioningProperty().getNodeDomain();
                if (!childrenDomain.sameAs(dom2)) {
                    childrenDomain = DEFAULT_DOMAIN;
                }
            }
            ++j;
        }
        if (reqdProperties != null) {
            for (int k = 0; k < reqdProperties.length; ++k) {
                IPhysicalPropertiesVector pv = reqdProperties[k];
                IPartitioningProperty pp = pv.getPartitioningProperty();
                if (pp == null || pp.getNodeDomain() != null) continue;
                pp.setNodeDomain(childrenDomain);
            }
        }
        IPartitioningProperty firstDeliveredPartitioning = null;
        int i = 0;
        for (Mutable childRef : op.getInputs()) {
            IPartitioningProperty dpp;
            AbstractLogicalOperator child = (AbstractLogicalOperator)childRef.getValue();
            IPhysicalPropertiesVector delivered = child.getDeliveredPhysicalProperties();
            AlgebricksConfig.ALGEBRICKS_LOGGER.finest(">>>> Properties delivered by " + child.getPhysicalOperator() + ": " + delivered + "\n");
            IPartitioningRequirementsCoordinator prc = pr.getPartitioningCoordinator();
            Pair pbpp = prc.coordinateRequirements(reqdProperties[i].getPartitioningProperty(), firstDeliveredPartitioning, (ILogicalOperator)op, context);
            boolean mayExpandPartitioningProperties = (Boolean)pbpp.first;
            StructuralPropertiesVector rqd = new StructuralPropertiesVector((IPartitioningProperty)pbpp.second, reqdProperties[i].getLocalProperties());
            AlgebricksConfig.ALGEBRICKS_LOGGER.finest(">>>> Required properties for " + child.getPhysicalOperator() + ": " + rqd + "\n");
            IPhysicalPropertiesVector diff = delivered.getUnsatisfiedPropertiesFrom((IPhysicalPropertiesVector)rqd, mayExpandPartitioningProperties, context.getEquivalenceClassMap((ILogicalOperator)child), context.getFDList((ILogicalOperator)child));
            if (this.isRedundantSort(opRef, delivered, diff, context)) {
                opIsRedundantSort = true;
            }
            if (diff != null) {
                changed = true;
                this.addEnforcers(op, i, diff, (IPhysicalPropertiesVector)rqd, delivered, childrenDomain, nestedPlan, context);
                AbstractLogicalOperator newChild = (AbstractLogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
                if (newChild != child) {
                    delivered = newChild.getDeliveredPhysicalProperties();
                    IPhysicalPropertiesVector newDiff = this.newPropertiesDiff(newChild, (IPhysicalPropertiesVector)rqd, mayExpandPartitioningProperties, context);
                    AlgebricksConfig.ALGEBRICKS_LOGGER.finest(">>>> New properties diff: " + newDiff + "\n");
                    if (this.isRedundantSort(opRef, delivered, newDiff, context)) {
                        opIsRedundantSort = true;
                        break;
                    }
                }
            }
            if (firstDeliveredPartitioning == null && ((dpp = delivered.getPartitioningProperty()).getPartitioningType() == IPartitioningProperty.PartitioningType.ORDERED_PARTITIONED || dpp.getPartitioningType() == IPartitioningProperty.PartitioningType.UNORDERED_PARTITIONED)) {
                firstDeliveredPartitioning = dpp;
            }
            ++i;
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans nested = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : nested.getNestedPlans()) {
                if (!this.physOptimizePlan(p, required, true, context)) continue;
                changed = true;
            }
        }
        if (opIsRedundantSort) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> Removing redundant SORT operator " + op.getPhysicalOperator() + "\n");
            this.printOp(op);
            changed = true;
            AbstractLogicalOperator nextOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
            if (nextOp.getOperatorTag() == LogicalOperatorTag.PROJECT) {
                nextOp = (AbstractLogicalOperator)((Mutable)nextOp.getInputs().get(0)).getValue();
            }
            opRef.setValue((Object)nextOp);
            AbstractLogicalOperator transferTo = nextOp;
            if (transferTo.getOperatorTag() == LogicalOperatorTag.EXCHANGE) {
                transferTo = (AbstractLogicalOperator)((Mutable)transferTo.getInputs().get(0)).getValue();
            }
            transferTo.getAnnotations().putAll(op.getAnnotations());
            this.physOptimizeOp(opRef, required, nestedPlan, context);
        }
        return changed;
    }

    private IPhysicalPropertiesVector newPropertiesDiff(AbstractLogicalOperator newChild, IPhysicalPropertiesVector required, boolean mayExpandPartitioningProperties, IOptimizationContext context) throws AlgebricksException {
        IPhysicalPropertiesVector newDelivered = newChild.getDeliveredPhysicalProperties();
        Map newChildEqClasses = context.getEquivalenceClassMap((ILogicalOperator)newChild);
        List newChildFDs = context.getFDList((ILogicalOperator)newChild);
        if (newChildEqClasses == null || newChildFDs == null) {
            FDsAndEquivClassesVisitor fdsVisitor = new FDsAndEquivClassesVisitor();
            newChild.accept((ILogicalOperatorVisitor)fdsVisitor, (Object)context);
            newChildEqClasses = context.getEquivalenceClassMap((ILogicalOperator)newChild);
            newChildFDs = context.getFDList((ILogicalOperator)newChild);
        }
        AlgebricksConfig.ALGEBRICKS_LOGGER.finest(">>>> Required properties for new op. " + newChild.getPhysicalOperator() + ": " + required + "\n");
        return newDelivered.getUnsatisfiedPropertiesFrom(required, mayExpandPartitioningProperties, newChildEqClasses, newChildFDs);
    }

    private void optimizeUsingConstraintsAndEquivClasses(AbstractLogicalOperator op) {
        IPhysicalOperator pOp = op.getPhysicalOperator();
        switch (pOp.getOperatorTag()) {
            case HASH_GROUP_BY: 
            case EXTERNAL_GROUP_BY: {
                GroupByOperator gby = (GroupByOperator)op;
                ExternalGroupByPOperator hgbyOp = (ExternalGroupByPOperator)pOp;
                hgbyOp.computeColumnSet(gby.getGroupByList());
                break;
            }
            case PRE_CLUSTERED_GROUP_BY: {
                GroupByOperator gby = (GroupByOperator)op;
                PreclusteredGroupByPOperator preSortedGby = (PreclusteredGroupByPOperator)pOp;
                preSortedGby.setGbyColumns(gby.getGbyVarList());
                break;
            }
            case PRE_SORTED_DISTINCT_BY: {
                DistinctOperator d = (DistinctOperator)op;
                PreSortedDistinctByPOperator preSortedDistinct = (PreSortedDistinctByPOperator)pOp;
                preSortedDistinct.setDistinctByColumns(d.getDistinctByVarList());
                break;
            }
        }
    }

    private List<OrderColumn> getOrderColumnsFromGroupingProperties(List<ILocalStructuralProperty> reqd, List<ILocalStructuralProperty> dlvd) {
        LocalOrderProperty orderProp;
        int j;
        int prefix;
        ArrayList<OrderColumn> returnedProperties = new ArrayList<OrderColumn>();
        ArrayList rqdCols = new ArrayList();
        ArrayList dlvdCols = new ArrayList();
        for (ILocalStructuralProperty r : reqd) {
            r.getVariables(rqdCols);
        }
        for (ILocalStructuralProperty d : dlvd) {
            d.getVariables(dlvdCols);
        }
        for (prefix = dlvdCols.size() - 1; prefix >= 0 && !rqdCols.contains(dlvdCols.get(prefix)); --prefix) {
        }
        for (j = 0; j <= prefix; ++j) {
            orderProp = (LocalOrderProperty)dlvd.get(j);
            returnedProperties.add(new OrderColumn(orderProp.getColumn(), orderProp.getOrder()));
        }
        if (returnedProperties.size() != 0) {
            for (j = prefix + 1; j < dlvdCols.size(); ++j) {
                orderProp = (LocalOrderProperty)dlvd.get(j);
                returnedProperties.add(new OrderColumn(orderProp.getColumn(), orderProp.getOrder()));
            }
        }
        return returnedProperties;
    }

    private boolean isRedundantSort(Mutable<ILogicalOperator> opRef, IPhysicalPropertiesVector delivered, IPhysicalPropertiesVector diffOfProperties, IOptimizationContext context) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ORDER || op.getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.STABLE_SORT && op.getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.IN_MEMORY_STABLE_SORT || delivered.getLocalProperties() == null) {
            return false;
        }
        AbstractStableSortPOperator sortOp = (AbstractStableSortPOperator)op.getPhysicalOperator();
        sortOp.computeLocalProperties((ILogicalOperator)op);
        List orderProps = sortOp.getOrderProperties();
        return PropertiesUtil.matchLocalProperties((List)orderProps, (List)delivered.getLocalProperties(), (Map)context.getEquivalenceClassMap((ILogicalOperator)op), (List)context.getFDList((ILogicalOperator)op));
    }

    private void addEnforcers(AbstractLogicalOperator op, int childIndex, IPhysicalPropertiesVector diffPropertiesVector, IPhysicalPropertiesVector required, IPhysicalPropertiesVector deliveredByChild, INodeDomain domain, boolean nestedPlan, IOptimizationContext context) throws AlgebricksException {
        IPartitioningProperty pp = diffPropertiesVector.getPartitioningProperty();
        if (pp == null || pp.getPartitioningType() == IPartitioningProperty.PartitioningType.UNPARTITIONED) {
            this.addLocalEnforcers(op, childIndex, diffPropertiesVector.getLocalProperties(), nestedPlan, context);
            IPhysicalPropertiesVector deliveredByNewChild = ((AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getDeliveredPhysicalProperties();
            this.addPartitioningEnforcers((ILogicalOperator)op, childIndex, pp, required, deliveredByNewChild, domain, context);
        } else {
            this.addPartitioningEnforcers((ILogicalOperator)op, childIndex, pp, required, deliveredByChild, domain, context);
            AbstractLogicalOperator newChild = (AbstractLogicalOperator)((Mutable)op.getInputs().get(childIndex)).getValue();
            IPhysicalPropertiesVector newDiff = this.newPropertiesDiff(newChild, required, true, context);
            AlgebricksConfig.ALGEBRICKS_LOGGER.finest(">>>> New properties diff: " + newDiff + "\n");
            if (newDiff != null) {
                this.addLocalEnforcers(op, childIndex, newDiff.getLocalProperties(), nestedPlan, context);
            }
        }
    }

    private void addLocalEnforcers(AbstractLogicalOperator op, int i, List<ILocalStructuralProperty> localProperties, boolean nestedPlan, IOptimizationContext context) throws AlgebricksException {
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> Adding local enforcers for local props = " + localProperties + "\n");
        if (localProperties == null || localProperties.isEmpty()) {
            return;
        }
        Mutable<ILogicalOperator> topOp = new Mutable<ILogicalOperator>();
        topOp.setValue(((Mutable)op.getInputs().get(i)).getValue());
        LinkedList<LocalOrderProperty> oList = new LinkedList<LocalOrderProperty>();
        block4: for (ILocalStructuralProperty prop : localProperties) {
            switch (prop.getPropertyType()) {
                case LOCAL_ORDER_PROPERTY: {
                    oList.add((LocalOrderProperty)prop);
                    break;
                }
                case LOCAL_GROUPING_PROPERTY: {
                    LocalGroupingProperty g = (LocalGroupingProperty)prop;
                    Collection vars = g.getPreferredOrderEnforcer() != null ? g.getPreferredOrderEnforcer() : g.getColumnSet();
                    for (LogicalVariable v : vars) {
                        OrderColumn oc = new OrderColumn(v, OrderOperator.IOrder.OrderKind.ASC);
                        LocalOrderProperty lop = new LocalOrderProperty(oc);
                        oList.add(lop);
                    }
                    continue block4;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (!oList.isEmpty()) {
            topOp = this.enforceOrderProperties(oList, topOp, nestedPlan, context);
        }
        op.getInputs().set(i, topOp);
        OperatorPropertiesUtil.computeSchemaAndPropertiesRecIfNull((AbstractLogicalOperator)((AbstractLogicalOperator)topOp.getValue()), (IOptimizationContext)context);
        this.printOp((AbstractLogicalOperator)topOp.getValue());
    }

    private Mutable<ILogicalOperator> enforceOrderProperties(List<LocalOrderProperty> oList, Mutable<ILogicalOperator> topOp, boolean isMicroOp, IOptimizationContext context) throws AlgebricksException {
        LinkedList<Pair> oe = new LinkedList<Pair>();
        for (LocalOrderProperty o : oList) {
            OrderOperator.IOrder ordType = o.getOrder() == OrderOperator.IOrder.OrderKind.ASC ? OrderOperator.ASC_ORDER : OrderOperator.DESC_ORDER;
            Pair pair = new Pair((Object)ordType, (Object)new MutableObject((Object)new VariableReferenceExpression(o.getColumn())));
            oe.add(pair);
        }
        OrderOperator oo = new OrderOperator(oe);
        oo.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        if (isMicroOp) {
            oo.setPhysicalOperator((IPhysicalOperator)new InMemoryStableSortPOperator());
        } else {
            oo.setPhysicalOperator((IPhysicalOperator)new StableSortPOperator(this.physicalOptimizationConfig.getMaxFramesExternalSort()));
        }
        oo.getInputs().add(topOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)oo);
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> Added sort enforcer " + oo.getPhysicalOperator() + ".\n");
        return new MutableObject((Object)oo);
    }

    private void addPartitioningEnforcers(ILogicalOperator op, int i, IPartitioningProperty pp, IPhysicalPropertiesVector required, IPhysicalPropertiesVector deliveredByChild, INodeDomain domain, IOptimizationContext context) throws AlgebricksException {
        if (pp != null) {
            BroadcastPOperator pop;
            switch (pp.getPartitioningType()) {
                case UNPARTITIONED: {
                    List<OrderColumn> ordCols = this.computeOrderColumns(deliveredByChild);
                    if (ordCols == null || ordCols.size() == 0) {
                        pop = new RandomMergeExchangePOperator();
                        break;
                    }
                    OrderColumn[] sortColumns = new OrderColumn[ordCols.size()];
                    sortColumns = ordCols.toArray(sortColumns);
                    pop = new SortMergeExchangePOperator(sortColumns);
                    break;
                }
                case UNORDERED_PARTITIONED: {
                    List fds;
                    AbstractLogicalOperator c;
                    Map ecs;
                    ArrayList varList = new ArrayList(((UnorderedPartitionedProperty)pp).getColumnSet());
                    List cldLocals = deliveredByChild.getLocalProperties();
                    List reqdLocals = required.getLocalProperties();
                    boolean propWasSet = false;
                    pop = null;
                    if (reqdLocals != null && cldLocals != null && this.allAreOrderProps(cldLocals) && PropertiesUtil.matchLocalProperties((List)reqdLocals, (List)cldLocals, (Map)(ecs = context.getEquivalenceClassMap((ILogicalOperator)(c = (AbstractLogicalOperator)((Mutable)op.getInputs().get(i)).getValue()))), (List)(fds = context.getFDList((ILogicalOperator)c)))) {
                        List<OrderColumn> orderColumns = this.getOrderColumnsFromGroupingProperties(reqdLocals, cldLocals);
                        pop = new HashPartitionMergeExchangePOperator(orderColumns, varList, domain);
                        propWasSet = true;
                    }
                    if (propWasSet) break;
                    pop = new HashPartitionExchangePOperator(varList, domain);
                    break;
                }
                case ORDERED_PARTITIONED: {
                    pop = new RangePartitionPOperator(((OrderedPartitionedProperty)pp).getOrderColumns(), domain);
                    break;
                }
                case BROADCAST: {
                    pop = new BroadcastPOperator(domain);
                    break;
                }
                case RANDOM: {
                    RandomPartitioningProperty rpp = (RandomPartitioningProperty)pp;
                    INodeDomain nd = rpp.getNodeDomain();
                    if (nd == null) {
                        throw new AlgebricksException("Unknown node domain for " + rpp);
                    }
                    if (nd.cardinality() == null) {
                        throw new AlgebricksException("Unknown cardinality for node domain " + nd);
                    }
                    if (nd.cardinality() != 1) {
                        throw new NotImplementedException("Random repartitioning is only implemented for target domains ofcardinality equal to 1.");
                    }
                    pop = new BroadcastPOperator(nd);
                    break;
                }
                default: {
                    throw new NotImplementedException("Enforcer for " + pp.getPartitioningType() + " partitioning type has not been implemented.");
                }
            }
            Mutable ci = (Mutable)op.getInputs().get(i);
            ExchangeOperator exchg = new ExchangeOperator();
            exchg.setPhysicalOperator((IPhysicalOperator)pop);
            this.setNewOp((Mutable<ILogicalOperator>)ci, (AbstractLogicalOperator)exchg, context);
            exchg.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            OperatorPropertiesUtil.computeSchemaAndPropertiesRecIfNull((AbstractLogicalOperator)exchg, (IOptimizationContext)context);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchg);
            AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> Added partitioning enforcer " + exchg.getPhysicalOperator() + ".\n");
            this.printOp((AbstractLogicalOperator)op);
        }
    }

    private boolean allAreOrderProps(List<ILocalStructuralProperty> cldLocals) {
        for (ILocalStructuralProperty lsp : cldLocals) {
            if (lsp.getPropertyType() == ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) continue;
            return false;
        }
        return !cldLocals.isEmpty();
    }

    private void printOp(AbstractLogicalOperator op) throws AlgebricksException {
        StringBuilder sb = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor pvisitor = new LogicalOperatorPrettyPrintVisitor();
        PlanPrettyPrinter.printOperator((AbstractLogicalOperator)op, (StringBuilder)sb, (LogicalOperatorPrettyPrintVisitor)pvisitor, (int)0);
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine(sb.toString());
    }

    private List<OrderColumn> computeOrderColumns(IPhysicalPropertiesVector pv) {
        ArrayList<OrderColumn> ordCols = new ArrayList<OrderColumn>();
        List localProps = pv.getLocalProperties();
        if (localProps == null || localProps.size() == 0) {
            return null;
        }
        for (ILocalStructuralProperty p : localProps) {
            if (p.getPropertyType() == ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) {
                LocalOrderProperty lop = (LocalOrderProperty)p;
                ordCols.add(lop.getOrderColumn());
                continue;
            }
            return null;
        }
        return ordCols;
    }

    private void setNewOp(Mutable<ILogicalOperator> opRef, AbstractLogicalOperator newOp, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator oldOp = (ILogicalOperator)opRef.getValue();
        opRef.setValue((Object)newOp);
        newOp.getInputs().add(new MutableObject((Object)oldOp));
        newOp.recomputeSchema();
        newOp.computeDeliveredPhysicalProperties(context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newOp);
        AlgebricksConfig.ALGEBRICKS_LOGGER.finest(">>>> Structural properties for " + newOp.getPhysicalOperator() + ": " + newOp.getDeliveredPhysicalProperties() + "\n");
        PhysicalOptimizationsUtil.computeFDsAndEquivalenceClasses(newOp, context);
    }
}

