/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class EliminateGroupByEmptyKeyRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        GroupByOperator groupOp = (GroupByOperator)op;
        List groupVars = groupOp.getGbyVarList();
        if (groupVars.size() > 0) {
            return false;
        }
        List nestedPlans = groupOp.getNestedPlans();
        if (nestedPlans.size() > 1) {
            return false;
        }
        ILogicalPlan nestedPlan = (ILogicalPlan)nestedPlans.get(0);
        if (nestedPlan.getRoots().size() > 1) {
            return false;
        }
        Mutable topOpRef = (Mutable)nestedPlan.getRoots().get(0);
        ILogicalOperator topOp = (ILogicalOperator)((Mutable)nestedPlan.getRoots().get(0)).getValue();
        Mutable<ILogicalOperator> nestedTupleSourceRef = this.getNestedTupleSourceReference((Mutable<ILogicalOperator>)topOpRef);
        opRef.setValue((Object)topOp);
        nestedTupleSourceRef.setValue(((Mutable)groupOp.getInputs().get(0)).getValue());
        return true;
    }

    private Mutable<ILogicalOperator> getNestedTupleSourceReference(Mutable<ILogicalOperator> nestedTopOperatorRef) {
        Mutable currentOpRef = nestedTopOperatorRef;
        while (((ILogicalOperator)currentOpRef.getValue()).getInputs() != null && ((ILogicalOperator)currentOpRef.getValue()).getInputs().size() > 0) {
            currentOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
        }
        return currentOpRef;
    }
}

