/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.StreamLimitPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class CopyLimitDownRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.LIMIT) {
            return false;
        }
        LimitOperator limitOp = (LimitOperator)op;
        if (!limitOp.isTopmostLimitOp()) {
            return false;
        }
        ArrayList limitUsedVars = new ArrayList();
        VariableUtilities.getUsedVariables((ILogicalOperator)limitOp, limitUsedVars);
        Mutable safeOpRef = null;
        Mutable candidateOpRef = (Mutable)limitOp.getInputs().get(0);
        ArrayList candidateProducedVars = new ArrayList();
        while (true) {
            candidateProducedVars.clear();
            ILogicalOperator candidateOp = (ILogicalOperator)candidateOpRef.getValue();
            LogicalOperatorTag candidateOpTag = candidateOp.getOperatorTag();
            if (candidateOp.getInputs().size() > 1 || !candidateOp.isMap() || candidateOpTag == LogicalOperatorTag.SELECT || candidateOpTag == LogicalOperatorTag.LIMIT || !OperatorPropertiesUtil.disjoint(limitUsedVars, candidateProducedVars)) break;
            safeOpRef = candidateOpRef;
            candidateOpRef = (Mutable)((ILogicalOperator)safeOpRef.getValue()).getInputs().get(0);
        }
        if (safeOpRef != null) {
            ILogicalOperator safeOp = (ILogicalOperator)safeOpRef.getValue();
            Mutable unsafeOpRef = (Mutable)safeOp.getInputs().get(0);
            ILogicalOperator unsafeOp = (ILogicalOperator)unsafeOpRef.getValue();
            LimitOperator limitCloneOp = null;
            if (limitOp.getOffset().getValue() == null) {
                limitCloneOp = new LimitOperator((ILogicalExpression)limitOp.getMaxObjects().getValue(), false);
            } else {
                IFunctionInfo finfoAdd = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.NUMERIC_ADD);
                ArrayList<MutableObject> addArgs = new ArrayList<MutableObject>();
                addArgs.add(new MutableObject((Object)((ILogicalExpression)limitOp.getMaxObjects().getValue()).cloneExpression()));
                addArgs.add(new MutableObject((Object)((ILogicalExpression)limitOp.getOffset().getValue()).cloneExpression()));
                ScalarFunctionCallExpression maxPlusOffset = new ScalarFunctionCallExpression(finfoAdd, addArgs);
                limitCloneOp = new LimitOperator((ILogicalExpression)maxPlusOffset, false);
            }
            limitCloneOp.setPhysicalOperator((IPhysicalOperator)new StreamLimitPOperator());
            limitCloneOp.getInputs().add(new MutableObject((Object)unsafeOp));
            limitCloneOp.setExecutionMode(unsafeOp.getExecutionMode());
            limitCloneOp.recomputeSchema();
            unsafeOpRef.setValue((Object)limitCloneOp);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)limitCloneOp);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)limitOp);
        }
        return safeOpRef != null;
    }
}

