/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class ConsolidateSelectsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        SelectOperator firstSelect = (SelectOperator)op;
        IFunctionInfo andFn = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.AND);
        ScalarFunctionCallExpression conj = null;
        SelectOperator topMostOp = null;
        SelectOperator selectParent = null;
        SelectOperator nextSelect = firstSelect;
        while (true) {
            if ((nextSelect = (AbstractLogicalOperator)((Mutable)(selectParent = nextSelect).getInputs().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                continue;
            }
            if (nextSelect.getOperatorTag() != LogicalOperatorTag.SELECT) break;
            topMostOp = selectParent;
            if (conj == null) {
                conj = new ScalarFunctionCallExpression(andFn);
                conj.getArguments().add(new MutableObject(firstSelect.getCondition().getValue()));
            }
            do {
                conj.getArguments().add(nextSelect.getCondition());
                selectParent = nextSelect;
            } while ((nextSelect = (AbstractLogicalOperator)((Mutable)nextSelect.getInputs().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.SELECT);
            if (topMostOp.getOperatorTag() == LogicalOperatorTag.ASSIGN || topMostOp == firstSelect) {
                topMostOp.getInputs().set(0, selectParent.getInputs().get(0));
            }
            nextSelect = selectParent;
        }
        if (conj == null) {
            return false;
        }
        firstSelect.getCondition().setValue(conj);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)firstSelect);
        return true;
    }
}

