/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class ComplexUnnestToProductRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN && op.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        if (this.insideSubplan(opRef)) {
            return false;
        }
        ArrayList<ILogicalOperator> topSelects = new ArrayList<ILogicalOperator>();
        HashSet<LogicalVariable> innerUsedVars = new HashSet<LogicalVariable>();
        ArrayList<ILogicalOperator> innerOps = new ArrayList<ILogicalOperator>();
        HashSet<LogicalVariable> outerUsedVars = new HashSet<LogicalVariable>();
        ArrayList<ILogicalOperator> outerOps = new ArrayList<ILogicalOperator>();
        innerOps.add((ILogicalOperator)op);
        VariableUtilities.getUsedVariables((ILogicalOperator)op, innerUsedVars);
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (!this.findPlanPartition(op2, innerUsedVars, outerUsedVars, innerOps, outerOps, topSelects, false)) {
            return false;
        }
        AbstractLogicalOperator unnestOrJoin = (AbstractLogicalOperator)outerOps.get(outerOps.size() - 1);
        ILogicalOperator outerRoot = null;
        ILogicalOperator innerRoot = null;
        EmptyTupleSourceOperator ets = new EmptyTupleSourceOperator();
        if (unnestOrJoin.getOperatorTag() != LogicalOperatorTag.INNERJOIN && unnestOrJoin.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            ArrayList producedVars = new ArrayList();
            VariableUtilities.getProducedVariables((ILogicalOperator)unnestOrJoin, producedVars);
            for (LogicalVariable producedVar : producedVars) {
                if (!innerUsedVars.contains(producedVar)) continue;
                return false;
            }
            VariableUtilities.getUsedVariables((ILogicalOperator)unnestOrJoin, outerUsedVars);
            AbstractLogicalOperator unnestChild = (AbstractLogicalOperator)((Mutable)unnestOrJoin.getInputs().get(0)).getValue();
            if (!this.findPlanPartition(unnestChild, innerUsedVars, outerUsedVars, innerOps, outerOps, topSelects, true)) {
                return false;
            }
        }
        innerRoot = this.buildOperatorChain(innerOps, (ILogicalOperator)ets, context);
        context.computeAndSetTypeEnvironmentForOperator(innerRoot);
        outerRoot = this.buildOperatorChain(outerOps, null, context);
        context.computeAndSetTypeEnvironmentForOperator(outerRoot);
        InnerJoinOperator product = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE));
        product.getInputs().add(new MutableObject((Object)outerRoot));
        product.getInputs().add(new MutableObject((Object)innerRoot));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)product);
        InnerJoinOperator topOp = product;
        if (!topSelects.isEmpty()) {
            topOp = this.buildOperatorChain(topSelects, (ILogicalOperator)product, context);
        }
        opRef.setValue((Object)topOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)topOp);
        return true;
    }

    private ILogicalOperator buildOperatorChain(List<ILogicalOperator> ops, ILogicalOperator bottomOp, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator root;
        ILogicalOperator prevOp = root = ops.get(0);
        for (int i = 1; i < ops.size(); ++i) {
            ILogicalOperator inputOp = ops.get(i);
            prevOp.getInputs().clear();
            prevOp.getInputs().add(new MutableObject((Object)inputOp));
            prevOp = inputOp;
        }
        if (bottomOp != null) {
            context.computeAndSetTypeEnvironmentForOperator(bottomOp);
            prevOp.getInputs().clear();
            prevOp.getInputs().add(new MutableObject((Object)bottomOp));
        }
        return root;
    }

    private boolean findPlanPartition(AbstractLogicalOperator op, HashSet<LogicalVariable> innerUsedVars, HashSet<LogicalVariable> outerUsedVars, List<ILogicalOperator> innerOps, List<ILogicalOperator> outerOps, List<ILogicalOperator> topSelects, boolean belowSecondUnnest) throws AlgebricksException {
        if (belowSecondUnnest && innerUsedVars.isEmpty()) {
            return true;
        }
        if (!belowSecondUnnest) {
            switch (op.getOperatorTag()) {
                case AGGREGATE: 
                case SUBPLAN: 
                case GROUP: 
                case UNNEST_MAP: {
                    return false;
                }
            }
        }
        switch (op.getOperatorTag()) {
            case UNNEST: 
            case DATASOURCESCAN: {
                outerOps.add((ILogicalOperator)op);
                return true;
            }
            case INNERJOIN: 
            case LEFTOUTERJOIN: {
                ArrayList liveVars = new ArrayList();
                VariableUtilities.getLiveVariables((ILogicalOperator)op, liveVars);
                for (LogicalVariable liveVar : liveVars) {
                    if (!innerUsedVars.contains(liveVar)) continue;
                    return false;
                }
                outerOps.add((ILogicalOperator)op);
                return true;
            }
            case SELECT: {
                if (innerUsedVars.isEmpty()) {
                    outerOps.add((ILogicalOperator)op);
                    break;
                }
                topSelects.add((ILogicalOperator)op);
                break;
            }
            case PROJECT: {
                break;
            }
            case EMPTYTUPLESOURCE: 
            case NESTEDTUPLESOURCE: {
                return belowSecondUnnest;
            }
            default: {
                if (!belowSecondUnnest && innerUsedVars.isEmpty()) {
                    outerOps.add((ILogicalOperator)op);
                    break;
                }
                ArrayList producedVars = new ArrayList();
                VariableUtilities.getProducedVariables((ILogicalOperator)op, producedVars);
                int outerMatches = 0;
                int innerMatches = 0;
                for (LogicalVariable producedVar : producedVars) {
                    if (outerUsedVars.contains(producedVar)) {
                        ++outerMatches;
                    }
                    if (!innerUsedVars.contains(producedVar)) continue;
                    ++innerMatches;
                }
                HashSet<LogicalVariable> targetUsedVars = null;
                if (outerMatches == producedVars.size() && !producedVars.isEmpty()) {
                    outerOps.add((ILogicalOperator)op);
                    targetUsedVars = outerUsedVars;
                }
                if (innerMatches == producedVars.size() && !producedVars.isEmpty()) {
                    innerOps.add((ILogicalOperator)op);
                    targetUsedVars = innerUsedVars;
                }
                if (innerMatches == 0 && outerMatches == 0) {
                    ArrayList usedVars = new ArrayList();
                    VariableUtilities.getUsedVariables((ILogicalOperator)op, usedVars);
                    for (LogicalVariable usedVar : usedVars) {
                        boolean canBreak = false;
                        if (outerUsedVars.contains(usedVar)) {
                            outerOps.add((ILogicalOperator)op);
                            targetUsedVars = outerUsedVars;
                            canBreak = true;
                        }
                        if (innerUsedVars.contains(usedVar)) {
                            innerOps.add((ILogicalOperator)op);
                            targetUsedVars = innerUsedVars;
                            canBreak = true;
                        }
                        if (!canBreak) continue;
                        break;
                    }
                    if (targetUsedVars == null) {
                        return false;
                    }
                } else {
                    return false;
                }
                if (op.hasNestedPlans() && op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
                    AbstractOperatorWithNestedPlans opWithNestedPlans = (AbstractOperatorWithNestedPlans)op;
                    opWithNestedPlans.getUsedVariablesExceptNestedPlans(targetUsedVars);
                    break;
                }
                VariableUtilities.getUsedVariables((ILogicalOperator)op, targetUsedVars);
                break;
            }
        }
        if (!op.hasInputs()) {
            return belowSecondUnnest;
        }
        return this.findPlanPartition((AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue(), innerUsedVars, outerUsedVars, innerOps, outerOps, topSelects, belowSecondUnnest);
    }

    private boolean insideSubplan(Mutable<ILogicalOperator> nestedRootRef) {
        AbstractLogicalOperator nestedRoot = (AbstractLogicalOperator)nestedRootRef.getValue();
        if (nestedRoot.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return true;
        }
        List inputs = nestedRoot.getInputs();
        for (Mutable input : inputs) {
            if (!this.insideSubplan((Mutable<ILogicalOperator>)input)) continue;
            return true;
        }
        return false;
    }
}

