/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import edu.uci.ics.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.HashSet;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class ComplexJoinInferenceRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (!(op instanceof AbstractScanOperator)) {
            return false;
        }
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan = (SubplanOperator)op2;
        Mutable opRef3 = (Mutable)subplan.getInputs().get(0);
        AbstractLogicalOperator op3 = (AbstractLogicalOperator)opRef3.getValue();
        if (op3.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE || op3.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return false;
        }
        if (ComplexJoinInferenceRule.subplanHasFreeVariables(subplan)) {
            return false;
        }
        HashSet varsUsedInUnnest = new HashSet();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, varsUsedInUnnest);
        HashSet producedInSubplan = new HashSet();
        VariableUtilities.getProducedVariables((ILogicalOperator)subplan, producedInSubplan);
        if (!producedInSubplan.containsAll(varsUsedInUnnest)) {
            return false;
        }
        ComplexJoinInferenceRule.ntsToEtsInSubplan(subplan, context);
        InnerJoinOperator join = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE));
        join.getInputs().add(opRef3);
        opRef2.setValue((Object)OperatorManipulationUtil.eliminateSingleSubplanOverEts((SubplanOperator)subplan));
        join.getInputs().add(new MutableObject((Object)op));
        opRef.setValue((Object)join);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)join);
        return true;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    private static void ntsToEtsInSubplan(SubplanOperator s, IOptimizationContext context) throws AlgebricksException {
        for (ILogicalPlan p : s.getNestedPlans()) {
            for (Mutable r : p.getRoots()) {
                OperatorManipulationUtil.ntsToEts((Mutable)r, (IOptimizationContext)context);
            }
        }
    }

    private static boolean subplanHasFreeVariables(SubplanOperator s) throws AlgebricksException {
        for (ILogicalPlan p : s.getNestedPlans()) {
            for (Mutable r : p.getRoots()) {
                if (!OperatorPropertiesUtil.hasFreeVariablesInSelfOrDesc((AbstractLogicalOperator)((AbstractLogicalOperator)r.getValue()))) continue;
                return true;
            }
        }
        return false;
    }
}

