/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class BreakSelectIntoConjunctsRule
implements IAlgebraicRewriteRule {
    private List<Mutable<ILogicalExpression>> conjs = new ArrayList<Mutable<ILogicalExpression>>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        SelectOperator select = (SelectOperator)op;
        ILogicalExpression cond = (ILogicalExpression)select.getCondition().getValue();
        this.conjs.clear();
        if (!cond.splitIntoConjuncts(this.conjs)) {
            return false;
        }
        Mutable childOfSelect = (Mutable)select.getInputs().get(0);
        boolean fst = true;
        SelectOperator botOp = select;
        ILogicalExpression firstExpr = null;
        for (Mutable<ILogicalExpression> eRef : this.conjs) {
            ILogicalExpression e = (ILogicalExpression)eRef.getValue();
            if (fst) {
                fst = false;
                firstExpr = e;
                continue;
            }
            SelectOperator newSelect = new SelectOperator((Mutable)new MutableObject((Object)e));
            List botInpList = botOp.getInputs();
            botInpList.clear();
            botInpList.add(new MutableObject((Object)newSelect));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)botOp);
            botOp = newSelect;
        }
        botOp.getInputs().add(childOfSelect);
        select.getCondition().setValue(firstExpr);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)botOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)select);
        return true;
    }
}

