/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class AbstractIntroduceCombinerRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public void replaceOriginalAggFuncs(Map<AggregateFunctionCallExpression, SimilarAggregatesInfo> toReplaceMap) {
        for (Map.Entry<AggregateFunctionCallExpression, SimilarAggregatesInfo> entry : toReplaceMap.entrySet()) {
            SimilarAggregatesInfo sai = entry.getValue();
            for (AggregateExprInfo aei : sai.simAggs) {
                AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)aei.aggExprRef.getValue();
                afce.setFunctionInfo(aei.newFunInfo);
                afce.getArguments().clear();
                afce.getArguments().add(new MutableObject((Object)sai.stepOneResult));
            }
        }
    }

    protected Pair<Boolean, Mutable<ILogicalOperator>> tryToPushAgg(AggregateOperator initAgg, GroupByOperator newGbyOp, Map<AggregateFunctionCallExpression, SimilarAggregatesInfo> toReplaceMap, IOptimizationContext context) throws AlgebricksException {
        ArrayList<LogicalVariable> pushedVars = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> pushedExprs = new ArrayList<MutableObject>();
        List initVars = initAgg.getVariables();
        List initExprs = initAgg.getExpressions();
        int numExprs = initVars.size();
        for (int i = 0; i < numExprs; ++i) {
            AggregateFunctionCallExpression aggFun = (AggregateFunctionCallExpression)((Mutable)initExprs.get(i)).getValue();
            if (aggFun.isTwoStep()) continue;
            return new Pair((Object)false, null);
        }
        boolean haveAggToReplace = false;
        for (int i = 0; i < numExprs; ++i) {
            Mutable expRef = (Mutable)initExprs.get(i);
            AggregateFunctionCallExpression aggFun = (AggregateFunctionCallExpression)expRef.getValue();
            IFunctionInfo fi1 = aggFun.getStepOneAggregate();
            ArrayList<MutableObject> newArgs = new ArrayList<MutableObject>(aggFun.getArguments().size());
            for (Mutable er : aggFun.getArguments()) {
                newArgs.add(new MutableObject((Object)((ILogicalExpression)er.getValue()).cloneExpression()));
            }
            IFunctionInfo fi2 = aggFun.getStepTwoAggregate();
            SimilarAggregatesInfo inf = toReplaceMap.get(aggFun);
            if (inf == null) {
                inf = new SimilarAggregatesInfo();
                LogicalVariable newAggVar = context.newVar();
                pushedVars.add(newAggVar);
                inf.stepOneResult = new VariableReferenceExpression(newAggVar);
                inf.simAggs = new ArrayList<AggregateExprInfo>();
                toReplaceMap.put(aggFun, inf);
                AggregateFunctionCallExpression aggLocal = new AggregateFunctionCallExpression(fi1, false, newArgs);
                pushedExprs.add(new MutableObject((Object)aggLocal));
            }
            AggregateExprInfo aei = new AggregateExprInfo();
            aei.aggExprRef = expRef;
            aei.newFunInfo = fi2;
            inf.simAggs.add(aei);
            haveAggToReplace = true;
        }
        if (!pushedVars.isEmpty()) {
            AggregateOperator pushedAgg = new AggregateOperator(pushedVars, pushedExprs);
            pushedAgg.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
            if (newGbyOp != null) {
                NestedTupleSourceOperator nts = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)newGbyOp));
                nts.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
                pushedAgg.getInputs().add(new MutableObject((Object)nts));
            } else {
                pushedAgg.getInputs().add(new MutableObject(((Mutable)initAgg.getInputs().get(0)).getValue()));
                ((Mutable)initAgg.getInputs().get(0)).setValue((Object)pushedAgg);
                pushedAgg.setGlobal(false);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)pushedAgg);
            }
            return new Pair((Object)true, (Object)new MutableObject((Object)pushedAgg));
        }
        return new Pair((Object)haveAggToReplace, null);
    }

    protected class BookkeepingInfo {
        Map<AggregateFunctionCallExpression, SimilarAggregatesInfo> toReplaceMap = new HashMap<AggregateFunctionCallExpression, SimilarAggregatesInfo>();
        Map<GroupByOperator, List<LogicalVariable>> modifyGbyMap = new HashMap<GroupByOperator, List<LogicalVariable>>();

        protected BookkeepingInfo() {
        }
    }

    protected class AggregateExprInfo {
        Mutable<ILogicalExpression> aggExprRef;
        IFunctionInfo newFunInfo;

        protected AggregateExprInfo() {
        }
    }

    protected class SimilarAggregatesInfo {
        ILogicalExpression stepOneResult;
        List<AggregateExprInfo> simAggs;

        protected SimilarAggregatesInfo() {
        }
    }
}

