/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.wicket.Application;
import org.apache.wicket.util.io.Connections;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlResourceStream
extends AbstractResourceStream
implements IFixedLocationResourceStream {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(UrlResourceStream.class);
    private transient StreamData streamData;
    private final URL url;
    private Time lastModified;

    public UrlResourceStream(URL url) {
        this.url = (URL)Args.notNull((Object)url, (String)"url");
    }

    private StreamData getData(boolean initialize) {
        if (this.streamData == null && initialize) {
            this.streamData = new StreamData();
            try {
                this.streamData.connection = this.url.openConnection();
                this.streamData.contentLength = this.streamData.connection.getContentLength();
                this.streamData.contentType = this.streamData.connection.getContentType();
                if (this.streamData.contentType == null || this.streamData.contentType.contains("unknown")) {
                    if (Application.exists()) {
                        this.streamData.contentType = Application.get().getMimeType(this.url.getFile());
                    } else {
                        this.streamData.contentType = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Invalid URL parameter " + this.url, ex);
            }
        }
        return this.streamData;
    }

    public void close() throws IOException {
        StreamData data = this.getData(false);
        if (data != null) {
            Connections.closeQuietly((URLConnection)data.connection);
            this.streamData = null;
        }
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        try {
            return this.getData(true).connection.getInputStream();
        }
        catch (IOException e) {
            throw new ResourceStreamNotFoundException("Resource " + this.url + " could not be opened", (Throwable)e);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public Time lastModifiedTime() {
        try {
            Time time = Connections.getLastModified((URL)this.url);
            if (!Objects.equal((Object)time, (Object)this.lastModified)) {
                this.lastModified = time;
                this.updateContentLength();
            }
            return this.lastModified;
        }
        catch (IOException e) {
            log.warn("getLastModified for " + this.url + " failed: " + e.getMessage());
            return null;
        }
    }

    private void updateContentLength() throws IOException {
        StreamData data = this.getData(false);
        if (data != null) {
            URLConnection connection = this.url.openConnection();
            data.contentLength = connection.getContentLength();
            Connections.close((URLConnection)connection);
        }
    }

    public String toString() {
        return this.url.toString();
    }

    public String getContentType() {
        return this.getData(true).contentType;
    }

    public Bytes length() {
        long length = this.getData(true).contentLength;
        if (length == -1L) {
            return null;
        }
        return Bytes.bytes((long)length);
    }

    public String locationAsString() {
        return this.url.toExternalForm();
    }

    private static class StreamData {
        private URLConnection connection;
        private long contentLength;
        private String contentType;

        private StreamData() {
        }
    }
}

