/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings.def;

import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.IResourceFactory;
import org.apache.wicket.Localizer;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.markup.html.PackageResourceGuard;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.caching.FilenameWithVersionResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.NoOpResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.version.CachingResourceVersion;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.request.resource.caching.version.LastModifiedResourceVersion;
import org.apache.wicket.request.resource.caching.version.MessageDigestResourceVersion;
import org.apache.wicket.request.resource.caching.version.RequestCycleCachedResourceVersion;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.PropertiesFactory;
import org.apache.wicket.resource.loader.ClassStringResourceLoader;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.resource.loader.PackageStringResourceLoader;
import org.apache.wicket.resource.loader.ValidatorStringResourceLoader;
import org.apache.wicket.settings.IResourceSettings;
import org.apache.wicket.util.file.IFileCleaner;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.file.IResourcePath;
import org.apache.wicket.util.file.Path;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.resource.locator.caching.CachingResourceStreamLocator;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.apache.wicket.util.watch.ModificationWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSettings
implements IResourceSettings {
    private Localizer localizer;
    private final Map<String, IResourceFactory> nameToResourceFactory = Generics.newHashMap();
    private IPackageResourceGuard packageResourceGuard = new PackageResourceGuard();
    private IPropertiesFactory propertiesFactory;
    private IResourceFinder resourceFinder = new Path();
    private Duration resourcePollFrequency = null;
    private IResourceStreamLocator resourceStreamLocator;
    private IModificationWatcher resourceWatcher;
    private IFileCleaner fileCleaner;
    private final List<IStringResourceLoader> stringResourceLoaders = Generics.newArrayList((int)4);
    private boolean throwExceptionOnMissingResource = true;
    private boolean useDefaultOnMissingResource = true;
    private Duration defaultCacheDuration = WebResponse.MAX_CACHE_DURATION;
    private IJavaScriptCompressor javascriptCompressor;
    private ICssCompressor cssCompressor;
    private String parentFolderPlaceholder = "::";
    private IResourceCachingStrategy resourceCachingStrategy;
    private final Application application;

    public ResourceSettings(Application application) {
        this.application = application;
        this.stringResourceLoaders.add(new ComponentStringResourceLoader());
        this.stringResourceLoaders.add(new PackageStringResourceLoader());
        this.stringResourceLoaders.add(new ClassStringResourceLoader(application.getClass()));
        this.stringResourceLoaders.add(new ValidatorStringResourceLoader());
    }

    @Override
    public void addResourceFactory(String name, IResourceFactory resourceFactory) {
        this.nameToResourceFactory.put(name, resourceFactory);
    }

    @Override
    public void addResourceFolder(String resourceFolder) {
        IResourceFinder finder = this.getResourceFinder();
        if (!(finder instanceof IResourcePath)) {
            throw new IllegalArgumentException("To add a resource folder, the application's resource finder must be an instance of IResourcePath");
        }
        IResourcePath path = (IResourcePath)finder;
        path.add(resourceFolder);
    }

    @Override
    public Localizer getLocalizer() {
        if (this.localizer == null) {
            this.localizer = new Localizer();
        }
        return this.localizer;
    }

    @Override
    public IPackageResourceGuard getPackageResourceGuard() {
        return this.packageResourceGuard;
    }

    @Override
    public IPropertiesFactory getPropertiesFactory() {
        if (this.propertiesFactory == null) {
            this.propertiesFactory = new PropertiesFactory(this);
        }
        return this.propertiesFactory;
    }

    @Override
    public IResourceFactory getResourceFactory(String name) {
        return this.nameToResourceFactory.get(name);
    }

    @Override
    public IResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }

    @Override
    public Duration getResourcePollFrequency() {
        return this.resourcePollFrequency;
    }

    @Override
    public IResourceStreamLocator getResourceStreamLocator() {
        if (this.resourceStreamLocator == null) {
            this.resourceStreamLocator = new ResourceStreamLocator(this.getResourceFinder());
            this.resourceStreamLocator = new CachingResourceStreamLocator(this.resourceStreamLocator);
        }
        return this.resourceStreamLocator;
    }

    @Override
    public IModificationWatcher getResourceWatcher(boolean start) {
        Duration pollFrequency;
        if (this.resourceWatcher == null && start && (pollFrequency = this.getResourcePollFrequency()) != null) {
            this.resourceWatcher = new ModificationWatcher(pollFrequency);
        }
        return this.resourceWatcher;
    }

    @Override
    public void setResourceWatcher(IModificationWatcher watcher) {
        this.resourceWatcher = watcher;
    }

    @Override
    public IFileCleaner getFileCleaner() {
        return this.fileCleaner;
    }

    @Override
    public void setFileCleaner(IFileCleaner fileUploadCleaner) {
        this.fileCleaner = fileUploadCleaner;
    }

    @Override
    public List<IStringResourceLoader> getStringResourceLoaders() {
        return this.stringResourceLoaders;
    }

    @Override
    public boolean getThrowExceptionOnMissingResource() {
        return this.throwExceptionOnMissingResource;
    }

    @Override
    public boolean getUseDefaultOnMissingResource() {
        return this.useDefaultOnMissingResource;
    }

    @Override
    public void setLocalizer(Localizer localizer) {
        this.localizer = localizer;
    }

    @Override
    public void setPackageResourceGuard(IPackageResourceGuard packageResourceGuard) {
        if (packageResourceGuard == null) {
            throw new IllegalArgumentException("Argument packageResourceGuard may not be null");
        }
        this.packageResourceGuard = packageResourceGuard;
    }

    @Override
    public void setPropertiesFactory(IPropertiesFactory factory) {
        this.propertiesFactory = factory;
    }

    @Override
    public void setResourceFinder(IResourceFinder resourceFinder) {
        this.resourceFinder = resourceFinder;
        this.resourceStreamLocator = null;
    }

    @Override
    public void setResourcePollFrequency(Duration resourcePollFrequency) {
        this.resourcePollFrequency = resourcePollFrequency;
    }

    @Override
    public void setResourceStreamLocator(IResourceStreamLocator resourceStreamLocator) {
        this.resourceStreamLocator = resourceStreamLocator;
    }

    @Override
    public void setThrowExceptionOnMissingResource(boolean throwExceptionOnMissingResource) {
        this.throwExceptionOnMissingResource = throwExceptionOnMissingResource;
    }

    @Override
    public void setUseDefaultOnMissingResource(boolean useDefaultOnMissingResource) {
        this.useDefaultOnMissingResource = useDefaultOnMissingResource;
    }

    @Override
    public final Duration getDefaultCacheDuration() {
        return this.defaultCacheDuration;
    }

    @Override
    public final void setDefaultCacheDuration(Duration duration) {
        Args.notNull((Object)duration, (String)"duration");
        this.defaultCacheDuration = duration;
    }

    @Override
    public IJavaScriptCompressor getJavaScriptCompressor() {
        return this.javascriptCompressor;
    }

    @Override
    public IJavaScriptCompressor setJavaScriptCompressor(IJavaScriptCompressor compressor) {
        IJavaScriptCompressor old = this.javascriptCompressor;
        this.javascriptCompressor = compressor;
        return old;
    }

    @Override
    public ICssCompressor getCssCompressor() {
        return this.cssCompressor;
    }

    @Override
    public ICssCompressor setCssCompressor(ICssCompressor compressor) {
        ICssCompressor old = this.cssCompressor;
        this.cssCompressor = compressor;
        return old;
    }

    @Override
    public String getParentFolderPlaceholder() {
        return this.parentFolderPlaceholder;
    }

    @Override
    public void setParentFolderPlaceholder(String sequence) {
        this.parentFolderPlaceholder = sequence;
    }

    @Override
    public IResourceCachingStrategy getCachingStrategy() {
        if (this.resourceCachingStrategy == null) {
            IResourceVersion resourceVersion = this.application.usesDevelopmentConfig() ? new RequestCycleCachedResourceVersion(new LastModifiedResourceVersion()) : new CachingResourceVersion(new MessageDigestResourceVersion());
            this.resourceCachingStrategy = new FilenameWithVersionResourceCachingStrategy(resourceVersion);
        }
        return this.resourceCachingStrategy;
    }

    @Override
    public void setCachingStrategy(IResourceCachingStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("It is not allowed to set the resource caching strategy to value NULL. Please use " + NoOpResourceCachingStrategy.class.getName() + " instead.");
        }
        this.resourceCachingStrategy = strategy;
    }
}

