/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.IOException;
import java.io.InputStream;
import org.apache.wicket.Application;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.IResourceStreamWriter;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStreamResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceStreamResource.class);
    private final IResourceStream stream;
    private String fileName;
    private ContentDisposition contentDisposition = ContentDisposition.INLINE;
    private String textEncoding;
    private String mimeType;

    public ResourceStreamResource(IResourceStream stream) {
        Args.notNull((Object)stream, (String)"stream");
        this.stream = stream;
    }

    public ResourceStreamResource setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ResourceStreamResource setContentDisposition(ContentDisposition contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public ResourceStreamResource setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
        return this;
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse data = new AbstractResource.ResourceResponse();
        Time lastModifiedTime = this.stream.lastModifiedTime();
        if (lastModifiedTime != null) {
            data.setLastModified(lastModifiedTime);
        }
        if (data.dataNeedsToBeWritten(attributes)) {
            InputStream inputStream = null;
            if (!(this.stream instanceof IResourceStreamWriter)) {
                try {
                    inputStream = this.stream.getInputStream();
                }
                catch (ResourceStreamNotFoundException e) {
                    data.setError(404);
                    this.close();
                }
            }
            data.setContentDisposition(this.contentDisposition);
            Bytes length = this.stream.length();
            if (length != null) {
                data.setContentLength(length.bytes());
            }
            data.setFileName(this.fileName);
            String contentType = this.fileName != null && Application.exists() ? Application.get().getMimeType(this.fileName) : this.stream.getContentType();
            data.setContentType(contentType);
            data.setTextEncoding(this.textEncoding);
            if (this.stream instanceof IResourceStreamWriter) {
                data.setWriteCallback(new AbstractResource.WriteCallback(){

                    public void writeData(IResource.Attributes attributes) {
                        ((IResourceStreamWriter)ResourceStreamResource.this.stream).write(attributes.getResponse());
                        ResourceStreamResource.this.close();
                    }
                });
            } else {
                final InputStream s = inputStream;
                data.setWriteCallback(new AbstractResource.WriteCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void writeData(IResource.Attributes attributes) {
                        try {
                            this.writeStream(attributes, s);
                        }
                        finally {
                            ResourceStreamResource.this.close();
                        }
                    }
                });
            }
        }
        return data;
    }

    private void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            logger.error("Couldn't close ResourceStream", (Throwable)e);
        }
    }
}

