/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.net.URLConnection;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.time.Time;

public class ByteArrayResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private final String contentType;
    private byte[] array;
    private final Time lastModified = Time.now();
    private final String filename;

    public ByteArrayResource(String contentType) {
        this(contentType, null, null);
    }

    public ByteArrayResource(String contentType, byte[] array) {
        this(contentType, array, null);
    }

    public ByteArrayResource(String contentType, byte[] array, String filename) {
        this.contentType = contentType;
        this.array = array;
        this.filename = filename;
    }

    protected void configureResponse(AbstractResource.ResourceResponse response, IResource.Attributes attributes) {
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        String contentType = this.contentType;
        if (contentType == null) {
            if (this.filename != null) {
                contentType = URLConnection.getFileNameMap().getContentTypeFor(this.filename);
            }
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
        }
        response.setContentType(contentType);
        response.setLastModified(this.lastModified);
        final byte[] data = this.getData(attributes);
        if (data == null) {
            throw new WicketRuntimeException("ByteArrayResource's data cannot be 'null'.");
        }
        response.setContentLength(data.length);
        if (response.dataNeedsToBeWritten(attributes)) {
            if (this.filename != null) {
                response.setFileName(this.filename);
                response.setContentDisposition(ContentDisposition.ATTACHMENT);
            } else {
                response.setContentDisposition(ContentDisposition.INLINE);
            }
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) {
                    attributes.getResponse().write(data);
                }
            });
            this.configureResponse(response, attributes);
        }
        return response;
    }

    protected byte[] getData(IResource.Attributes attributes) {
        return this.array;
    }
}

