/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.BufferedResponseRequestHandler;

public class BufferedResponseMapper
implements IRequestMapper {
    protected String getSessionId() {
        return Session.exists() ? Session.get().getId() : null;
    }

    protected boolean hasBufferedResponse(Url url) {
        return WebApplication.get().hasBufferedResponse(this.getSessionId(), url);
    }

    protected BufferedWebResponse getAndRemoveBufferedResponse(Url url) {
        return WebApplication.get().getAndRemoveBufferedResponse(this.getSessionId(), url);
    }

    private Request getRequest(Request original) {
        if (RequestCycle.get() != null) {
            return RequestCycle.get().getRequest();
        }
        return original;
    }

    public IRequestHandler mapRequest(Request request) {
        BufferedWebResponse response = this.getAndRemoveBufferedResponse((request = this.getRequest(request)).getUrl());
        if (response != null) {
            return new BufferedResponseRequestHandler(response);
        }
        return null;
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        return null;
    }

    public int getCompatibilityScore(Request request) {
        if (this.hasBufferedResponse((request = this.getRequest(request)).getUrl())) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

