/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler.render;

import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.handler.render.PageRenderer;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPageRenderer
extends PageRenderer {
    private static final Logger logger = LoggerFactory.getLogger(WebPageRenderer.class);

    public WebPageRenderer(RenderPageRequestHandler renderPageRequestHandler) {
        super(renderPageRequestHandler);
    }

    private boolean isAjax(RequestCycle requestCycle) {
        boolean isAjax = false;
        Request request = requestCycle.getRequest();
        if (request instanceof WebRequest) {
            WebRequest webRequest = (WebRequest)request;
            isAjax = webRequest.isAjax();
        }
        return isAjax;
    }

    protected void storeBufferedResponse(Url url, BufferedWebResponse response) {
        WebApplication.get().storeBufferedResponse(this.getSessionId(), url, response);
    }

    protected BufferedWebResponse getAndRemoveBufferedResponse(Url url) {
        return WebApplication.get().getAndRemoveBufferedResponse(this.getSessionId(), url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedWebResponse renderPage(Url targetUrl, RequestCycle requestCycle) {
        IRequestHandler scheduled = requestCycle.getRequestHandlerScheduledAfterCurrent();
        Response originalResponse = requestCycle.getResponse();
        BufferedWebResponse response = new BufferedWebResponse((WebResponse)originalResponse);
        Url originalBaseUrl = requestCycle.getUrlRenderer().setBaseUrl(targetUrl);
        try {
            requestCycle.setResponse((Response)response);
            this.getPage().renderPage();
            if (scheduled == null && requestCycle.getRequestHandlerScheduledAfterCurrent() != null) {
                BufferedWebResponse bufferedWebResponse = null;
                return bufferedWebResponse;
            }
            BufferedWebResponse bufferedWebResponse = response;
            return bufferedWebResponse;
        }
        finally {
            requestCycle.setResponse(originalResponse);
            requestCycle.getUrlRenderer().setBaseUrl(originalBaseUrl);
        }
    }

    protected void redirectTo(Url url, RequestCycle requestCycle) {
        WebResponse response = (WebResponse)requestCycle.getResponse();
        String relativeUrl = requestCycle.getUrlRenderer().renderUrl(url);
        response.sendRedirect(relativeUrl);
    }

    public void respond(RequestCycle requestCycle) {
        Url currentUrl = requestCycle.getUrlRenderer().getBaseUrl();
        Url targetUrl = requestCycle.mapUrlFor(this.getRenderPageRequestHandler());
        BufferedWebResponse bufferedResponse = this.getAndRemoveBufferedResponse(currentUrl);
        boolean isAjax = this.isAjax(requestCycle);
        boolean shouldPreserveClientUrl = ((WebRequest)requestCycle.getRequest()).shouldPreserveClientUrl();
        if (bufferedResponse != null) {
            logger.warn("The Buffered response should be handled by BufferedResponseRequestHandler");
            bufferedResponse.writeTo((WebResponse)requestCycle.getResponse());
        } else if (this.getRedirectPolicy() == RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT || this.isOnePassRender() && !isAjax || !isAjax && targetUrl.equals((Object)currentUrl) && !this.getPageProvider().isNewPageInstance() && !this.getPage().isPageStateless() || targetUrl.equals((Object)currentUrl) && this.isRedirectToRender() || shouldPreserveClientUrl) {
            BufferedWebResponse response = this.renderPage(currentUrl, requestCycle);
            if (response != null) {
                response.writeTo((WebResponse)requestCycle.getResponse());
            }
        } else if (this.getRedirectPolicy() == RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT || this.isRedirectToRender() || isAjax && targetUrl.equals((Object)currentUrl)) {
            this.redirectTo(targetUrl, requestCycle);
        } else if (!targetUrl.equals((Object)currentUrl) && (this.getPageProvider().isNewPageInstance() || this.isSessionTemporary() && this.getPage().isPageStateless())) {
            this.redirectTo(targetUrl, requestCycle);
        } else {
            BufferedWebResponse response;
            if (!this.isRedirectToBuffer() && logger.isWarnEnabled()) {
                logger.warn("Falling back to Redirect_To_Buffer render strategy because none of the conditions matched.");
            }
            if ((response = this.renderPage(targetUrl, requestCycle)) == null) {
                return;
            }
            Url targetUrl2 = requestCycle.mapUrlFor(this.getRenderPageRequestHandler());
            if (!((Object)targetUrl.getSegments()).equals(targetUrl2.getSegments())) {
                response = this.renderPage(targetUrl2, requestCycle);
            }
            if (currentUrl.equals((Object)targetUrl2)) {
                response.writeTo((WebResponse)requestCycle.getResponse());
            } else if (this.getPage().isPageStateless() && !this.enableRedirectForStatelessPage()) {
                response.writeTo((WebResponse)requestCycle.getResponse());
            } else {
                this.storeBufferedResponse(targetUrl2, response);
                this.redirectTo(targetUrl2, requestCycle);
            }
        }
    }
}

