/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler;

import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.handler.IIntrospectablePageProvider;
import org.apache.wicket.request.handler.IPageProvider;
import org.apache.wicket.request.mapper.IPageSource;
import org.apache.wicket.request.mapper.StalePageException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageProvider
implements IPageProvider,
IIntrospectablePageProvider {
    private final Integer renderCount;
    private final Integer pageId;
    private IPageSource pageSource;
    private IRequestablePage pageInstance;
    private boolean pageInstanceIsFresh;
    private Class<? extends IRequestablePage> pageClass;
    private PageParameters pageParameters;

    public PageProvider(int pageId, Integer renderCount) {
        this.pageId = pageId;
        this.renderCount = renderCount;
    }

    public PageProvider(int pageId, Class<? extends IRequestablePage> pageClass, Integer renderCount) {
        this(pageId, pageClass, new PageParameters(), renderCount);
    }

    public PageProvider(int pageId, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount) {
        this.pageId = pageId;
        this.setPageClass(pageClass);
        this.setPageParameters(pageParameters);
        this.renderCount = renderCount;
    }

    public PageProvider(Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
        this.setPageClass(pageClass);
        if (pageParameters != null) {
            this.setPageParameters(pageParameters);
        }
        this.pageId = null;
        this.renderCount = null;
    }

    public PageProvider(Class<? extends IRequestablePage> pageClass) {
        this(pageClass, null);
    }

    public PageProvider(IRequestablePage page) {
        Args.notNull((Object)page, (String)"page");
        this.pageInstance = page;
        this.pageId = page.getPageId();
        this.renderCount = page.getRenderCount();
    }

    @Override
    public IRequestablePage getPageInstance() {
        if (this.pageInstance == null) {
            this.resolvePageInstance(this.pageId, this.pageClass, this.pageParameters, this.renderCount);
            if (this.pageInstance == null) {
                throw new PageExpiredException("Page with id '" + this.pageId + "' has expired.");
            }
        }
        return this.pageInstance;
    }

    @Override
    public PageParameters getPageParameters() {
        if (this.pageParameters != null) {
            return this.pageParameters;
        }
        if (!this.isNewPageInstance()) {
            return this.pageInstance.getPageParameters();
        }
        return null;
    }

    @Override
    public boolean isNewPageInstance() {
        IRequestablePage storedPageInstance;
        boolean isNew;
        boolean bl = isNew = this.pageInstance == null;
        if (isNew && this.pageId != null && (storedPageInstance = this.getStoredPage(this.pageId)) != null) {
            this.pageInstance = storedPageInstance;
            isNew = false;
        }
        return isNew;
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        if (this.pageClass != null) {
            return this.pageClass;
        }
        return this.getPageInstance().getClass();
    }

    protected IPageSource getPageSource() {
        if (this.pageSource != null) {
            return this.pageSource;
        }
        if (Application.exists()) {
            return Application.get().getMapperContext();
        }
        throw new IllegalStateException("No application is bound to current thread. Call setPageSource() to manually assign pageSource to this provider.");
    }

    private void resolvePageInstance(Integer pageId, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount) {
        IRequestablePage page = null;
        boolean freshCreated = false;
        if (pageId != null) {
            page = this.getStoredPage(pageId);
        }
        if (page == null && pageClass != null) {
            page = this.getPageSource().newPageInstance(pageClass, pageParameters);
            freshCreated = true;
        }
        if (page != null && !freshCreated && renderCount != null && page.getRenderCount() != renderCount.intValue()) {
            throw new StalePageException(page);
        }
        this.pageInstanceIsFresh = freshCreated;
        this.pageInstance = page;
    }

    private IRequestablePage getStoredPage(int pageId) {
        IRequestablePage storedPageInstance = this.getPageSource().getPageInstance(pageId);
        if (storedPageInstance != null && (this.pageClass == null || this.pageClass.equals(storedPageInstance.getClass()))) {
            this.pageInstance = storedPageInstance;
            if (this.pageInstance != null && this.renderCount != null && this.pageInstance.getRenderCount() != this.renderCount.intValue()) {
                throw new StalePageException(this.pageInstance);
            }
        }
        return storedPageInstance;
    }

    @Override
    public void detach() {
        if (this.pageInstance != null) {
            this.pageInstance.detach();
        }
    }

    public void setPageSource(IPageSource pageSource) {
        this.pageSource = pageSource;
    }

    private void setPageClass(Class<? extends IRequestablePage> pageClass) {
        Args.notNull(pageClass, (String)"pageClass");
        this.pageClass = pageClass;
    }

    private void setPageParameters(PageParameters pageParameters) {
        this.pageParameters = pageParameters;
    }

    @Override
    public Integer getPageId() {
        return this.pageId;
    }

    @Override
    public Integer getRenderCount() {
        return this.renderCount;
    }

    @Override
    public final boolean hasPageInstance() {
        return this.pageInstance != null;
    }

    @Override
    public final boolean isPageInstanceFresh() {
        if (!this.hasPageInstance()) {
            throw new IllegalStateException("Page instance not yet resolved");
        }
        return this.pageInstanceIsFresh;
    }
}

