/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.transformer;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.transformer.AbstractTransformerBehavior;
import org.apache.wicket.markup.transformer.XsltTransformer;

public class XsltTransformerBehavior
extends AbstractTransformerBehavior {
    private static final long serialVersionUID = 1L;
    private final String xslFile;

    public XsltTransformerBehavior() {
        this.xslFile = null;
    }

    public XsltTransformerBehavior(String xslFilePath) {
        this.xslFile = xslFilePath;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        tag.put("xmlns:wicket", "http://wicket.apache.org/dtds.data/wicket-xhtml1.4-strict.dtd");
        super.onComponentTag(component, tag);
    }

    public CharSequence transform(Component component, CharSequence output) throws Exception {
        return new XsltTransformer(this.xslFile).transform(component, output);
    }

    public void bind(Component component) {
        if (component instanceof Page) {
            throw new WicketRuntimeException("You can not attach a XstlTransformerBehavior to a Page. It can be attached to any other component.");
        }
        super.bind(component);
    }
}

