/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.HtmlSpecialTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.IMarkupFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMarkupFilter
implements IMarkupFilter {
    private static final Logger log = LoggerFactory.getLogger(AbstractMarkupFilter.class);
    private IMarkupFilter parent;

    public IMarkupFilter getNextFilter() {
        return this.parent;
    }

    public void setNextFilter(IMarkupFilter parent) {
        this.parent = parent;
    }

    public MarkupElement nextElement() throws ParseException {
        MarkupElement elem = this.getNextFilter().nextElement();
        if (elem != null) {
            if (elem instanceof ComponentTag) {
                elem = this.onComponentTag((ComponentTag)elem);
            } else if (elem instanceof HtmlSpecialTag) {
                elem = this.onSpecialTag((HtmlSpecialTag)elem);
            }
        }
        return elem;
    }

    protected abstract MarkupElement onComponentTag(ComponentTag var1) throws ParseException;

    protected MarkupElement onSpecialTag(HtmlSpecialTag tag) throws ParseException {
        return tag;
    }

    public void postProcess(Markup markup) {
    }
}

