/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.debug.PageView;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.pages.AbstractErrorPage;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionErrorPage
extends AbstractErrorPage {
    private static final long serialVersionUID = 1L;
    private final transient Throwable throwable;

    public ExceptionErrorPage(Throwable throwable, final Page page) {
        this.throwable = throwable;
        this.add(new MultiLineLabel("exception", this.getErrorMessage(throwable)));
        this.add(new MultiLineLabel("stacktrace", this.getStackTrace(throwable)));
        String resource = "";
        String markup = "";
        MarkupStream markupStream = null;
        if (throwable instanceof MarkupException && (markupStream = ((MarkupException)throwable).getMarkupStream()) != null) {
            markup = markupStream.toHtmlDebugString();
            resource = markupStream.getResource().toString();
        }
        MultiLineLabel markupLabel = new MultiLineLabel("markup", markup);
        markupLabel.setEscapeModelStrings(false);
        WebMarkupContainer markupHighlight = new WebMarkupContainer("markupHighlight");
        markupHighlight.add(markupLabel);
        markupHighlight.add(new Label("resource", resource));
        this.add(markupHighlight);
        markupHighlight.setVisible(markupStream != null);
        this.add(new Link<Void>("displayPageViewLink"){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClick() {
                ExceptionErrorPage.this.replace(new PageView("componentTree", page));
                this.setVisible(false);
            }
        });
        this.add(new Label("componentTree", ""));
    }

    public String getErrorMessage(Throwable throwable) {
        if (throwable != null) {
            String msg;
            StringBuilder sb = new StringBuilder(256);
            List<Throwable> al = this.convertToList(throwable);
            int length = al.size() - 1;
            Throwable cause = al.get(length);
            sb.append("Last cause: ").append(cause.getMessage()).append('\n');
            if (throwable instanceof WicketRuntimeException && (msg = throwable.getMessage()) != null && !msg.equals(cause.getMessage())) {
                String text;
                MarkupStream stream;
                if (throwable instanceof MarkupException && (stream = ((MarkupException)throwable).getMarkupStream()) != null && msg.endsWith(text = "\n" + stream.toString())) {
                    msg = msg.substring(0, msg.length() - text.length());
                }
                sb.append("WicketMessage: ");
                sb.append(msg);
                sb.append("\n\n");
            }
            return sb.toString();
        }
        return "[Unknown]";
    }

    public String getStackTrace(Throwable throwable) {
        if (throwable != null) {
            List<Throwable> al = this.convertToList(throwable);
            StringBuilder sb = new StringBuilder(256);
            int length = al.size() - 1;
            Throwable cause = al.get(length);
            sb.append("Root cause:\n\n");
            this.outputThrowable(cause, sb, false);
            if (length > 0) {
                sb.append("\n\nComplete stack:\n\n");
                for (int i = 0; i < length; ++i) {
                    this.outputThrowable(al.get(i), sb, true);
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        return "<Null Throwable>";
    }

    private List<Throwable> convertToList(Throwable throwable) {
        Throwable cause;
        ArrayList al = Generics.newArrayList();
        al.add(cause);
        for (cause = throwable; cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
            al.add(cause);
        }
        return al;
    }

    private void outputThrowable(Throwable cause, StringBuilder sb, boolean stopAtWicketServlet) {
        sb.append(cause);
        sb.append("\n");
        StackTraceElement[] trace = cause.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            String traceString = trace[i].toString();
            if (traceString.startsWith("sun.reflect.") && i > 1) continue;
            sb.append("     at ");
            sb.append(traceString);
            sb.append("\n");
            if (!stopAtWicketServlet || !traceString.startsWith("org.apache.wicket.protocol.http.WicketServlet") && !traceString.startsWith("org.apache.wicket.protocol.http.WicketFilter")) continue;
            return;
        }
    }

    @Override
    protected void setHeaders(WebResponse response) {
        response.setStatus(500);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

