/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.IResourceListener;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLink<T>
extends Link<T>
implements IResourceListener {
    private static final long serialVersionUID = 1L;
    private final ResourceReference resourceReference;
    private final IResource resource;
    private final PageParameters resourceParameters;

    public ResourceLink(String id, ResourceReference resourceReference) {
        this(id, resourceReference, null);
    }

    public ResourceLink(String id, ResourceReference resourceReference, PageParameters resourceParameters) {
        super(id);
        this.resourceReference = resourceReference;
        this.resourceParameters = resourceParameters;
        this.resource = null;
    }

    public ResourceLink(String id, IResource resource) {
        super(id);
        this.resource = resource;
        this.resourceReference = null;
        this.resourceParameters = null;
    }

    @Override
    public void onClick() {
    }

    @Override
    public final void onResourceRequested() {
        IResource.Attributes a = new IResource.Attributes(RequestCycle.get().getRequest(), RequestCycle.get().getResponse(), null);
        this.resource.respond(a);
        this.onLinkClicked();
    }

    @Override
    protected final CharSequence getURL() {
        if (this.resourceReference != null) {
            if (this.resourceReference.canBeRegistered()) {
                this.getApplication().getResourceReferenceRegistry().registerResourceReference(this.resourceReference);
            }
            return this.getRequestCycle().urlFor(new ResourceReferenceRequestHandler(this.resourceReference, this.resourceParameters));
        }
        return this.urlFor(IResourceListener.INTERFACE);
    }
}

