/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.response.NullResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.JavaScriptUtils;
import org.apache.wicket.util.string.Strings;

public abstract class HeaderResponse
implements IHeaderResponse {
    private final Set<Object> rendered = new HashSet<Object>();
    private boolean closed;

    public final void markRendered(Object object) {
        this.rendered.add(object);
    }

    public void renderCSS(CharSequence css, String id) {
        List<String> token;
        Args.notNull((Object)css, (String)"css");
        if (!this.closed && !this.wasRendered(token = Arrays.asList(((Object)css).toString(), id))) {
            this.renderString("<style type=\"text/css\"><!--\n" + css + "--></style>\n");
            this.markRendered(token);
        }
    }

    public void renderCSSReference(ResourceReference reference) {
        this.renderCSSReference(reference, null, null);
    }

    public void renderCSSReference(ResourceReference reference, String media) {
        this.renderCSSReference(reference, null, media);
    }

    public void renderCSSReference(ResourceReference reference, PageParameters pageParameters, String media) {
        this.renderCSSReference(reference, pageParameters, media, null);
    }

    public void renderCSSReference(ResourceReference reference, PageParameters pageParameters, String media, String condition) {
        Args.notNull((Object)reference, (String)"reference");
        if (!this.closed) {
            ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(reference, pageParameters);
            CharSequence url = RequestCycle.get().urlFor(handler);
            this.internalRenderCSSReference(((Object)url).toString(), media, condition);
        }
    }

    public void renderCSSReference(String url) {
        this.renderCSSReference(url, null);
    }

    public void renderCSSReference(String url, String media) {
        this.renderCSSReference(url, media, null);
    }

    public void renderCSSReference(String url, String media, String condition) {
        this.internalRenderCSSReference(this.relative(url), media, condition);
    }

    private void internalRenderCSSReference(String url, String media, String condition) {
        if (Strings.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("url cannot be empty or null");
        }
        if (!this.closed) {
            String urlWoSessionId = Strings.stripJSessionId((String)url);
            List<String> token = Arrays.asList("css", urlWoSessionId, media);
            if (!this.wasRendered(token)) {
                if (!Strings.isEmpty((CharSequence)condition)) {
                    this.getResponse().write((CharSequence)"<!--[if ");
                    this.getResponse().write((CharSequence)condition);
                    this.getResponse().write((CharSequence)"]>");
                }
                this.getResponse().write((CharSequence)"<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                this.getResponse().write((CharSequence)urlWoSessionId);
                this.getResponse().write((CharSequence)"\"");
                if (media != null) {
                    this.getResponse().write((CharSequence)" media=\"");
                    this.getResponse().write((CharSequence)media);
                    this.getResponse().write((CharSequence)"\"");
                }
                this.getResponse().write((CharSequence)" />");
                if (!Strings.isEmpty((CharSequence)condition)) {
                    this.getResponse().write((CharSequence)"<![endif]-->");
                }
                this.getResponse().write((CharSequence)"\n");
                this.markRendered(token);
            }
        }
    }

    public void renderJavaScriptReference(ResourceReference reference) {
        this.renderJavaScriptReference(reference, null);
    }

    public void renderJavaScriptReference(ResourceReference reference, String id) {
        this.renderJavaScriptReference(reference, null, id);
    }

    public void renderJavaScriptReference(ResourceReference reference, PageParameters pageParameters, String id) {
        this.renderJavaScriptReference(reference, pageParameters, id, false);
    }

    public void renderJavaScriptReference(ResourceReference reference, PageParameters pageParameters, String id, boolean defer) {
        this.renderJavaScriptReference(reference, pageParameters, id, defer, null);
    }

    public void renderJavaScriptReference(ResourceReference reference, PageParameters pageParameters, String id, boolean defer, String charset) {
        Args.notNull((Object)reference, (String)"reference");
        if (!this.closed) {
            ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(reference, pageParameters);
            CharSequence url = RequestCycle.get().urlFor(handler);
            this.internalRenderJavaScriptReference(((Object)url).toString(), id, defer, charset);
        }
    }

    public void renderJavaScriptReference(String url) {
        this.renderJavaScriptReference(url, null);
    }

    public void renderJavaScriptReference(String url, String id) {
        this.renderJavaScriptReference(url, id, false);
    }

    public void renderJavaScriptReference(String url, String id, boolean defer) {
        this.renderJavaScriptReference(url, id, defer, null);
    }

    public void renderJavaScriptReference(String url, String id, boolean defer, String charset) {
        this.internalRenderJavaScriptReference(this.relative(url), id, defer, charset);
    }

    private void internalRenderJavaScriptReference(String url, String id, boolean defer, String charset) {
        if (Strings.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("url cannot be empty or null");
        }
        if (!this.closed) {
            boolean token2Unused;
            String urlWoSessionId = Strings.stripJSessionId((String)url);
            List<String> token1 = Arrays.asList("javascript", urlWoSessionId);
            List<String> token2 = id != null ? Arrays.asList("javascript", id) : null;
            boolean token1Unused = !this.wasRendered(token1);
            boolean bl = token2Unused = token2 == null || !this.wasRendered(token2);
            if (token1Unused && token2Unused) {
                JavaScriptUtils.writeJavaScriptUrl(this.getResponse(), urlWoSessionId, id, defer, charset);
                this.markRendered(token1);
                if (token2 != null) {
                    this.markRendered(token2);
                }
            }
        }
    }

    public void renderJavaScript(CharSequence javascript, String id) {
        List<String> token;
        Args.notNull((Object)javascript, (String)"javascript");
        if (!this.closed && !this.wasRendered(token = Arrays.asList(((Object)javascript).toString(), id))) {
            JavaScriptUtils.writeJavaScript(this.getResponse(), javascript, id);
            this.markRendered(token);
        }
    }

    public void renderString(CharSequence string) {
        String token;
        Args.notNull((Object)string, (String)"string");
        if (!this.closed && !this.wasRendered(token = ((Object)string).toString())) {
            this.getResponse().write(string);
            this.markRendered(token);
        }
    }

    public final boolean wasRendered(Object object) {
        return this.rendered.contains(object);
    }

    public void renderOnDomReadyJavaScript(String javascript) {
        if (javascript == null) {
            throw new IllegalArgumentException("javascript cannot be null");
        }
        if (!this.closed) {
            this.renderOnEventJavaScript("window", "domready", javascript);
        }
    }

    public void renderOnLoadJavaScript(String javascript) {
        if (javascript == null) {
            throw new IllegalArgumentException("javascript cannot be null");
        }
        if (!this.closed) {
            this.renderOnEventJavaScript("window", "load", javascript);
        }
    }

    public void renderOnEventJavaScript(String target, String event, String javascript) {
        List<String> token;
        if (!this.closed && !this.wasRendered(token = Arrays.asList("javascript-event", target, event, javascript))) {
            this.renderJavaScriptReference(WicketEventReference.INSTANCE);
            JavaScriptUtils.writeJavaScript(this.getResponse(), "Wicket.Event.add(" + target + ", \"" + event + "\", function(event) { " + javascript + ";});");
            this.markRendered(token);
        }
    }

    public void close() {
        this.closed = true;
    }

    public final Response getResponse() {
        return this.closed ? NullResponse.getInstance() : this.getRealResponse();
    }

    public boolean isClosed() {
        return this.closed;
    }

    private String relative(String url) {
        Args.notEmpty((CharSequence)url, (String)"location");
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("/")) {
            return url;
        }
        RequestCycle rc = RequestCycle.get();
        return rc.getUrlRenderer().renderContextRelativeUrl(url);
    }

    protected abstract Response getRealResponse();
}

