/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image.resource;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IResourceFactory;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.parse.metapattern.Group;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.apache.wicket.util.parse.metapattern.OptionalMetaPattern;
import org.apache.wicket.util.parse.metapattern.parsers.MetaPatternParser;
import org.apache.wicket.util.string.Strings;

public final class LocalizedImageResource
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private Boolean resourceKind;
    private final Component component;
    private IResource resource;
    private ResourceReference resourceReference;
    private PageParameters resourceParameters;
    private Locale locale;
    private String style;
    private String variation;

    public LocalizedImageResource(Component component) {
        this.component = component;
        this.locale = component.getLocale();
        this.style = component.getStyle();
        this.variation = component.getVariation();
    }

    public final void bind() {
        if (this.resourceReference != null && this.resourceReference.canBeRegistered() && Application.exists()) {
            Application.get().getResourceReferenceRegistry().registerResourceReference(this.resourceReference);
        }
    }

    public final void onResourceRequested(PageParameters parameters) {
        this.bind();
        RequestCycle requestCycle = RequestCycle.get();
        IResource.Attributes attributes = new IResource.Attributes(requestCycle.getRequest(), requestCycle.getResponse(), parameters);
        this.resource.respond(attributes);
    }

    public final void setResource(IResource resource) {
        if (this.resource != resource) {
            this.resourceKind = Boolean.TRUE;
            this.resource = resource;
        }
    }

    public final void setResourceReference(ResourceReference resourceReference) {
        this.setResourceReference(resourceReference, this.resourceParameters);
    }

    public final boolean isStateless() {
        return this.resourceReference != null;
    }

    public final void setResourceReference(ResourceReference resourceReference, PageParameters resourceParameters) {
        if (resourceReference != this.resourceReference) {
            this.resourceKind = Boolean.FALSE;
            this.resourceReference = resourceReference;
        }
        this.resourceParameters = resourceParameters;
        this.bind();
    }

    public final void setSrcAttribute(ComponentTag tag) {
        Object modelObject;
        Locale l = this.component.getLocale();
        String s = this.component.getStyle();
        String v = this.component.getVariation();
        if (!(this.resourceKind != null || Objects.equal((Object)this.locale, (Object)l) && Objects.equal((Object)this.style, (Object)s) && Objects.equal((Object)this.variation, (Object)v))) {
            this.locale = l;
            this.style = s;
            this.variation = v;
            this.resourceReference = null;
            this.resource = null;
        }
        if ((modelObject = this.component.getDefaultModelObject()) instanceof ResourceReference) {
            this.resourceReference = (ResourceReference)modelObject;
        } else if (modelObject instanceof IResource) {
            this.resource = (IResource)modelObject;
        }
        if (this.resource == null && this.resourceReference == null) {
            String src = tag.getAttribute("src");
            if (src != null) {
                this.loadStaticImage(src.toString());
            } else {
                String value = tag.getAttribute("value");
                if (value != null) {
                    this.newImage(value);
                } else {
                    this.loadStaticImage(this.component.getDefaultModelObjectAsString());
                }
            }
        }
        CharSequence url = this.resourceReference != null ? RequestCycle.get().urlFor(this.resourceReference, this.resourceParameters) : this.component.urlFor(IResourceListener.INTERFACE);
        tag.put("src", url);
    }

    private IResourceFactory getResourceFactory(Application application, String factoryName) {
        IResourceFactory factory = application.getResourceSettings().getResourceFactory(factoryName);
        if (factory == null) {
            throw new WicketRuntimeException("Could not find image resource factory named " + factoryName);
        }
        return factory;
    }

    private void loadStaticImage(String path) {
        MarkupContainer parent = this.component.findParentWithAssociatedMarkup();
        if (parent instanceof Border) {
            parent = parent.getParent();
        }
        Class<?> scope = parent.getClass();
        this.resourceReference = new PackageResourceReference(scope, path, this.locale, this.style, this.variation);
        this.bind();
    }

    private void newImage(CharSequence value) {
        ImageValueParser valueParser = new ImageValueParser(value);
        if (valueParser.matches()) {
            String imageReferenceName = valueParser.getImageReferenceName();
            String specification = Strings.replaceHtmlEscapeNumber((String)valueParser.getSpecification());
            String factoryName = valueParser.getFactoryName();
            Application application = this.component.getApplication();
            if (!Strings.isEmpty((CharSequence)imageReferenceName)) {
                if (application.getResourceReferenceRegistry().getResourceReference(Application.class, imageReferenceName, this.locale, this.style, this.variation, true, false) == null) {
                    IResource imageResource = this.getResourceFactory(application, factoryName).newResource(specification, this.locale, this.style, this.variation);
                    SimpleStaticResourceReference ref = new SimpleStaticResourceReference(Application.class, imageReferenceName, this.locale, this.style, this.variation, imageResource);
                    application.getResourceReferenceRegistry().registerResourceReference(ref);
                }
                this.resourceReference = new PackageResourceReference(Application.class, imageReferenceName, this.locale, this.style, this.variation);
            } else {
                this.resource = this.getResourceFactory(application, factoryName).newResource(specification, this.locale, this.style, this.variation);
            }
        } else {
            throw new WicketRuntimeException("Could not generate image for value attribute '" + value + "'.  Was expecting a value attribute of the form \"[resourceFactoryName]:[resourceReferenceName]?:[factorySpecification]\".");
        }
    }

    public final IResource getResource() {
        return this.resource;
    }

    public final ResourceReference getResourceReference() {
        return this.resourceReference;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleStaticResourceReference
    extends ResourceReference {
        final IResource resource;
        private static final long serialVersionUID = 1L;

        public SimpleStaticResourceReference(Class<?> scope, String name, Locale locale, String style, String variation, IResource resource) {
            super(scope, name, locale, style, variation);
            this.resource = resource;
        }

        @Override
        public IResource getResource() {
            return this.resource;
        }
    }

    private static final class ImageValueParser
    extends MetaPatternParser {
        private static final Group factoryName = new Group(MetaPattern.VARIABLE_NAME);
        private static final Group imageReferenceName = new Group(MetaPattern.VARIABLE_NAME);
        private static final Group specification = new Group(MetaPattern.ANYTHING_NON_EMPTY);
        private static final MetaPattern pattern = new MetaPattern(new MetaPattern[]{factoryName, MetaPattern.COLON, new OptionalMetaPattern(new MetaPattern[]{imageReferenceName}), MetaPattern.COLON, specification});

        private ImageValueParser(CharSequence input) {
            super(pattern, input);
        }

        private String getFactoryName() {
            return factoryName.get(this.matcher());
        }

        private String getImageReferenceName() {
            return imageReferenceName.get(this.matcher());
        }

        private String getSpecification() {
            return specification.get(this.matcher());
        }
    }
}

