/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.AbstractSubmitLink;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormModelUpdateListener;
import org.apache.wicket.markup.html.form.IFormSubmitListener;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.validation.FormValidatorAdapter;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlDecoder;
import org.apache.wicket.request.UrlRenderer;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.upload.FileUploadBase;
import org.apache.wicket.util.upload.FileUploadException;
import org.apache.wicket.util.value.LongValue;
import org.apache.wicket.util.visit.ClassVisitFilter;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitFilter;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form<T>
extends WebMarkupContainer
implements IFormSubmitListener {
    private static final String HIDDEN_DIV_START = "<div style=\"width:0px;height:0px;position:absolute;left:-100px;top:-100px;overflow:hidden\">";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private static final short FLAG_SUBMITTED = 256;
    private static final Logger log = LoggerFactory.getLogger(Form.class);
    private static final long serialVersionUID = 1L;
    private static final String UPLOAD_FAILED_RESOURCE_KEY = "uploadFailed";
    private static final String UPLOAD_TOO_LARGE_RESOURCE_KEY = "uploadTooLarge";
    private IFormSubmittingComponent defaultSubmittingComponent;
    private Bytes maxSize = null;
    private short multiPart = 0;
    private static final short MULTIPART_HARD = 1;
    private static final short MULTIPART_HINT = 2;

    public Form(String id) {
        this(id, (IModel<T>)null);
    }

    public Form(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    public void add(IFormValidator validator) {
        Args.notNull((Object)validator, (String)"validator");
        if (validator instanceof Behavior) {
            this.add((Behavior)((Object)validator));
        } else {
            this.add(new FormValidatorAdapter(validator));
        }
    }

    public void remove(IFormValidator validator) {
        Args.notNull((Object)validator, (String)"validator");
        Behavior match = null;
        for (Behavior behavior : this.getBehaviors()) {
            if (behavior.equals(validator)) {
                match = behavior;
                break;
            }
            if (!(behavior instanceof FormValidatorAdapter) || !((FormValidatorAdapter)behavior).getValidator().equals(validator)) continue;
            match = behavior;
            break;
        }
        if (match == null) {
            throw new IllegalStateException("Tried to remove form validator that was not previously added. Make sure your validator's equals() implementation is sufficient");
        }
        this.remove(match);
    }

    public final void clearInput() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.clearInput();
                }
            }
        });
    }

    public final void error(String error, Map<String, Object> args) {
        this.error((Serializable)((Object)new MapVariableInterpolator(error, args).toString()));
    }

    public final IFormSubmitter findSubmittingButton() {
        IFormSubmittingComponent submittingComponent = this.getPage().visitChildren(IFormSubmittingComponent.class, new IVisitor<Component, IFormSubmittingComponent>(){

            public void component(Component component, IVisit<IFormSubmittingComponent> visit) {
                IFormSubmittingComponent submittingComponent = (IFormSubmittingComponent)((Object)component);
                Form<?> form = submittingComponent.getForm();
                if (form != null && form.getRootForm() == Form.this) {
                    String name = submittingComponent.getInputName();
                    IRequestParameters parameters = Form.this.getRequest().getRequestParameters();
                    if (!parameters.getParameterValue(name).isNull() || !parameters.getParameterValue(name + ".x").isNull()) {
                        if (!component.isVisibleInHierarchy()) {
                            throw new WicketRuntimeException("Submit Button " + submittingComponent.getInputName() + " (path=" + component.getPageRelativePath() + ") is not visible");
                        }
                        if (!component.isEnabledInHierarchy()) {
                            throw new WicketRuntimeException("Submit Button " + submittingComponent.getInputName() + " (path=" + component.getPageRelativePath() + ") is not enabled");
                        }
                        visit.stop((Object)submittingComponent);
                    }
                }
            }
        });
        return submittingComponent;
    }

    public final IFormSubmittingComponent getDefaultButton() {
        if (this.isRootForm()) {
            return this.defaultSubmittingComponent;
        }
        return this.getRootForm().getDefaultButton();
    }

    public final Collection<IFormValidator> getFormValidators() {
        ArrayList<IFormValidator> validators = new ArrayList<IFormValidator>();
        for (Behavior behavior : this.getBehaviors()) {
            if (!(behavior instanceof IFormValidator)) continue;
            validators.add((IFormValidator)((Object)behavior));
        }
        return Collections.unmodifiableCollection(validators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CharSequence getJsForInterfaceUrl(CharSequence url) {
        UrlRenderer renderer = this.getRequestCycle().getUrlRenderer();
        Url oldBase = renderer.getBaseUrl();
        try {
            Url action = Url.parse((String)((Object)this.getActionUrl()).toString());
            renderer.setBaseUrl(action);
            url = renderer.renderUrl(Url.parse((String)((Object)url).toString()));
        }
        finally {
            renderer.setBaseUrl(oldBase);
        }
        Form<?> root = this.getRootForm();
        return new AppendingStringBuffer((CharSequence)"document.getElementById('").append(root.getHiddenFieldId()).append("').value='").append((Object)url).append("';document.getElementById('").append(root.getMarkupId()).append("').submit();");
    }

    public final Bytes getMaxSize() {
        final Bytes[] maxSize = new Bytes[]{this.maxSize};
        if (maxSize[0] == null) {
            this.visitChildren(Form.class, new IVisitor<Form<?>, Bytes>(){

                public void component(Form<?> component, IVisit<Bytes> visit) {
                    maxSize[0] = (Bytes)LongValue.maxNullSafe((LongValue)maxSize[0], (LongValue)((Form)component).maxSize);
                }
            });
        }
        if (maxSize[0] == null) {
            return this.getApplication().getApplicationSettings().getDefaultMaximumUploadSize();
        }
        return maxSize[0];
    }

    public Form<?> getRootForm() {
        Form form;
        Form parent = this;
        while ((parent = (form = parent).findParent(Form.class)) != null) {
        }
        return form;
    }

    public String getValidatorKeyPrefix() {
        return null;
    }

    public final boolean hasError() {
        if (this.hasErrorMessage()) {
            return true;
        }
        return this.anyFormComponentError();
    }

    public boolean isRootForm() {
        return this.findParent(Form.class) == null;
    }

    public final boolean isSubmitted() {
        return this.getFlag(256);
    }

    @Override
    public final void onFormSubmitted() {
        if (this.getRequest().getContainerRequest() instanceof HttpServletRequest) {
            String desiredMethod = this.getMethod();
            String actualMethod = ((HttpServletRequest)this.getRequest().getContainerRequest()).getMethod();
            if (!actualMethod.equalsIgnoreCase(this.getMethod())) {
                MethodMismatchResponse response = this.onMethodMismatch();
                switch (response) {
                    case ABORT: {
                        return;
                    }
                    case CONTINUE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid " + MethodMismatchResponse.class.getName() + " value: " + (Object)((Object)response));
                    }
                }
            }
        }
        this.onFormSubmitted(null);
    }

    protected MethodMismatchResponse onMethodMismatch() {
        return MethodMismatchResponse.CONTINUE;
    }

    public final void onFormSubmitted(IFormSubmitter submitter) {
        this.markFormsSubmitted();
        if (this.handleMultiPart()) {
            this.inputChanged();
            String url = this.getRequest().getRequestParameters().getParameterValue(this.getHiddenFieldId()).toString();
            if (!Strings.isEmpty((CharSequence)url)) {
                this.dispatchEvent(this.getPage(), url);
            } else {
                if (submitter == null) {
                    submitter = this.findSubmittingButton();
                }
                if (submitter != null && !submitter.getDefaultFormProcessing()) {
                    submitter.onSubmit();
                } else {
                    Form<?> formToProcess = this;
                    if (submitter != null) {
                        formToProcess = submitter.getForm();
                    }
                    formToProcess.process(submitter);
                }
            }
        } else if (this.hasError()) {
            this.callOnError(submitter);
        }
    }

    public void process(IFormSubmitter submittingComponent) {
        Page page = this.getPage();
        String hiddenFieldId = this.getHiddenFieldId();
        if (!this.isEnabledInHierarchy() || !this.isVisibleInHierarchy()) {
            return;
        }
        this.validate();
        if (this.hasError()) {
            this.markFormComponentsInvalid();
            this.callOnError(submittingComponent);
        } else {
            this.markFormComponentsValid();
            this.beforeUpdateFormComponentModels();
            this.updateFormComponentModels();
            this.onValidateModelObjects();
            if (this.hasError()) {
                this.callOnError(submittingComponent);
                return;
            }
            this.delegateSubmit(submittingComponent);
        }
        final PageParameters parameters = page.getPageParameters();
        if (parameters != null) {
            this.visitFormComponents(new IVisitor<FormComponent<?>, Void>(){

                public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                    parameters.remove(formComponent.getInputName());
                }
            });
            parameters.remove(hiddenFieldId);
            if (submittingComponent instanceof AbstractSubmitLink) {
                AbstractSubmitLink submitLink = (AbstractSubmitLink)submittingComponent;
                parameters.remove(submitLink.getInputName());
            }
        }
    }

    protected void callOnError(IFormSubmitter submitter) {
        if (submitter != null) {
            submitter.onError();
        }
        this.onError();
        this.visitChildren(Form.class, new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                Form form = (Form)component;
                if (!form.isEnabledInHierarchy() || !form.isVisibleInHierarchy()) {
                    visit.dontGoDeeper();
                    return;
                }
                if (form.hasError()) {
                    form.onError();
                }
            }
        });
    }

    private void markFormsSubmitted() {
        this.setFlag(256, true);
        this.visitChildren(Form.class, new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                Form form = (Form)component;
                if (form.isEnabledInHierarchy() && Form.this.isVisibleInHierarchy()) {
                    form.setFlag(256, true);
                    return;
                }
                visit.dontGoDeeper();
            }
        });
    }

    public final void setDefaultButton(IFormSubmittingComponent submittingComponent) {
        if (this.isRootForm()) {
            this.defaultSubmittingComponent = submittingComponent;
        } else {
            this.getRootForm().setDefaultButton(submittingComponent);
        }
    }

    public final void setMaxSize(Bytes maxSize) {
        this.maxSize = maxSize;
    }

    public void setMultiPart(boolean multiPart) {
        this.multiPart = multiPart ? (short)(this.multiPart | 1) : (short)(this.multiPart & 0xFFFFFFFE);
    }

    @Override
    public final Component setVersioned(final boolean isVersioned) {
        super.setVersioned(isVersioned);
        this.visitFormComponents(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                formComponent.setVersioned(isVersioned);
            }
        });
        return this;
    }

    public final <R> R visitFormComponents(IVisitor<? extends FormComponent<?>, R> visitor) {
        return this.visitChildren(FormComponent.class, visitor);
    }

    public final <R> R visitFormComponentsPostOrder(IVisitor<? extends FormComponent<?>, R> visitor) {
        return FormComponent.visitFormComponentsPostOrder(this, visitor);
    }

    private boolean anyFormComponentError() {
        Boolean error = this.visitChildren(Component.class, new IVisitor<Component, Boolean>(){

            public void component(Component component, IVisit<Boolean> visit) {
                if (component.hasErrorMessage()) {
                    visit.stop((Object)true);
                }
            }
        });
        return error != null && error != false;
    }

    private void dispatchEvent(Page page, String url) {
        Url resolved = new Url(this.getRequest().getUrl());
        resolved.resolveRelative(Url.parse((String)url));
        IRequestMapper mapper = this.getApplication().getRootRequestMapper();
        Request request = this.getRequest().cloneWithUrl(resolved);
        IRequestHandler handler = mapper.mapRequest(request);
        if (handler != null) {
            this.getRequestCycle().scheduleRequestHandlerAfterCurrent(handler);
        }
    }

    private void inputChanged() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                formComponent.inputChanged();
            }
        });
    }

    protected void appendDefaultButtonField(MarkupStream markupStream, ComponentTag openTag) {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append(HIDDEN_DIV_START);
        buffer.append("<input type=\"text\" autocomplete=\"off\"/>");
        Component submittingComponent = (Component)((Object)this.defaultSubmittingComponent);
        buffer.append("<input type=\"submit\" name=\"");
        buffer.append(this.defaultSubmittingComponent.getInputName());
        buffer.append("\" onclick=\" var b=document.getElementById('");
        buffer.append(submittingComponent.getMarkupId());
        buffer.append("'); if (b!=null&amp;&amp;b.onclick!=null&amp;&amp;typeof(b.onclick) != 'undefined') {  var r = b.onclick.bind(b)(); if (r != false) b.click(); } else { b.click(); };  return false;\" ");
        buffer.append(" />");
        buffer.append("</div>");
        this.getResponse().write((CharSequence)buffer);
    }

    protected void beforeUpdateFormComponentModels() {
    }

    protected void delegateSubmit(IFormSubmitter submittingComponent) {
        Form<?> processingForm;
        if (submittingComponent != null) {
            processingForm = submittingComponent.getForm();
            if (processingForm == null) {
                throw new IllegalStateException("submitting component must not return 'null' on getForm()");
            }
            submittingComponent.onSubmit();
        } else {
            processingForm = this;
        }
        Visits.visitPostOrder(processingForm, (IVisitor)new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    form.onSubmit();
                }
            }
        }, (IVisitFilter)new ClassVisitFilter(Form.class));
    }

    public final String getHiddenFieldId() {
        return this.getInputNamePrefix() + this.getMarkupId() + "_hf_0";
    }

    protected String getMethod() {
        String method = this.getMarkupAttributes().getString("method");
        return method != null ? method : METHOD_POST;
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }

    public boolean isMultiPart() {
        if (this.multiPart != 0) {
            return true;
        }
        Boolean anyEmbeddedMultipart = this.visitChildren(Component.class, new IVisitor<Component, Boolean>(){

            public void component(Component component, IVisit<Boolean> visit) {
                FormComponent fc;
                boolean isMultiPart = false;
                if (component instanceof Form) {
                    Form form = (Form)component;
                    if (form.isVisibleInHierarchy() && form.isEnabledInHierarchy()) {
                        isMultiPart = form.multiPart != 0;
                    }
                } else if (component instanceof FormComponent && (fc = (FormComponent)component).isVisibleInHierarchy() && fc.isEnabledInHierarchy()) {
                    isMultiPart = fc.isMultiPart();
                }
                if (isMultiPart) {
                    visit.stop((Object)true);
                }
            }
        });
        boolean mp = Boolean.TRUE.equals(anyEmbeddedMultipart);
        if (mp) {
            this.multiPart = (short)(this.multiPart | 2);
        }
        return mp;
    }

    protected boolean handleMultiPart() {
        if (this.isMultiPart()) {
            try {
                ServletWebRequest request = (ServletWebRequest)this.getRequest();
                MultipartServletWebRequest multipartWebRequest = request.newMultipartWebRequest(this.getMaxSize(), this.getPage().getId());
                this.getRequestCycle().setRequest((Request)multipartWebRequest);
            }
            catch (FileUploadException fux) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("exception", (Object)fux);
                model.put("maxSize", this.getMaxSize());
                this.onFileUploadException(fux, model);
                return false;
            }
        }
        return true;
    }

    protected void onFileUploadException(FileUploadException e, Map<String, Object> model) {
        if (e instanceof FileUploadBase.SizeLimitExceededException) {
            String defaultValue = "Upload must be less than " + this.getMaxSize();
            String msg = this.getString(this.getId() + '.' + UPLOAD_TOO_LARGE_RESOURCE_KEY, Model.ofMap(model), defaultValue);
            this.error((Serializable)((Object)msg));
        } else {
            String defaultValue = "Upload failed: " + e.getLocalizedMessage();
            String msg = this.getString(this.getId() + '.' + UPLOAD_FAILED_RESOURCE_KEY, Model.ofMap(model), defaultValue);
            this.error((Serializable)((Object)msg));
            log.warn(msg, (Throwable)e);
        }
    }

    @Override
    protected void internalOnModelChanged() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (formComponent.sameInnermostModel(Form.this)) {
                    formComponent.modelChanged();
                }
            }
        });
    }

    protected final void markFormComponentsInvalid() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.invalid();
                }
            }
        });
    }

    protected final void markFormComponentsValid() {
        this.internalMarkFormComponentsValid();
        this.markNestedFormComponentsValid();
    }

    private void markNestedFormComponentsValid() {
        this.visitChildren(Form.class, new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    ((Form)form).internalMarkFormComponentsValid();
                } else {
                    visit.dontGoDeeper();
                }
            }
        });
    }

    private void internalMarkFormComponentsValid() {
        this.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (formComponent.getForm() == Form.this && formComponent.isVisibleInHierarchy()) {
                    formComponent.valid();
                }
            }
        });
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "form");
        if (this.isRootForm()) {
            String method = this.getMethod().toLowerCase(Locale.ENGLISH);
            tag.put("method", method);
            String url = ((Object)this.getActionUrl()).toString();
            if (this.encodeUrlInHiddenFields()) {
                int i = url.indexOf(63);
                String action = i > -1 ? url.substring(0, i) : "";
                tag.put("action", action);
            } else {
                tag.put("action", url);
            }
            if (this.isMultiPart()) {
                if (METHOD_GET.equalsIgnoreCase(method)) {
                    log.warn("Form with id '{}' is multipart. It should use method 'POST'!", (Object)this.getId());
                    tag.put("method", METHOD_POST.toLowerCase(Locale.ENGLISH));
                }
                tag.put("enctype", "multipart/form-data");
                tag.put("accept-charset", this.getApplication().getRequestCycleSettings().getResponseRequestEncoding());
            } else {
                String enctype = (String)tag.getAttributes().get((Object)"enctype");
                if ("multipart/form-data".equalsIgnoreCase(enctype)) {
                    this.setMultiPart(true);
                }
            }
        } else {
            tag.setName("div");
            tag.remove("method");
            tag.remove("action");
            tag.remove("enctype");
        }
    }

    protected CharSequence getActionUrl() {
        return this.urlFor(IFormSubmitListener.INTERFACE);
    }

    @Override
    protected void renderPlaceholderTag(ComponentTag tag, Response response) {
        if (this.isRootForm()) {
            super.renderPlaceholderTag(tag, response);
        } else {
            response.write((CharSequence)"<div style=\"display:none\"");
            if (this.getOutputMarkupId()) {
                response.write((CharSequence)" id=\"");
                response.write((CharSequence)this.getMarkupId());
                response.write((CharSequence)"\"");
            }
            response.write((CharSequence)"></div>");
        }
    }

    protected boolean encodeUrlInHiddenFields() {
        return METHOD_GET.equalsIgnoreCase(this.getMethod());
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (this.isRootForm()) {
            Component submittingComponent;
            String nameAndId = this.getHiddenFieldId();
            AppendingStringBuffer buffer = new AppendingStringBuffer((CharSequence)HIDDEN_DIV_START).append("<input type=\"hidden\" name=\"").append(nameAndId).append("\" id=\"").append(nameAndId).append("\" />");
            if (this.encodeUrlInHiddenFields()) {
                String url = ((Object)this.getActionUrl()).toString();
                int i = url.indexOf(63);
                String[] params = (i > -1 ? url.substring(i + 1) : url).split("&");
                this.writeParamsAsHiddenFields(params, buffer);
            }
            buffer.append("</div>");
            this.getResponse().write((CharSequence)buffer);
            if (this.defaultSubmittingComponent instanceof Component && (submittingComponent = (Component)((Object)this.defaultSubmittingComponent)).isVisibleInHierarchy() && submittingComponent.isEnabledInHierarchy()) {
                this.appendDefaultButtonField(markupStream, openTag);
            }
        }
        super.onComponentTagBody(markupStream, openTag);
    }

    protected void writeParamsAsHiddenFields(String[] params, AppendingStringBuffer buffer) {
        for (String param : params) {
            String[] pair = Strings.split((String)param, (char)'=');
            buffer.append("<input type=\"hidden\" name=\"").append(this.recode(pair[0])).append("\" value=\"").append(pair.length > 1 ? this.recode(pair[1]) : "").append("\" />");
        }
    }

    private String recode(String s) {
        String un = UrlDecoder.QUERY_INSTANCE.decode(s, this.getRequest().getCharset());
        return ((Object)Strings.escapeMarkup((CharSequence)un)).toString();
    }

    @Override
    protected void onDetach() {
        this.setFlag(256, false);
        super.onDetach();
    }

    protected void onError() {
    }

    @Override
    protected void onBeforeRender() {
        this.multiPart = (short)(this.multiPart & 0xFFFFFFFD);
        super.onBeforeRender();
    }

    protected void onSubmit() {
    }

    protected final void updateFormComponentModels() {
        this.internalUpdateFormComponentModels();
        this.updateNestedFormComponentModels();
    }

    private final void updateNestedFormComponentModels() {
        this.visitChildren(Form.class, new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    ((Form)form).internalUpdateFormComponentModels();
                } else {
                    visit.dontGoDeeper();
                }
            }
        });
    }

    private void internalUpdateFormComponentModels() {
        FormComponent.visitComponentsPostOrder(this, new FormModelUpdateVisitor(this));
    }

    protected final void validate() {
        if (this.isEnabledInHierarchy() && this.isVisibleInHierarchy()) {
            this.validateNestedForms();
            this.validateComponents();
            this.validateFormValidators();
            this.onValidate();
        }
    }

    protected void onValidate() {
    }

    protected void onValidateModelObjects() {
    }

    protected final void validateComponents() {
        this.visitFormComponentsPostOrder(new ValidationVisitor(){

            @Override
            public void validate(FormComponent<?> formComponent) {
                Form<?> form = formComponent.getForm();
                if (form == Form.this && form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    formComponent.validate();
                }
            }
        });
    }

    private boolean isFormComponentVisibleInPage(FormComponent<?> fc) {
        if (fc == null) {
            throw new IllegalArgumentException("Argument `fc` cannot be null");
        }
        return fc.isVisibleInHierarchy();
    }

    protected final void validateFormValidator(IFormValidator validator) {
        Args.notNull((Object)validator, (String)"validator");
        FormComponent<?>[] dependents = validator.getDependentFormComponents();
        boolean validate = true;
        if (dependents != null) {
            for (FormComponent<?> dependent : dependents) {
                if (!dependent.isValid()) {
                    validate = false;
                    break;
                }
                if (this.isFormComponentVisibleInPage(dependent)) continue;
                if (log.isWarnEnabled()) {
                    log.warn("IFormValidator in form `" + this.getPageRelativePath() + "` depends on a component that has been removed from the page or is no longer visible. " + "Offending component id `" + dependent.getId() + "`.");
                }
                validate = false;
                break;
            }
        }
        if (validate) {
            validator.validate(this);
        }
    }

    protected final void validateFormValidators() {
        for (Behavior behavior : this.getBehaviors()) {
            if (!(behavior instanceof IFormValidator)) continue;
            this.validateFormValidator((IFormValidator)((Object)behavior));
        }
    }

    private void validateNestedForms() {
        Visits.visitPostOrder((Object)this, (IVisitor)new IVisitor<Form<?>, Void>(){

            public void component(Form<?> form, IVisit<Void> visit) {
                if (form == Form.this) {
                    visit.stop();
                    return;
                }
                if (form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    form.validateComponents();
                    form.validateFormValidators();
                    form.onValidate();
                }
            }
        }, (IVisitFilter)new ClassVisitFilter(Form.class));
    }

    protected String getInputNamePrefix() {
        return "";
    }

    public final IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public final void setModel(IModel<T> model) {
        this.setDefaultModel((IModel)model);
    }

    public final T getModelObject() {
        return (T)this.getDefaultModelObject();
    }

    public final void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }

    public static Form<?> findForm(Component component) {
        return component.findParent(Form.class);
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        if (!this.isRootForm() && this.isMultiPart()) {
            this.registerJavaScriptNamespaces(response);
            response.renderJavaScript("Wicket.Forms[\"" + this.getMarkupId() + "\"]={multipart:true};", Form.class.getName() + '.' + this.getMarkupId() + ".metadata");
        }
    }

    protected void registerJavaScriptNamespaces(IHeaderResponse response) {
        response.renderJavaScript("if (typeof(Wicket)=='undefined') { Wicket={}; } if (typeof(Wicket.Forms)=='undefined') { Wicket.Forms={}; }", Form.class.getName());
    }

    public static String getRootFormRelativeId(Component component) {
        String id = component.getId();
        PrependingStringBuffer inputName = new PrependingStringBuffer(id.length());
        Component c = component;
        while (true) {
            inputName.prepend(id);
            c = c.getParent();
            if (c == null || c instanceof Form && ((Form)c).isRootForm() || c instanceof Page) break;
            inputName.prepend(':');
            id = c.getId();
        }
        if ("submit".equals(inputName.toString())) {
            inputName.prepend(':');
        }
        return inputName.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodMismatchResponse {
        CONTINUE,
        ABORT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FormModelUpdateVisitor
    implements IVisitor<Component, Void> {
        private final Form<?> formFilter;

        public FormModelUpdateVisitor(Form<?> formFilter) {
            this.formFilter = formFilter;
        }

        public void component(Component component, IVisit<Void> visit) {
            Form<?> form;
            if (component instanceof IFormModelUpdateListener && (form = Form.findForm(component)) != null && (this.formFilter == null || this.formFilter == form) && form.isEnabledInHierarchy() && component.isVisibleInHierarchy() && component.isEnabledInHierarchy()) {
                ((IFormModelUpdateListener)((Object)component)).updateModel();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ValidationVisitor
    implements IVisitor<FormComponent<?>, Void> {
        public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
            Form<?> form = formComponent.getForm();
            if (!form.isVisibleInHierarchy() || !form.isEnabledInHierarchy()) {
                visit.dontGoDeeper();
                return;
            }
            if (formComponent.isVisibleInHierarchy() && formComponent.isValid() && formComponent.isEnabledInHierarchy()) {
                this.validate(formComponent);
            }
            if (!formComponent.processChildren()) {
                visit.dontGoDeeper();
            }
        }

        public abstract void validate(FormComponent<?> var1);
    }
}

