/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageResourceGuard
implements IPackageResourceGuard {
    private static final Logger log = LoggerFactory.getLogger(PackageResourceGuard.class);
    private Set<String> blockedExtensions = new HashSet<String>(4);
    private Set<String> blockedFiles = new HashSet<String>(4);
    private boolean allowAccessToWebInfResources = false;

    public PackageResourceGuard() {
        this.blockedExtensions.add("properties");
        this.blockedExtensions.add("class");
        this.blockedExtensions.add("java");
        this.blockedFiles.add("applicationContext.xml");
        this.blockedFiles.add("log4j.xml");
    }

    @Override
    public boolean accept(Class<?> scope, String path) {
        String absolutePath = Packages.absolutePath(scope, (String)path);
        return this.acceptAbsolutePath(absolutePath);
    }

    protected boolean acceptAbsolutePath(String path) {
        int ixExtension = path.lastIndexOf(46);
        int len = path.length();
        String ext = ixExtension <= 0 || ixExtension == len || path.lastIndexOf(47) + 1 == ixExtension ? null : path.substring(ixExtension + 1).toLowerCase();
        if ("html".equals(ext) && this.getClass().getClassLoader().getResource(path.replaceAll("\\.html", ".class")) != null) {
            log.warn("Access denied to shared (static) resource because it is a Wicket markup file: " + path);
            return false;
        }
        if (!this.acceptExtension(ext)) {
            log.warn("Access denied to shared (static) resource because of the file extension: " + path);
            return false;
        }
        String filename = Strings.lastPathComponent((String)path, (char)'/');
        if (!this.acceptFile(filename)) {
            log.warn("Access denied to shared (static) resource because of the file name: " + path);
            return false;
        }
        if (Strings.isEmpty((CharSequence)Application.get().getResourceSettings().getParentFolderPlaceholder()) && path.contains("..")) {
            log.warn("Access to parent directories via '..' is by default disabled for shared resources: " + path);
            return false;
        }
        if (!this.allowAccessToWebInfResources) {
            String absolute = path;
            if (absolute.startsWith("/")) {
                absolute = absolute.substring(1);
            }
            if (!absolute.contains("/")) {
                log.warn("Access to web-inf directory via '..' is by default disabled for shared resources: " + path);
                return false;
            }
        }
        return true;
    }

    protected boolean acceptExtension(String extension) {
        return !this.blockedExtensions.contains(extension);
    }

    protected boolean acceptFile(String file) {
        return !this.blockedFiles.contains(file);
    }

    protected final Set<String> getBlockedExtensions() {
        return this.blockedExtensions;
    }

    protected final Set<String> getBlockedFiles() {
        return this.blockedFiles;
    }

    protected final void setBlockedExtensions(Set<String> blockedExtensions) {
        this.blockedExtensions = blockedExtensions;
    }

    protected final void setBlockedFiles(Set<String> blockedFiles) {
        this.blockedFiles = blockedFiles;
    }

    public final boolean isAllowAccessToWebInfResources() {
        return this.allowAccessToWebInfResources;
    }

    public final void setAllowAccessToWebInfResources(boolean allowAccessToRootResources) {
        this.allowAccessToWebInfResources = allowAccessToRootResources;
    }
}

