/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.application;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassResolver
implements IClassResolver {
    private final ConcurrentMap<String, WeakReference<Class<?>>> classes = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class<?> resolveClass(String className) throws ClassNotFoundException {
        Class<Comparable<Byte>> clazz = null;
        WeakReference ref = (WeakReference)this.classes.get(className);
        if (ref != null) {
            clazz = (Class<Byte>)ref.get();
        }
        if (clazz == null) {
            if (className.equals("byte")) {
                clazz = Byte.TYPE;
            } else if (className.equals("short")) {
                clazz = Short.TYPE;
            } else if (className.equals("int")) {
                clazz = Integer.TYPE;
            } else if (className.equals("long")) {
                clazz = Long.TYPE;
            } else if (className.equals("float")) {
                clazz = Float.TYPE;
            } else if (className.equals("double")) {
                clazz = Double.TYPE;
            } else if (className.equals("boolean")) {
                clazz = Boolean.TYPE;
            } else if (className.equals("char")) {
                clazz = Character.TYPE;
            } else {
                ConcurrentMap<String, WeakReference<Class<?>>> concurrentMap = this.classes;
                synchronized (concurrentMap) {
                    clazz = Class.forName(className, false, this.getClassLoader());
                    if (clazz == null) {
                        throw new ClassNotFoundException(className);
                    }
                }
                this.classes.put(className, new WeakReference<Class<Byte>>(clazz));
            }
        }
        return clazz;
    }

    protected abstract ClassLoader getClassLoader();

    @Override
    public Iterator<URL> getResources(String name) {
        ArrayList<URL> resultList = new ArrayList<URL>();
        HashSet<URI> loadedFiles = new HashSet<URI>();
        try {
            Enumeration<URL> resources = Application.class.getClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
            resources = Application.get().getClass().getClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
            resources = this.getClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
            for (URI uri : loadedFiles) {
                resultList.add(uri.toURL());
            }
        }
        catch (Exception e) {
            throw new WicketRuntimeException(e);
        }
        return resultList.iterator();
    }

    private void loadResources(Enumeration<URL> resources, Set<URI> loadedFiles) throws URISyntaxException {
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                URI uri = url.toURI();
                if (loadedFiles.contains(uri)) continue;
                loadedFiles.add(uri);
            }
        }
    }
}

