/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.internal.HeaderResponse;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.IPageRequestHandler;
import org.apache.wicket.request.handler.PageProvider;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.handler.logger.PageLogData;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxRequestTarget
implements IPageRequestHandler,
ILoggableRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(AjaxRequestTarget.class);
    private final List<CharSequence> appendJavaScripts = Generics.newArrayList();
    private final List<CharSequence> domReadyJavaScripts = Generics.newArrayList();
    private final AjaxResponse encodingBodyResponse;
    private final AjaxResponse encodingHeaderResponse;
    private final Map<String, Component> markupIdToComponent = new LinkedHashMap<String, Component>();
    private final List<CharSequence> prependJavaScripts = Generics.newArrayList();
    private List<IListener> listeners = null;
    private final Set<ITargetRespondListener> respondListeners = new HashSet<ITargetRespondListener>();
    private final Page page;
    private transient boolean componentsFrozen;
    private transient boolean listenersFrozen;
    private transient boolean respondersFrozen;
    private PageLogData logData;
    private boolean headerRendering = false;
    private HtmlHeaderContainer header = null;
    private IHeaderResponse headerResponse;

    public AjaxRequestTarget(Page page) {
        Args.notNull((Object)page, (String)"page");
        this.page = page;
        Response response = RequestCycle.get().getResponse();
        this.encodingBodyResponse = new AjaxResponse(response);
        this.encodingHeaderResponse = new AjaxResponse(response);
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    private void assertNotFrozen(boolean frozen, Class<?> clazz) {
        if (frozen) {
            throw new IllegalStateException(clazz.getSimpleName() + "s can no " + " longer be added");
        }
    }

    private void assertListenersNotFrozen() {
        this.assertNotFrozen(this.listenersFrozen, IListener.class);
    }

    private void assertComponentsNotFrozen() {
        this.assertNotFrozen(this.componentsFrozen, Component.class);
    }

    private void assertRespondersNotFrozen() {
        this.assertNotFrozen(this.respondersFrozen, ITargetRespondListener.class);
    }

    public void addListener(IListener listener) throws IllegalStateException {
        Args.notNull((Object)listener, (String)"listener");
        this.assertListenersNotFrozen();
        if (this.listeners == null) {
            this.listeners = new LinkedList<IListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void addChildren(MarkupContainer parent, Class<?> childCriteria) {
        Args.notNull((Object)parent, (String)"parent");
        Args.notNull(childCriteria, (String)"childCriteria");
        parent.visitChildren(childCriteria, new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                AjaxRequestTarget.this.add(component);
                visit.dontGoDeeper();
            }
        });
    }

    @Deprecated
    public void addComponent(Component ... components) {
        this.add(components);
    }

    public void add(Component ... components) {
        for (Component component : components) {
            Args.notNull((Object)component, (String)"component");
            if (!component.getOutputMarkupId()) {
                throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
            }
            this.add(component, component.getMarkupId());
        }
    }

    @Deprecated
    public final void addComponent(Component component, String markupId) {
        this.add(component, markupId);
    }

    public final void add(Component component, String markupId) throws IllegalArgumentException, IllegalStateException {
        Args.notEmpty((CharSequence)markupId, (String)"markupId");
        Args.notNull((Object)component, (String)"component");
        if (component instanceof Page) {
            if (component != this.page) {
                throw new IllegalArgumentException("component cannot be a page");
            }
        } else if (component instanceof AbstractRepeater) {
            throw new IllegalArgumentException("Component " + component.getClass().getName() + " has been added to the target. This component is a repeater and cannot be repainted via ajax directly. " + "Instead add its parent or another markup container higher in the hierarchy.");
        }
        this.assertComponentsNotFrozen();
        component.setMarkupId(markupId);
        this.markupIdToComponent.put(markupId, component);
    }

    public final Collection<? extends Component> getComponents() {
        return Collections.unmodifiableCollection(this.markupIdToComponent.values());
    }

    public final void focusComponent(Component component) {
        if (component != null && !component.getOutputMarkupId()) {
            throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
        }
        String id = component != null ? "'" + component.getMarkupId() + "'" : "null";
        this.appendJavaScript("Wicket.Focus.setFocusOnId(" + id + ");");
    }

    public final void appendJavaScript(CharSequence javascript) {
        Args.notNull((Object)javascript, (String)"javascript");
        this.appendJavaScripts.add(javascript);
    }

    public void detach(IRequestCycle requestCycle) {
        Component component;
        Page page;
        if (this.logData == null) {
            this.logData = new PageLogData(this.page);
        }
        if (this.markupIdToComponent.size() > 0 && (page = (component = this.markupIdToComponent.values().iterator().next()).findParent(Page.class)) != null) {
            page.detach();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AjaxRequestTarget) {
            AjaxRequestTarget that = (AjaxRequestTarget)obj;
            return ((Object)this.markupIdToComponent).equals(that.markupIdToComponent) && ((Object)this.prependJavaScripts).equals(that.prependJavaScripts) && ((Object)this.appendJavaScripts).equals(that.appendJavaScripts);
        }
        return false;
    }

    public int hashCode() {
        int result = "AjaxRequestTarget".hashCode();
        result += ((Object)this.markupIdToComponent).hashCode() * 17;
        result += ((Object)this.prependJavaScripts).hashCode() * 17;
        return result += ((Object)this.appendJavaScripts).hashCode() * 17;
    }

    public final void prependJavaScript(CharSequence javascript) {
        Args.notNull((Object)javascript, (String)"javascript");
        this.prependJavaScripts.add(javascript);
    }

    public void registerRespondListener(ITargetRespondListener listener) {
        this.assertRespondersNotFrozen();
        this.respondListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void respond(IRequestCycle requestCycle) {
        RequestCycle rc = (RequestCycle)requestCycle;
        WebResponse response = (WebResponse)requestCycle.getResponse();
        if (this.markupIdToComponent.values().contains(this.page)) {
            RenderPageRequestHandler handler = new RenderPageRequestHandler(new PageProvider(this.page));
            String url = ((Object)rc.urlFor(handler)).toString();
            response.sendRedirect(url);
            return;
        }
        this.respondersFrozen = true;
        for (ITargetRespondListener listener : this.respondListeners) {
            listener.onTargetRespond(this);
        }
        Application app = Application.get();
        this.page.send(app, Broadcast.BREADTH, this);
        String encoding = app.getRequestCycleSettings().getResponseRequestEncoding();
        response.setContentType("text/xml; charset=" + encoding);
        response.disableCaching();
        try {
            StringResponse bodyResponse = new StringResponse();
            this.constructResponseBody(bodyResponse, encoding);
            AppendingStringBuffer filteredResponse = this.invokeResponseFilters(bodyResponse);
            response.write((CharSequence)filteredResponse);
        }
        finally {
            RequestCycle.get().setResponse((Response)response);
        }
    }

    private void constructResponseBody(Response bodyResponse, String encoding) {
        bodyResponse.write((CharSequence)"<?xml version=\"1.0\" encoding=\"");
        bodyResponse.write((CharSequence)encoding);
        bodyResponse.write((CharSequence)"\"?>");
        bodyResponse.write((CharSequence)"<ajax-response>");
        this.fireOnBeforeRespondListeners();
        for (CharSequence js : this.prependJavaScripts) {
            this.respondInvocation(bodyResponse, js);
        }
        this.respondComponents(bodyResponse);
        this.fireOnAfterRespondListeners(bodyResponse);
        for (CharSequence js : this.domReadyJavaScripts) {
            this.respondInvocation(bodyResponse, js);
        }
        for (CharSequence js : this.appendJavaScripts) {
            this.respondInvocation(bodyResponse, js);
        }
        bodyResponse.write((CharSequence)"</ajax-response>");
    }

    private AppendingStringBuffer invokeResponseFilters(StringResponse contentResponse) {
        AppendingStringBuffer responseBuffer = new AppendingStringBuffer(contentResponse.getBuffer());
        List<IResponseFilter> responseFilters = Application.get().getRequestCycleSettings().getResponseFilters();
        if (responseFilters != null) {
            for (IResponseFilter filter : responseFilters) {
                responseBuffer = filter.filter(responseBuffer);
            }
        }
        return responseBuffer;
    }

    private void fireOnBeforeRespondListeners() {
        this.listenersFrozen = true;
        if (this.listeners != null) {
            Map<String, Component> components = Collections.unmodifiableMap(this.markupIdToComponent);
            for (IListener listener : this.listeners) {
                listener.onBeforeRespond(components, this);
            }
        }
        this.listenersFrozen = false;
    }

    private void fireOnAfterRespondListeners(final Response response) {
        this.listenersFrozen = true;
        if (this.listeners != null) {
            Map<String, Component> components = Collections.unmodifiableMap(this.markupIdToComponent);
            IJavaScriptResponse jsresponse = new IJavaScriptResponse(){

                public void addJavaScript(String script) {
                    AjaxRequestTarget.this.respondInvocation(response, script);
                }
            };
            for (IListener listener : this.listeners) {
                listener.onAfterRespond(components, jsresponse);
            }
        }
    }

    private void respondComponents(Response response) {
        this.componentsFrozen = true;
        for (Map.Entry<String, Component> stringComponentEntry : this.markupIdToComponent.entrySet()) {
            Component component = stringComponentEntry.getValue();
            if (this.containsAncestorFor(component)) continue;
            this.respondComponent(response, component.getAjaxRegionMarkupId(), component);
        }
        if (this.header != null) {
            this.headerRendering = true;
            Response oldResponse = RequestCycle.get().setResponse(this.encodingHeaderResponse);
            this.encodingHeaderResponse.reset();
            this.header.getHeaderResponse().close();
            RequestCycle.get().setResponse(oldResponse);
            this.writeHeaderContribution(response);
            this.headerRendering = false;
        }
    }

    private void writeHeaderContribution(Response response) {
        if (this.encodingHeaderResponse.getContents().length() != 0) {
            response.write((CharSequence)"<header-contribution");
            if (this.encodingHeaderResponse.isContentsEncoded()) {
                response.write((CharSequence)" encoding=\"");
                response.write((CharSequence)this.getEncodingName());
                response.write((CharSequence)"\" ");
            }
            response.write((CharSequence)"><![CDATA[<head xmlns:wicket=\"http://wicket.apache.org\">");
            response.write(this.encodingHeaderResponse.getContents());
            response.write((CharSequence)"</head>]]>");
            response.write((CharSequence)"</header-contribution>");
        }
    }

    private boolean containsAncestorFor(Component component) {
        for (MarkupContainer cursor = component.getParent(); cursor != null; cursor = cursor.getParent()) {
            if (!this.markupIdToComponent.containsValue(cursor)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[AjaxRequestTarget@" + this.hashCode() + " markupIdToComponent [" + this.markupIdToComponent + "], prependJavaScript [" + this.prependJavaScripts + "], appendJavaScript [" + this.appendJavaScripts + "]";
    }

    protected String encode(CharSequence str) {
        if (str == null) {
            return null;
        }
        return ((Object)Strings.replaceAll((CharSequence)str, (CharSequence)"]", (CharSequence)"]^")).toString();
    }

    protected String getEncodingName() {
        return "wicket1";
    }

    protected boolean needsEncoding(CharSequence str) {
        return Strings.indexOf((CharSequence)str, (char)']') >= 0;
    }

    private void respondComponent(Response response, String markupId, Component component) {
        if (component.getRenderBodyOnly()) {
            throw new IllegalStateException("Ajax render cannot be called on component that has setRenderBodyOnly enabled. Component: " + component.toString());
        }
        component.setOutputMarkupId(true);
        this.encodingBodyResponse.reset();
        RequestCycle.get().setResponse(this.encodingBodyResponse);
        Page page = component.findParent(Page.class);
        if (page == null) {
            log.debug("component: " + component + " with markupid: " + markupId + " not rendered because it was already removed from page");
            return;
        }
        page.startComponentRender(component);
        try {
            component.prepareForRender();
            this.respondHeaderContribution(response, component);
        }
        catch (RuntimeException e) {
            try {
                component.afterRender();
            }
            catch (RuntimeException e2) {
                // empty catch block
            }
            RequestCycle.get().setResponse(response);
            this.encodingBodyResponse.reset();
            throw e;
        }
        try {
            component.render();
        }
        catch (RuntimeException e) {
            RequestCycle.get().setResponse(response);
            this.encodingBodyResponse.reset();
            throw e;
        }
        page.endComponentRender(component);
        RequestCycle.get().setResponse(response);
        response.write((CharSequence)"<component id=\"");
        response.write((CharSequence)markupId);
        response.write((CharSequence)"\" ");
        if (this.encodingBodyResponse.isContentsEncoded()) {
            response.write((CharSequence)" encoding=\"");
            response.write((CharSequence)this.getEncodingName());
            response.write((CharSequence)"\" ");
        }
        response.write((CharSequence)"><![CDATA[");
        response.write(this.encodingBodyResponse.getContents());
        response.write((CharSequence)"]]></component>");
        this.encodingBodyResponse.reset();
    }

    public IHeaderResponse getHeaderResponse() {
        if (this.headerResponse == null) {
            this.headerResponse = new AjaxHeaderResponse();
        }
        return this.headerResponse;
    }

    private void respondHeaderContribution(Response response, Component component) {
        this.headerRendering = true;
        if (this.header == null) {
            this.header = new AjaxHtmlHeaderContainer("_header_", this);
            Page page = component.getPage();
            page.addOrReplace(this.header);
        }
        Response oldResponse = RequestCycle.get().setResponse(this.encodingHeaderResponse);
        this.encodingHeaderResponse.reset();
        component.renderHead(this.header);
        if (component instanceof MarkupContainer) {
            ((MarkupContainer)component).visitChildren(new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    if (component.isVisibleInHierarchy()) {
                        component.renderHead(AjaxRequestTarget.this.header);
                    } else {
                        visit.dontGoDeeper();
                    }
                }
            });
        }
        RequestCycle.get().setResponse(oldResponse);
        this.writeHeaderContribution(response);
        this.headerRendering = false;
    }

    private void respondInvocation(Response response, CharSequence js) {
        boolean encoded = false;
        CharSequence javascript = js;
        if (this.needsEncoding(js)) {
            encoded = true;
            javascript = this.encode(js);
        }
        response.write((CharSequence)"<evaluate");
        if (encoded) {
            response.write((CharSequence)" encoding=\"");
            response.write((CharSequence)this.getEncodingName());
            response.write((CharSequence)"\"");
        }
        response.write((CharSequence)">");
        response.write((CharSequence)"<![CDATA[");
        response.write(javascript);
        response.write((CharSequence)"]]>");
        response.write((CharSequence)"</evaluate>");
        this.encodingBodyResponse.reset();
    }

    public static AjaxRequestTarget get() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle != null) {
            if (requestCycle.getActiveRequestHandler() instanceof AjaxRequestTarget) {
                return (AjaxRequestTarget)requestCycle.getActiveRequestHandler();
            }
            if (requestCycle.getRequestHandlerScheduledAfterCurrent() instanceof AjaxRequestTarget) {
                return (AjaxRequestTarget)requestCycle.getRequestHandlerScheduledAfterCurrent();
            }
        }
        return null;
    }

    public String getLastFocusedElementId() {
        WebRequest request = (WebRequest)RequestCycle.get().getRequest();
        String id = request.getHeader("Wicket-FocusedElementId");
        return Strings.isEmpty((CharSequence)id) ? null : id;
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.page.getPageClass();
    }

    @Override
    public Integer getPageId() {
        return this.page.getPageId();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.page.getPageParameters();
    }

    @Override
    public final boolean isPageInstanceCreated() {
        return true;
    }

    @Override
    public final Integer getRenderCount() {
        return this.page.getRenderCount();
    }

    public PageLogData getLogData() {
        return this.logData;
    }

    private static class AjaxHtmlHeaderContainer
    extends HtmlHeaderContainer {
        private static final long serialVersionUID = 1L;
        private final transient AjaxRequestTarget target;

        public AjaxHtmlHeaderContainer(String id, AjaxRequestTarget target) {
            super(id);
            this.target = target;
        }

        protected IHeaderResponse newHeaderResponse() {
            return this.target.getHeaderResponse();
        }
    }

    private class AjaxHeaderResponse
    extends HeaderResponse {
        private boolean checkHeaderRendering() {
            if (!AjaxRequestTarget.this.headerRendering) {
                log.debug("Only methods that can be called on IHeaderResponse outside renderHead() are renderOnLoadJavaScript and renderOnDomReadyJavaScript");
            }
            return AjaxRequestTarget.this.headerRendering;
        }

        public void renderCSSReference(ResourceReference reference, String media) {
            if (this.checkHeaderRendering()) {
                super.renderCSSReference(reference, media);
            }
        }

        public void renderCSSReference(String url) {
            if (this.checkHeaderRendering()) {
                super.renderCSSReference(url);
            }
        }

        public void renderCSSReference(String url, String media) {
            if (this.checkHeaderRendering()) {
                super.renderCSSReference(url, media);
            }
        }

        public void renderJavaScript(CharSequence javascript, String id) {
            if (this.checkHeaderRendering()) {
                super.renderJavaScript(javascript, id);
            }
        }

        public void renderCSSReference(ResourceReference reference) {
            if (this.checkHeaderRendering()) {
                super.renderCSSReference(reference);
            }
        }

        public void renderJavaScriptReference(ResourceReference reference) {
            if (this.checkHeaderRendering()) {
                super.renderJavaScriptReference(reference);
            }
        }

        public void renderJavaScriptReference(ResourceReference reference, String id) {
            if (this.checkHeaderRendering()) {
                super.renderJavaScriptReference(reference, id);
            }
        }

        public void renderJavaScriptReference(String url) {
            if (this.checkHeaderRendering()) {
                super.renderJavaScriptReference(url);
            }
        }

        public void renderJavaScriptReference(String url, String id) {
            if (this.checkHeaderRendering()) {
                super.renderJavaScriptReference(url, id);
            }
        }

        public void renderString(CharSequence string) {
            if (this.checkHeaderRendering()) {
                super.renderString(string);
            }
        }

        public void renderOnDomReadyJavaScript(String javascript) {
            List<String> token = Arrays.asList("javascript-event", "window", "domready", javascript);
            if (!this.wasRendered(token)) {
                AjaxRequestTarget.this.domReadyJavaScripts.add(javascript);
                this.markRendered(token);
            }
        }

        public void renderOnLoadJavaScript(String javascript) {
            List<String> token = Arrays.asList("javascript-event", "window", "load", javascript);
            if (!this.wasRendered(token)) {
                AjaxRequestTarget.this.appendJavaScripts.add(javascript);
                this.markRendered(token);
            }
        }

        protected Response getRealResponse() {
            return RequestCycle.get().getResponse();
        }
    }

    public static interface ITargetRespondListener {
        public void onTargetRespond(AjaxRequestTarget var1);
    }

    private final class AjaxResponse
    extends Response {
        private final AppendingStringBuffer buffer = new AppendingStringBuffer(256);
        private boolean escaped = false;
        private final Response originalResponse;

        public AjaxResponse(Response originalResponse) {
            this.originalResponse = originalResponse;
        }

        public String encodeURL(CharSequence url) {
            return this.originalResponse.encodeURL(url);
        }

        public CharSequence getContents() {
            return this.buffer;
        }

        public boolean isContentsEncoded() {
            return this.escaped;
        }

        public void write(CharSequence cs) {
            String string = ((Object)cs).toString();
            if (AjaxRequestTarget.this.needsEncoding(string)) {
                string = AjaxRequestTarget.this.encode(string);
                this.escaped = true;
                this.buffer.append(string);
            } else {
                this.buffer.append((Object)cs);
            }
        }

        public void reset() {
            this.buffer.clear();
            this.escaped = false;
        }

        public void write(byte[] array) {
            throw new UnsupportedOperationException("Cannot write binary data.");
        }

        public void write(byte[] array, int offset, int length) {
            throw new UnsupportedOperationException("Cannot write binary data.");
        }

        public Object getContainerResponse() {
            return this.originalResponse.getContainerResponse();
        }
    }

    public static interface IJavaScriptResponse {
        public void addJavaScript(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IListener {
        public void onBeforeRespond(Map<String, Component> var1, AjaxRequestTarget var2);

        public void onAfterRespond(Map<String, Component> var1, IJavaScriptResponse var2);
    }
}

