/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.xmlquery.translator;

import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IDataSink;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import edu.uci.ics.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.vxquery.compiler.CompilerControlBlock;
import org.apache.vxquery.compiler.algebricks.VXQueryConstantValue;
import org.apache.vxquery.context.StaticContext;
import org.apache.vxquery.context.StaticContextImpl;
import org.apache.vxquery.context.ThinStaticContextImpl;
import org.apache.vxquery.context.XQueryVariable;
import org.apache.vxquery.datamodel.builders.atomic.StringValueBuilder;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.functions.BuiltinFunctions;
import org.apache.vxquery.functions.BuiltinOperators;
import org.apache.vxquery.functions.ExternalFunction;
import org.apache.vxquery.functions.Function;
import org.apache.vxquery.functions.Operator;
import org.apache.vxquery.functions.Signature;
import org.apache.vxquery.functions.UserDefinedXQueryFunction;
import org.apache.vxquery.metadata.QueryResultSetDataSink;
import org.apache.vxquery.runtime.functions.cast.CastToDecimalOperation;
import org.apache.vxquery.types.AnyItemType;
import org.apache.vxquery.types.AnyNodeType;
import org.apache.vxquery.types.AnyType;
import org.apache.vxquery.types.AtomicType;
import org.apache.vxquery.types.AttributeType;
import org.apache.vxquery.types.BuiltinTypeRegistry;
import org.apache.vxquery.types.CommentType;
import org.apache.vxquery.types.DocumentType;
import org.apache.vxquery.types.ElementType;
import org.apache.vxquery.types.EmptySequenceType;
import org.apache.vxquery.types.ItemType;
import org.apache.vxquery.types.NameTest;
import org.apache.vxquery.types.NodeType;
import org.apache.vxquery.types.ProcessingInstructionType;
import org.apache.vxquery.types.Quantifier;
import org.apache.vxquery.types.SchemaType;
import org.apache.vxquery.types.SequenceType;
import org.apache.vxquery.types.TextType;
import org.apache.vxquery.types.TypeUtils;
import org.apache.vxquery.xmlquery.ast.ASTNode;
import org.apache.vxquery.xmlquery.ast.ASTTag;
import org.apache.vxquery.xmlquery.ast.AtomicTypeNode;
import org.apache.vxquery.xmlquery.ast.AttributeTestNode;
import org.apache.vxquery.xmlquery.ast.AxisStepNode;
import org.apache.vxquery.xmlquery.ast.BaseUriDeclNode;
import org.apache.vxquery.xmlquery.ast.BoundarySpaceDeclNode;
import org.apache.vxquery.xmlquery.ast.CDataSectionNode;
import org.apache.vxquery.xmlquery.ast.ComputedAttributeConstructorNode;
import org.apache.vxquery.xmlquery.ast.ComputedCommentConstructorNode;
import org.apache.vxquery.xmlquery.ast.ComputedDocumentConstructorNode;
import org.apache.vxquery.xmlquery.ast.ComputedElementConstructorNode;
import org.apache.vxquery.xmlquery.ast.ComputedPIConstructorNode;
import org.apache.vxquery.xmlquery.ast.ComputedTextConstructorNode;
import org.apache.vxquery.xmlquery.ast.ConstructionDeclNode;
import org.apache.vxquery.xmlquery.ast.ContentCharsNode;
import org.apache.vxquery.xmlquery.ast.CopyNamespacesDeclNode;
import org.apache.vxquery.xmlquery.ast.DefaultCollationDeclNode;
import org.apache.vxquery.xmlquery.ast.DefaultElementNamespaceDeclNode;
import org.apache.vxquery.xmlquery.ast.DefaultFunctionNamespaceDeclNode;
import org.apache.vxquery.xmlquery.ast.DirectAttributeConstructorNode;
import org.apache.vxquery.xmlquery.ast.DirectCommentConstructorNode;
import org.apache.vxquery.xmlquery.ast.DirectElementConstructorNode;
import org.apache.vxquery.xmlquery.ast.DirectPIConstructorNode;
import org.apache.vxquery.xmlquery.ast.DocumentTestNode;
import org.apache.vxquery.xmlquery.ast.ElementTestNode;
import org.apache.vxquery.xmlquery.ast.EmptyOrderDeclNode;
import org.apache.vxquery.xmlquery.ast.EnclosedExprNode;
import org.apache.vxquery.xmlquery.ast.ExprNode;
import org.apache.vxquery.xmlquery.ast.ExtensionExprNode;
import org.apache.vxquery.xmlquery.ast.FLWORClauseNode;
import org.apache.vxquery.xmlquery.ast.FLWORExprNode;
import org.apache.vxquery.xmlquery.ast.FilterExprNode;
import org.apache.vxquery.xmlquery.ast.ForClauseNode;
import org.apache.vxquery.xmlquery.ast.ForVarDeclNode;
import org.apache.vxquery.xmlquery.ast.FunctionDeclNode;
import org.apache.vxquery.xmlquery.ast.FunctionExprNode;
import org.apache.vxquery.xmlquery.ast.IfExprNode;
import org.apache.vxquery.xmlquery.ast.InfixExprNode;
import org.apache.vxquery.xmlquery.ast.LetClauseNode;
import org.apache.vxquery.xmlquery.ast.LetVarDeclNode;
import org.apache.vxquery.xmlquery.ast.LibraryModuleNode;
import org.apache.vxquery.xmlquery.ast.LiteralNode;
import org.apache.vxquery.xmlquery.ast.MainModuleNode;
import org.apache.vxquery.xmlquery.ast.ModuleImportNode;
import org.apache.vxquery.xmlquery.ast.ModuleNode;
import org.apache.vxquery.xmlquery.ast.NCNameNode;
import org.apache.vxquery.xmlquery.ast.NameTestNode;
import org.apache.vxquery.xmlquery.ast.NamespaceDeclNode;
import org.apache.vxquery.xmlquery.ast.OptionDeclNode;
import org.apache.vxquery.xmlquery.ast.OrderSpecNode;
import org.apache.vxquery.xmlquery.ast.OrderbyClauseNode;
import org.apache.vxquery.xmlquery.ast.OrderedExprNode;
import org.apache.vxquery.xmlquery.ast.OrderingModeDeclNode;
import org.apache.vxquery.xmlquery.ast.PITestNode;
import org.apache.vxquery.xmlquery.ast.ParamNode;
import org.apache.vxquery.xmlquery.ast.ParenthesizedExprNode;
import org.apache.vxquery.xmlquery.ast.PathExprNode;
import org.apache.vxquery.xmlquery.ast.PrologNode;
import org.apache.vxquery.xmlquery.ast.QNameNode;
import org.apache.vxquery.xmlquery.ast.QuantifiedExprNode;
import org.apache.vxquery.xmlquery.ast.QuantifiedVarDeclNode;
import org.apache.vxquery.xmlquery.ast.QueryBodyNode;
import org.apache.vxquery.xmlquery.ast.RelativePathExprNode;
import org.apache.vxquery.xmlquery.ast.SchemaImportNode;
import org.apache.vxquery.xmlquery.ast.SequenceTypeNode;
import org.apache.vxquery.xmlquery.ast.SingleTypeNode;
import org.apache.vxquery.xmlquery.ast.TypeDeclNode;
import org.apache.vxquery.xmlquery.ast.TypeExprNode;
import org.apache.vxquery.xmlquery.ast.UnaryExprNode;
import org.apache.vxquery.xmlquery.ast.UnorderedExprNode;
import org.apache.vxquery.xmlquery.ast.ValidateExprNode;
import org.apache.vxquery.xmlquery.ast.VarDeclNode;
import org.apache.vxquery.xmlquery.ast.VarRefNode;
import org.apache.vxquery.xmlquery.ast.VersionDeclNode;
import org.apache.vxquery.xmlquery.ast.WhereClauseNode;
import org.apache.vxquery.xmlquery.query.Module;
import org.apache.vxquery.xmlquery.query.ModuleType;
import org.apache.vxquery.xmlquery.query.XMLQueryCompilerConstants;
import org.apache.vxquery.xmlquery.query.XQueryConstants;

public class XMLQueryTranslator {
    private static final Pattern UNQUOTER = Pattern.compile("(&lt;)|(&gt;)|(&apos;)|(&amp;)|(&quot;)|(\"\")|('')|(&#\\d+;)|(&#x(?:[A-Fa-f0-9])+;)");
    private final CompilerControlBlock ccb;
    private final StaticContext rootCtx;
    private StaticContext moduleCtx;
    private IVariableScope rootVarScope;
    private StaticContext currCtx;
    private int varCounter;
    private final ByteArrayAccessibleOutputStream baaos;
    private final DataOutput dOut;
    private final StringValueBuilder stringVB;

    public XMLQueryTranslator(CompilerControlBlock ccb) {
        this.ccb = ccb;
        this.varCounter = 0;
        this.rootCtx = ccb.getStaticContext();
        this.baaos = new ByteArrayAccessibleOutputStream();
        this.dOut = new DataOutputStream((OutputStream)this.baaos);
        this.stringVB = new StringValueBuilder();
    }

    private void pushContext() {
        this.currCtx = new ThinStaticContextImpl(this.currCtx);
    }

    private void popContext() {
        this.currCtx = this.currCtx.getParent();
    }

    public Module translateModule(ModuleNode moduleNode) throws SystemException {
        Module module = new Module();
        this.moduleCtx = new StaticContextImpl(this.rootCtx);
        this.moduleCtx.registerVariable(new XQueryVariable(XMLQueryCompilerConstants.DOT_VAR_NAME, SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_ONE), this.newLogicalVariable()));
        this.rootVarScope = new RootVariableScope();
        this.currCtx = this.moduleCtx;
        module.setModuleContext(this.moduleCtx);
        module.setCompilerControlBlock(this.ccb);
        VersionDeclNode ver = moduleNode.getVersion();
        if (ver != null && !"1.0".equals(ver.getVersion())) {
            throw new SystemException(ErrorCode.XQST0031, ver.getSourceLocation());
        }
        switch (moduleNode.getTag()) {
            case LIBRARY_MODULE: {
                module.setModuleType(ModuleType.LIBRARY);
                LibraryModuleNode lmNode = (LibraryModuleNode)moduleNode;
                String prefix = lmNode.getModuleDecl().getPrefix();
                String uri = XMLQueryTranslator.unquote(lmNode.getModuleDecl().getTargetNS());
                if (prefix != null) {
                    this.currCtx.registerNamespaceUri(prefix, uri);
                }
                module.setNamespaceUri(uri);
                break;
            }
            case MAIN_MODULE: {
                module.setModuleType(ModuleType.MAIN);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown module type: " + (Object)((Object)moduleNode.getTag()));
            }
        }
        PrologNode prologNode = moduleNode.getProlog();
        this.parsePrologPass1(prologNode);
        this.parsePrologPass2(prologNode);
        ILogicalPlan plan = null;
        switch (moduleNode.getTag()) {
            case LIBRARY_MODULE: {
                throw new SystemException(ErrorCode.TODO);
            }
            case MAIN_MODULE: {
                plan = this.translateMainModule((MainModuleNode)moduleNode);
            }
        }
        module.setBody(plan);
        return module;
    }

    private void parsePrologPass1(PrologNode prologNode) throws SystemException {
        if (prologNode != null) {
            List<ASTNode> decls = prologNode.getDecls();
            block17: for (ASTNode d : decls) {
                switch (d.getTag()) {
                    case DEFAULT_ELEMENT_NAMESPACE_DECLARATION: {
                        ASTNode node = (DefaultElementNamespaceDeclNode)d;
                        this.moduleCtx.setDefaultElementNamespaceUri(((DefaultElementNamespaceDeclNode)node).getUri());
                        continue block17;
                    }
                    case DEFAULT_FUNCTION_NAMESPACE_DECLARATION: {
                        ASTNode node = (DefaultFunctionNamespaceDeclNode)d;
                        this.moduleCtx.setDefaultFunctionNamespaceUri(((DefaultFunctionNamespaceDeclNode)node).getUri());
                        continue block17;
                    }
                    case BOUNDARY_SPACE_DECLARATION: {
                        ASTNode node = (BoundarySpaceDeclNode)d;
                        this.moduleCtx.setBoundarySpaceProperty(((BoundarySpaceDeclNode)node).getMode());
                        continue block17;
                    }
                    case DEFAULT_COLLATION_DECLARATION: {
                        ASTNode node = (DefaultCollationDeclNode)d;
                        this.moduleCtx.setDefaultCollation(((DefaultCollationDeclNode)node).getCollation());
                        continue block17;
                    }
                    case BASE_URI_DECLARATION: {
                        ASTNode node = (BaseUriDeclNode)d;
                        this.moduleCtx.setBaseUri(((BaseUriDeclNode)node).getUri());
                        continue block17;
                    }
                    case CONSTRUCTION_DECLARATION: {
                        ASTNode node = (ConstructionDeclNode)d;
                        this.moduleCtx.setConstructionModeProperty(((ConstructionDeclNode)node).getMode());
                        continue block17;
                    }
                    case ORDERING_MODE_DECLARATION: {
                        ASTNode node = (OrderingModeDeclNode)d;
                        this.moduleCtx.setOrderingModeProperty(((OrderingModeDeclNode)node).getMode());
                        continue block17;
                    }
                    case EMPTY_ORDER_DECLARATION: {
                        ASTNode node = (EmptyOrderDeclNode)d;
                        this.moduleCtx.setEmptyOrderProperty(((EmptyOrderDeclNode)node).getMode());
                        continue block17;
                    }
                    case COPY_NAMESPACES_DECLARATION: {
                        ASTNode node = (CopyNamespacesDeclNode)d;
                        this.moduleCtx.setCopyNamespacesModeProperty(((CopyNamespacesDeclNode)node).getMode());
                        continue block17;
                    }
                    case NAMESPACE_DECLARATION: {
                        ASTNode node = (NamespaceDeclNode)d;
                        this.moduleCtx.registerNamespaceUri(((NamespaceDeclNode)node).getPrefix(), XMLQueryTranslator.unquote(((NamespaceDeclNode)node).getUri()));
                        continue block17;
                    }
                    case SCHEMA_IMPORT: {
                        ASTNode node = (SchemaImportNode)d;
                        if (((SchemaImportNode)node).isDefaultElementNamespace()) {
                            this.moduleCtx.setDefaultElementNamespaceUri(((SchemaImportNode)node).getTargetNS());
                        }
                        if (((SchemaImportNode)node).getPrefix() != null) {
                            this.moduleCtx.registerNamespaceUri(((SchemaImportNode)node).getPrefix(), XMLQueryTranslator.unquote(((SchemaImportNode)node).getTargetNS()));
                        }
                        this.moduleCtx.registerSchemaImport(((SchemaImportNode)node).getTargetNS(), ((SchemaImportNode)node).getLocations());
                        continue block17;
                    }
                    case MODULE_IMPORT: {
                        ASTNode node = (ModuleImportNode)d;
                        if (((ModuleImportNode)node).getPrefix() != null) {
                            this.moduleCtx.registerNamespaceUri(((ModuleImportNode)node).getPrefix(), XMLQueryTranslator.unquote(((ModuleImportNode)node).getTargetNS()));
                        }
                        this.moduleCtx.registerModuleImport(((ModuleImportNode)node).getTargetNS(), ((ModuleImportNode)node).getLocations());
                        continue block17;
                    }
                    case VARIABLE_DECLARATION: {
                        ASTNode node = (VarDeclNode)d;
                        QName name = this.createQName(((VarDeclNode)node).getName());
                        SequenceType type = SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_STAR);
                        if (((VarDeclNode)node).getType() != null) {
                            type = this.createSequenceType(((VarDeclNode)node).getType());
                        }
                        LogicalVariable lVar = this.newLogicalVariable();
                        XQueryVariable var = new XQueryVariable(name, type, lVar);
                        this.moduleCtx.registerVariable(var);
                        continue block17;
                    }
                    case FUNCTION_DECLARATION: {
                        ASTNode node = (FunctionDeclNode)d;
                        boolean external = ((FunctionDeclNode)node).getBody() == null;
                        QName name = this.createQName(((FunctionDeclNode)node).getName(), this.moduleCtx.getDefaultFunctionNamespaceUri());
                        String uri = name.getNamespaceURI();
                        if ("http://www.w3.org/2005/xpath-functions".equals(uri) || "http://www.w3.org/2001/XMLSchema".equals(uri) || "http://www.w3.org/2001/XMLSchema-instance".equals(uri) || "http://www.w3.org/XML/1998/namespace".equals(uri)) {
                            throw new SystemException(ErrorCode.XQST0045, node.getSourceLocation());
                        }
                        SequenceType rType = SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_STAR);
                        if (((FunctionDeclNode)node).getReturnType() != null) {
                            rType = this.createSequenceType(((FunctionDeclNode)node).getReturnType());
                        }
                        Pair[] paramTypes = new Pair[((FunctionDeclNode)node).getParameters().size()];
                        for (int i = 0; i < paramTypes.length; ++i) {
                            ParamNode pNode = ((FunctionDeclNode)node).getParameters().get(i);
                            QName pName = this.createQName(pNode.getName());
                            SequenceType pType = SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_STAR);
                            if (pNode.getType() != null) {
                                pType = this.createSequenceType(pNode.getType());
                            }
                            paramTypes[i] = Pair.of((Object)pName, (Object)pType);
                        }
                        Signature sign = new Signature(rType, paramTypes);
                        Function f = external ? new ExternalFunction(name, sign) : new UserDefinedXQueryFunction(name, sign, null);
                        this.moduleCtx.registerFunction(f);
                        continue block17;
                    }
                    case OPTION_DECLARATION: {
                        ASTNode node = (OptionDeclNode)d;
                        QName name = this.createQName(((OptionDeclNode)node).getName());
                        this.moduleCtx.setOption(name, ((OptionDeclNode)node).getValue());
                        continue block17;
                    }
                }
                throw new IllegalStateException("Unknown node: " + (Object)((Object)d.getTag()));
            }
        }
    }

    private void parsePrologPass2(PrologNode prologNode) throws SystemException {
        if (prologNode != null) {
            List<ASTNode> decls = prologNode.getDecls();
            for (ASTNode d : decls) {
                switch (d.getTag()) {
                    case VARIABLE_DECLARATION: {
                        ASTNode node = (VarDeclNode)d;
                        break;
                    }
                    case FUNCTION_DECLARATION: {
                        boolean external;
                        ASTNode node = (FunctionDeclNode)d;
                        boolean bl = external = ((FunctionDeclNode)node).getBody() == null;
                        if (external) break;
                        QName name = this.createQName(((FunctionDeclNode)node).getName(), this.moduleCtx.getDefaultFunctionNamespaceUri());
                        int arity = ((FunctionDeclNode)node).getParameters().size();
                        UserDefinedXQueryFunction f = (UserDefinedXQueryFunction)this.moduleCtx.lookupFunction(name, arity);
                        Signature sign = f.getSignature();
                        TranslationContext tCtx = new TranslationContext(null, (ILogicalOperator)new EmptyTupleSourceOperator());
                        XQueryVariable[] params = new XQueryVariable[arity];
                        for (int i = 0; i < arity; ++i) {
                            XQueryVariable pVar;
                            ParamNode pNode = ((FunctionDeclNode)node).getParameters().get(i);
                            QName pName = this.createQName(pNode.getName());
                            SequenceType pType = SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_STAR);
                            if (pNode.getType() != null) {
                                pType = this.createSequenceType(pNode.getType());
                            }
                            params[i] = pVar = new XQueryVariable(pName, pType, this.newLogicalVariable());
                            tCtx.varScope.registerVariable(pVar);
                        }
                        f.setParameters(params);
                        LogicalVariable var = this.translateExpression(((FunctionDeclNode)node).getBody(), tCtx);
                        ILogicalExpression expr = this.treat(XMLQueryTranslator.vre(var), sign.getReturnType());
                        var = this.createAssignment(expr, tCtx);
                        f.setBody((ILogicalPlan)new ALogicalPlanImpl(XMLQueryTranslator.mutable(tCtx.op)));
                        break;
                    }
                }
            }
        }
    }

    private SequenceType createSequenceType(ASTNode type) throws SystemException {
        switch (type.getTag()) {
            case TYPE_DECLARATION: {
                TypeDeclNode tDecl = (TypeDeclNode)type;
                return this.createSequenceType(tDecl.getType());
            }
            case SEQUENCE_TYPE: {
                SequenceTypeNode sType = (SequenceTypeNode)type;
                if (sType.getItemType() == null) {
                    return SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_STAR);
                }
                XQueryConstants.TypeQuantifier tq = sType.getQuantifier();
                Quantifier q = Quantifier.QUANT_ONE;
                if (tq != null) {
                    switch (tq) {
                        case QUANT_QUESTION: {
                            q = Quantifier.QUANT_QUESTION;
                            break;
                        }
                        case QUANT_PLUS: {
                            q = Quantifier.QUANT_PLUS;
                            break;
                        }
                        case QUANT_STAR: {
                            q = Quantifier.QUANT_STAR;
                        }
                    }
                }
                ItemType iType = this.createItemType(sType.getItemType());
                return SequenceType.create(iType, q);
            }
            case EMPTY_SEQUENCE_TYPE: {
                return SequenceType.create(EmptySequenceType.INSTANCE, Quantifier.QUANT_ZERO);
            }
            case SINGLE_TYPE: {
                SingleTypeNode stNode = (SingleTypeNode)type;
                ItemType iType = this.createItemType(stNode.getAtomicType());
                return SequenceType.create(iType, stNode.isOptional() ? Quantifier.QUANT_QUESTION : Quantifier.QUANT_ONE);
            }
        }
        throw new IllegalStateException("Unknown node: " + (Object)((Object)type.getTag()));
    }

    private ItemType createItemType(ASTNode itemType) throws SystemException {
        switch (itemType.getTag()) {
            case ITEM_TYPE: {
                return AnyItemType.INSTANCE;
            }
            case ATOMIC_TYPE: {
                AtomicTypeNode atNode = (AtomicTypeNode)itemType;
                QName tName = this.createQName(atNode.getName());
                SchemaType sType = this.moduleCtx.lookupSchemaType(tName);
                if (sType == null || !sType.isAtomicType()) {
                    throw new SystemException(ErrorCode.XPST0051, atNode.getSourceLocation());
                }
                return (ItemType)((Object)sType);
            }
            case ANY_NODE_TEST: {
                return AnyNodeType.INSTANCE;
            }
            case DOCUMENT_TEST: {
                DocumentTestNode dt = (DocumentTestNode)itemType;
                if (dt.getElementTest() == null) {
                    return DocumentType.ANYDOCUMENT;
                }
                ElementType eType = (ElementType)this.createItemType(dt.getElementTest());
                return new DocumentType(eType);
            }
            case TEXT_TEST: {
                return TextType.INSTANCE;
            }
            case COMMENT_TEST: {
                return CommentType.INSTANCE;
            }
            case PI_TEST: {
                PITestNode pit = (PITestNode)itemType;
                if (pit.getTarget() == null) {
                    return ProcessingInstructionType.ANYPI;
                }
                return new ProcessingInstructionType(this.createUTF8String(pit.getTarget()));
            }
            case ATTRIBUTE_TEST: {
                AttributeTestNode at = (AttributeTestNode)itemType;
                if (at.getNameTest() == null) {
                    return AttributeType.ANYATTRIBUTE;
                }
                NameTestNode ntNode = at.getNameTest();
                NameTest nt = NameTest.STAR_NAMETEST;
                if (ntNode.getPrefix() == null && ntNode.getLocalName() == null) {
                    if (at.getTypeName() == null) {
                        return AttributeType.ANYATTRIBUTE;
                    }
                } else {
                    String uri;
                    if (!"".equals(ntNode.getPrefix())) {
                        uri = this.currCtx.lookupNamespaceUri(ntNode.getPrefix());
                        if (uri == null) {
                            throw new SystemException(ErrorCode.XPST0081, ntNode.getSourceLocation());
                        }
                    } else {
                        uri = "";
                    }
                    nt = new NameTest(this.createUTF8String(uri), this.createUTF8String(ntNode.getLocalName()));
                }
                SchemaType cType = BuiltinTypeRegistry.XS_ANY_ATOMIC;
                if (at.getTypeName() != null && (cType = this.moduleCtx.lookupSchemaType(this.createQName(at.getTypeName()))) == null) {
                    throw new SystemException(ErrorCode.XPST0051, at.getSourceLocation());
                }
                return new AttributeType(nt, cType);
            }
            case SCHEMA_ATTRIBUTE_TEST: {
                throw new UnsupportedOperationException("schema-attribute(...) is not supported");
            }
            case ELEMENT_TEST: {
                ElementTestNode et = (ElementTestNode)itemType;
                if (et.getNameTest() == null) {
                    return ElementType.ANYELEMENT;
                }
                NameTestNode ntNode = et.getNameTest();
                NameTest nt = NameTest.STAR_NAMETEST;
                if (ntNode.getPrefix() == null && ntNode.getLocalName() == null) {
                    if (et.getTypeName() == null) {
                        return ElementType.ANYELEMENT;
                    }
                } else {
                    String uri;
                    if (!"".equals(ntNode.getPrefix())) {
                        uri = this.currCtx.lookupNamespaceUri(ntNode.getPrefix());
                        if (uri == null) {
                            throw new SystemException(ErrorCode.XPST0081, ntNode.getSourceLocation());
                        }
                    } else {
                        uri = "";
                    }
                    nt = new NameTest(this.createUTF8String(uri), this.createUTF8String(ntNode.getLocalName()));
                }
                SchemaType cType = AnyType.INSTANCE;
                if (et.getTypeName() != null && (cType = this.moduleCtx.lookupSchemaType(this.createQName(et.getTypeName()))) == null) {
                    throw new SystemException(ErrorCode.XPST0051, et.getSourceLocation());
                }
                return new ElementType(nt, cType, et.isNillable());
            }
            case SCHEMA_ELEMENT_TEST: {
                throw new UnsupportedOperationException("schema-element(...) is not supported");
            }
        }
        throw new IllegalStateException("Unknown node: " + (Object)((Object)itemType.getTag()));
    }

    private byte[] createUTF8String(String str) {
        ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        StringValueBuilder svb = new StringValueBuilder();
        try {
            svb.write(str, abvs.getDataOutput());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return Arrays.copyOf(abvs.getByteArray(), abvs.getLength());
    }

    private ILogicalPlan translateMainModule(MainModuleNode moduleNode) throws SystemException {
        QueryBodyNode qbn = moduleNode.getQueryBody();
        ASTNode queryBody = qbn.getExpression();
        TranslationContext tCtx = new TranslationContext(null, (ILogicalOperator)new EmptyTupleSourceOperator());
        LogicalVariable lVar = this.translateExpression(queryBody, tCtx);
        LogicalVariable iLVar = this.newLogicalVariable();
        UnnestOperator unnest = new UnnestOperator(iLVar, XMLQueryTranslator.mutable(XMLQueryTranslator.ufce(BuiltinOperators.ITERATE, XMLQueryTranslator.vre(lVar))));
        unnest.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
        ArrayList<Mutable<ILogicalExpression>> exprs = new ArrayList<Mutable<ILogicalExpression>>();
        exprs.add(XMLQueryTranslator.mutable(XMLQueryTranslator.vre(iLVar)));
        QueryResultSetDataSink sink = new QueryResultSetDataSink(this.ccb.getResultSetId(), null);
        DistributeResultOperator op = new DistributeResultOperator(exprs, (IDataSink)sink);
        op.getInputs().add(XMLQueryTranslator.mutable((ILogicalOperator)unnest));
        ALogicalPlanImpl lp = new ALogicalPlanImpl(XMLQueryTranslator.mutable((ILogicalOperator)op));
        return lp;
    }

    private LogicalVariable translateExpression(ASTNode value, TranslationContext tCtx) throws SystemException {
        switch (value.getTag()) {
            case EXPRESSION: {
                ExprNode node = (ExprNode)value;
                return this.translateExprNode(tCtx, node);
            }
            case UNARY_EXPRESSION: {
                UnaryExprNode ueNode = (UnaryExprNode)value;
                return this.translateUnaryExprNode(tCtx, ueNode);
            }
            case INFIX_EXPRESSION: {
                InfixExprNode ie = (InfixExprNode)value;
                return this.translateInfixExprNode(tCtx, ie);
            }
            case ENCLOSED_EXPRESSION: {
                EnclosedExprNode ee = (EnclosedExprNode)value;
                return this.translateEnclosedExprNode(tCtx, ee);
            }
            case PATH_EXPRESSION: {
                return this.translatePathExpr((PathExprNode)value, tCtx);
            }
            case FUNCTION_EXPRESSION: {
                FunctionExprNode fnNode = (FunctionExprNode)value;
                return this.translateFunctionExprNode(tCtx, fnNode);
            }
            case TYPE_EXPRESSION: {
                TypeExprNode teNode = (TypeExprNode)value;
                return this.translateTypeExprNode(tCtx, teNode);
            }
            case EXTENSION_EXPRESSION: {
                ExtensionExprNode eNode = (ExtensionExprNode)value;
                return this.translateExtensionExprNode(tCtx, eNode);
            }
            case PARENTHESIZED_EXPRESSION: {
                ParenthesizedExprNode peNode = (ParenthesizedExprNode)value;
                return this.translateParenthisizedExprNode(tCtx, peNode);
            }
            case LITERAL: {
                LiteralNode lNode = (LiteralNode)value;
                return this.translateLiteralNode(tCtx, lNode);
            }
            case DIRECT_PI_CONSTRUCTOR: {
                DirectPIConstructorNode dpicNode = (DirectPIConstructorNode)value;
                return this.translateDirectPIConstructorNode(tCtx, dpicNode);
            }
            case DIRECT_COMMENT_CONSTRUCTOR: {
                DirectCommentConstructorNode dccNode = (DirectCommentConstructorNode)value;
                return this.translateDirectCommentConstructorNode(tCtx, dccNode);
            }
            case DIRECT_ELEMENT_CONSTRUCTOR: {
                DirectElementConstructorNode decNode = (DirectElementConstructorNode)value;
                return this.translateDirectElementConstructorNode(tCtx, decNode);
            }
            case DIRECT_ATTRIBUTE_CONSTRUCTOR: {
                DirectAttributeConstructorNode dacNode = (DirectAttributeConstructorNode)value;
                return this.translateDirectAttributeConstructorNode(tCtx, dacNode);
            }
            case CONTEXT_ITEM: {
                return tCtx.varScope.lookupVariable(XMLQueryCompilerConstants.DOT_VAR_NAME).getLogicalVariable();
            }
            case IF_EXPRESSION: {
                IfExprNode ieNode = (IfExprNode)value;
                return this.translateIfExprNode(tCtx, ieNode);
            }
            case VARIABLE_REFERENCE: {
                VarRefNode vrNode = (VarRefNode)value;
                return this.translateVarRefNode(tCtx, vrNode);
            }
            case FLWOR_EXPRESSION: {
                FLWORExprNode fNode = (FLWORExprNode)value;
                return this.translateFLWORExprNode(tCtx, fNode);
            }
            case QUANTIFIED_EXPRESSION: {
                QuantifiedExprNode qeNode = (QuantifiedExprNode)value;
                return this.translateQuantifiedExprNode(tCtx, qeNode);
            }
            case COMPUTED_TEXT_CONSTRUCTOR: {
                ComputedTextConstructorNode cNode = (ComputedTextConstructorNode)value;
                return this.translateComputedTextConstructorNode(tCtx, cNode);
            }
            case COMPUTED_PI_CONSTRUCTOR: {
                ComputedPIConstructorNode cNode = (ComputedPIConstructorNode)value;
                return this.translateComputedPIConstructorNode(tCtx, cNode);
            }
            case COMPUTED_COMMENT_CONSTRUCTOR: {
                ComputedCommentConstructorNode cNode = (ComputedCommentConstructorNode)value;
                return this.translateComputedCommentConstructorNode(tCtx, cNode);
            }
            case COMPUTED_DOCUMENT_CONSTRUCTOR: {
                ComputedDocumentConstructorNode cNode = (ComputedDocumentConstructorNode)value;
                return this.translateComputedDocumentConstructorNode(tCtx, cNode);
            }
            case COMPUTED_ELEMENT_CONSTRUCTOR: {
                ComputedElementConstructorNode cNode = (ComputedElementConstructorNode)value;
                return this.translateComputedElementConstructorNode(tCtx, cNode);
            }
            case COMPUTED_ATTRIBUTE_CONSTRUCTOR: {
                ComputedAttributeConstructorNode cNode = (ComputedAttributeConstructorNode)value;
                return this.translateComputedAttributeConstructorNode(tCtx, cNode);
            }
            case QNAME: {
                QNameNode qnNode = (QNameNode)value;
                return this.translateQNameNode(tCtx, qnNode);
            }
            case NCNAME: {
                NCNameNode ncnNode = (NCNameNode)value;
                return this.translateNCNameNode(tCtx, ncnNode);
            }
            case CDATA_SECTION: {
                CDataSectionNode cdsNode = (CDataSectionNode)value;
                return this.translateCDataSectionNode(tCtx, cdsNode);
            }
            case ORDERED_EXPRESSION: {
                OrderedExprNode oeNode = (OrderedExprNode)value;
                return this.translateOrderedExprNode(tCtx, oeNode);
            }
            case UNORDERED_EXPRESSION: {
                UnorderedExprNode ueNode = (UnorderedExprNode)value;
                return this.translateUnorderedExprNode(tCtx, ueNode);
            }
            case VALIDATE_EXPRESSION: {
                ValidateExprNode vNode = (ValidateExprNode)value;
                return this.translateValidateExprNode(tCtx, vNode);
            }
        }
        throw new IllegalStateException("Unknown node: " + (Object)((Object)value.getTag()));
    }

    private LogicalVariable translateQuantifiedExprNode(TranslationContext tCtx, QuantifiedExprNode qeNode) throws SystemException {
        tCtx = tCtx.pushContext();
        int pushCount = 0;
        for (QuantifiedVarDeclNode qvdNode : qeNode.getVariables()) {
            ILogicalExpression seq = XMLQueryTranslator.vre(this.translateExpression(qvdNode.getSequence(), tCtx));
            tCtx.pushVariableScope();
            LogicalVariable forLVar = this.newLogicalVariable();
            UnnestOperator unnest = new UnnestOperator(forLVar, XMLQueryTranslator.mutable(XMLQueryTranslator.ufce(BuiltinOperators.ITERATE, seq)));
            SequenceType forVarType = SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_ONE);
            if (qvdNode.getType() != null) {
                forVarType = this.createSequenceType(qvdNode.getType());
            }
            XQueryVariable forVar = new XQueryVariable(this.createQName(qvdNode.getVariable()), forVarType, forLVar);
            tCtx.varScope.registerVariable(forVar);
            unnest.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
            tCtx.op = (ILogicalOperator)unnest;
            ++pushCount;
        }
        ILogicalExpression satExpr = XMLQueryTranslator.sfce(BuiltinFunctions.FN_BOOLEAN_1, XMLQueryTranslator.vre(this.translateExpression(qeNode.getSatisfiesExpr(), tCtx)));
        if (qeNode.getQuant() == QuantifiedExprNode.QuantifierType.EVERY) {
            satExpr = XMLQueryTranslator.sfce(BuiltinFunctions.FN_NOT_1, satExpr);
        }
        SelectOperator select = new SelectOperator(XMLQueryTranslator.mutable(satExpr));
        select.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
        tCtx.op = (ILogicalOperator)select;
        ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> exprs = new ArrayList<Mutable<ILogicalExpression>>();
        LogicalVariable var = this.newLogicalVariable();
        vars.add(var);
        exprs.add(XMLQueryTranslator.mutable(XMLQueryTranslator.afce(BuiltinOperators.SEQUENCE, false, this.ce(SequenceType.create(BuiltinTypeRegistry.XS_BOOLEAN, Quantifier.QUANT_ONE), Boolean.TRUE))));
        AggregateOperator aop = new AggregateOperator(vars, exprs);
        aop.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
        tCtx.op = (ILogicalOperator)aop;
        for (int i = 0; i < pushCount; ++i) {
            tCtx.popVariableScope();
        }
        tCtx = tCtx.popContext();
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(qeNode.getQuant() == QuantifiedExprNode.QuantifierType.EVERY ? BuiltinFunctions.FN_EMPTY_1 : BuiltinFunctions.FN_EXISTS_1, XMLQueryTranslator.vre(var)), tCtx);
        return lVar;
    }

    private LogicalVariable translateUnorderedExprNode(TranslationContext tCtx, UnorderedExprNode ueNode) throws SystemException {
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.UNORDERED, XMLQueryTranslator.vre(this.translateExpression(ueNode.getExpr(), tCtx))), tCtx);
        return lVar;
    }

    private LogicalVariable translateOrderedExprNode(TranslationContext tCtx, OrderedExprNode oeNode) throws SystemException {
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.ORDERED, XMLQueryTranslator.vre(this.translateExpression(oeNode.getExpr(), tCtx))), tCtx);
        return lVar;
    }

    private LogicalVariable translateCDataSectionNode(TranslationContext tCtx, CDataSectionNode cdsNode) throws SystemException {
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.TEXT_CONSTRUCTOR, this.ce(SequenceType.create(BuiltinTypeRegistry.XS_UNTYPED_ATOMIC, Quantifier.QUANT_ONE), cdsNode.getContent())), tCtx);
        return lVar;
    }

    private LogicalVariable translateNCNameNode(TranslationContext tCtx, NCNameNode ncnNode) throws SystemException {
        LogicalVariable lVar = this.createAssignment(this.ce(SequenceType.create(BuiltinTypeRegistry.XS_STRING, Quantifier.QUANT_ONE), ncnNode.getName()), tCtx);
        return lVar;
    }

    private LogicalVariable translateQNameNode(TranslationContext tCtx, QNameNode qnNode) throws SystemException {
        LogicalVariable lVar = this.createAssignment(this.ce(SequenceType.create(BuiltinTypeRegistry.XS_QNAME, Quantifier.QUANT_ONE), this.createQName(qnNode)), tCtx);
        return lVar;
    }

    private LogicalVariable translateValidateExprNode(TranslationContext tCtx, ValidateExprNode vNode) throws SystemException {
        XQueryConstants.ValidationMode mode = vNode.getMode();
        Operator fn = mode == null || XQueryConstants.ValidationMode.STRICT.equals((Object)mode) ? BuiltinOperators.VALIDATE_STRICT : BuiltinOperators.VALIDATE_LAX;
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(fn, XMLQueryTranslator.vre(this.translateExpression(vNode.getExpr(), tCtx))), tCtx);
        return lVar;
    }

    private LogicalVariable translateComputedAttributeConstructorNode(TranslationContext tCtx, ComputedAttributeConstructorNode cNode) throws SystemException {
        ILogicalExpression name = this.cast(XMLQueryTranslator.vre(this.translateExpression(cNode.getName(), tCtx)), SequenceType.create(BuiltinTypeRegistry.XS_QNAME, Quantifier.QUANT_ONE));
        ASTNode content = cNode.getContent();
        ILogicalExpression cExpr = content == null ? XMLQueryTranslator.sfce(BuiltinOperators.CONCATENATE, new ILogicalExpression[0]) : XMLQueryTranslator.vre(this.translateExpression(content, tCtx));
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.ATTRIBUTE_CONSTRUCTOR, name, cExpr), tCtx);
        return lVar;
    }

    private LogicalVariable translateComputedElementConstructorNode(TranslationContext tCtx, ComputedElementConstructorNode cNode) throws SystemException {
        ILogicalExpression name = this.cast(XMLQueryTranslator.vre(this.translateExpression(cNode.getName(), tCtx)), SequenceType.create(BuiltinTypeRegistry.XS_QNAME, Quantifier.QUANT_ONE));
        ASTNode content = cNode.getContent();
        ILogicalExpression cExpr = content == null ? XMLQueryTranslator.sfce(BuiltinOperators.CONCATENATE, new ILogicalExpression[0]) : XMLQueryTranslator.vre(this.translateExpression(content, tCtx));
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.ELEMENT_CONSTRUCTOR, name, cExpr), tCtx);
        return lVar;
    }

    private LogicalVariable translateComputedDocumentConstructorNode(TranslationContext tCtx, ComputedDocumentConstructorNode cNode) throws SystemException {
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.DOCUMENT_CONSTRUCTOR, XMLQueryTranslator.vre(this.translateExpression(cNode.getContent(), tCtx))), tCtx);
        return lVar;
    }

    private LogicalVariable translateComputedCommentConstructorNode(TranslationContext tCtx, ComputedCommentConstructorNode cNode) throws SystemException {
        ASTNode content = cNode.getContent();
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.COMMENT_CONSTRUCTOR, content == null ? XMLQueryTranslator.sfce(BuiltinOperators.CONCATENATE, new ILogicalExpression[0]) : XMLQueryTranslator.vre(this.translateExpression(content, tCtx))), tCtx);
        return lVar;
    }

    private LogicalVariable translateComputedPIConstructorNode(TranslationContext tCtx, ComputedPIConstructorNode cNode) throws SystemException {
        ASTNode content = cNode.getContent();
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.PI_CONSTRUCTOR, XMLQueryTranslator.vre(this.translateExpression(cNode.getTarget(), tCtx)), content == null ? XMLQueryTranslator.sfce(BuiltinOperators.CONCATENATE, new ILogicalExpression[0]) : XMLQueryTranslator.vre(this.translateExpression(content, tCtx))), tCtx);
        return lVar;
    }

    private LogicalVariable translateComputedTextConstructorNode(TranslationContext tCtx, ComputedTextConstructorNode cNode) throws SystemException {
        ASTNode content = cNode.getContent();
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.TEXT_CONSTRUCTOR, content == null ? this.ce(SequenceType.create(BuiltinTypeRegistry.XS_UNTYPED_ATOMIC, Quantifier.QUANT_ONE), "") : XMLQueryTranslator.vre(this.translateExpression(content, tCtx))), tCtx);
        return lVar;
    }

    private LogicalVariable translateFLWORExprNode(TranslationContext tCtx, FLWORExprNode fNode) throws SystemException {
        tCtx = tCtx.pushContext();
        List<FLWORClauseNode> cNodes = fNode.getClauses();
        int pushCount = 0;
        block10: for (FLWORClauseNode cNode : cNodes) {
            switch (cNode.getTag()) {
                case FOR_CLAUSE: {
                    ForClauseNode fcNode = (ForClauseNode)cNode;
                    for (ForVarDeclNode fvdNode : fcNode.getVariables()) {
                        ILogicalExpression seq = XMLQueryTranslator.vre(this.translateExpression(fvdNode.getSequence(), tCtx));
                        tCtx.pushVariableScope();
                        LogicalVariable forLVar = this.newLogicalVariable();
                        LogicalVariable posLVar = fvdNode.getPosVar() != null ? this.newLogicalVariable() : null;
                        UnnestOperator unnest = new UnnestOperator(forLVar, XMLQueryTranslator.mutable(XMLQueryTranslator.ufce(BuiltinOperators.ITERATE, seq)), posLVar, null);
                        SequenceType forVarType = SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_ONE);
                        if (fvdNode.getType() != null) {
                            forVarType = this.createSequenceType(fvdNode.getType());
                        }
                        XQueryVariable forVar = new XQueryVariable(this.createQName(fvdNode.getForVar()), forVarType, forLVar);
                        tCtx.varScope.registerVariable(forVar);
                        XQueryVariable posVar = null;
                        if (fvdNode.getPosVar() != null) {
                            posVar = new XQueryVariable(this.createQName(fvdNode.getPosVar()), SequenceType.create(BuiltinTypeRegistry.XS_INTEGER, Quantifier.QUANT_ONE), posLVar);
                            tCtx.varScope.registerVariable(posVar);
                        }
                        assert (fvdNode.getScoreVar() == null);
                        unnest.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
                        tCtx.op = (ILogicalOperator)unnest;
                        ++pushCount;
                    }
                    continue block10;
                }
                case LET_CLAUSE: {
                    LetClauseNode lcNode = (LetClauseNode)cNode;
                    for (LetVarDeclNode lvdNode : lcNode.getVariables()) {
                        LogicalVariable seqVar = this.translateExpression(lvdNode.getSequence(), tCtx);
                        tCtx.pushVariableScope();
                        SequenceType letVarType = SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_ONE);
                        if (lvdNode.getType() != null) {
                            letVarType = this.createSequenceType(lvdNode.getType());
                        }
                        XQueryVariable letVar = new XQueryVariable(this.createQName(lvdNode.getLetVar()), letVarType, seqVar);
                        tCtx.varScope.registerVariable(letVar);
                        ++pushCount;
                    }
                    continue block10;
                }
                case WHERE_CLAUSE: {
                    WhereClauseNode wcNode = (WhereClauseNode)cNode;
                    ILogicalExpression condExpr = XMLQueryTranslator.sfce(BuiltinFunctions.FN_BOOLEAN_1, XMLQueryTranslator.vre(this.translateExpression(wcNode.getCondition(), tCtx)));
                    SelectOperator select = new SelectOperator(XMLQueryTranslator.mutable(condExpr));
                    select.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
                    tCtx.op = (ILogicalOperator)select;
                    break;
                }
                case ORDERBY_CLAUSE: {
                    OrderbyClauseNode ocNode = (OrderbyClauseNode)cNode;
                    ArrayList<edu.uci.ics.hyracks.algebricks.common.utils.Pair> oExprs = new ArrayList<edu.uci.ics.hyracks.algebricks.common.utils.Pair>();
                    ArrayList collations = new ArrayList();
                    for (OrderSpecNode osNode : ocNode.getOrderSpec()) {
                        ILogicalExpression oExpr = XMLQueryTranslator.vre(this.translateExpression(osNode.getExpression(), tCtx));
                        OrderOperator.IOrder o = OrderOperator.ASC_ORDER;
                        XQueryConstants.OrderDirection oDir = osNode.getDirection();
                        if (oDir != null) {
                            switch (oDir) {
                                case ASCENDING: {
                                    o = OrderOperator.ASC_ORDER;
                                    break;
                                }
                                case DESCENDING: {
                                    o = OrderOperator.DESC_ORDER;
                                }
                            }
                        }
                        oExprs.add(new edu.uci.ics.hyracks.algebricks.common.utils.Pair((Object)o, XMLQueryTranslator.mutable(oExpr)));
                    }
                    OrderOperator order = new OrderOperator(oExprs);
                    order.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
                    tCtx.op = (ILogicalOperator)order;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown clause: " + (Object)((Object)cNode.getTag()));
                }
            }
        }
        ILogicalExpression rExpr = XMLQueryTranslator.vre(this.translateExpression(fNode.getReturnExpr(), tCtx));
        ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> exprs = new ArrayList<Mutable<ILogicalExpression>>();
        LogicalVariable var = this.newLogicalVariable();
        vars.add(var);
        exprs.add(XMLQueryTranslator.mutable(XMLQueryTranslator.afce(BuiltinOperators.SEQUENCE, false, rExpr)));
        AggregateOperator aop = new AggregateOperator(vars, exprs);
        aop.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
        tCtx.op = (ILogicalOperator)aop;
        for (int i = 0; i < pushCount; ++i) {
            tCtx.popVariableScope();
        }
        tCtx = tCtx.popContext();
        return var;
    }

    private LogicalVariable translateVarRefNode(TranslationContext tCtx, VarRefNode vrNode) throws SystemException {
        QName vName = this.createQName(vrNode.getVariable());
        XQueryVariable var = tCtx.varScope.lookupVariable(vName);
        if (var == null) {
            throw new SystemException(ErrorCode.XPST0008, vrNode.getSourceLocation());
        }
        LogicalVariable lVar = this.createAssignment(this.treat(XMLQueryTranslator.vre(var.getLogicalVariable()), var.getType()), tCtx);
        return lVar;
    }

    private LogicalVariable translateIfExprNode(TranslationContext tCtx, IfExprNode ieNode) throws SystemException {
        ILogicalExpression cond = XMLQueryTranslator.sfce(BuiltinFunctions.FN_BOOLEAN_1, XMLQueryTranslator.vre(this.translateExpression(ieNode.getIfExpr(), tCtx)));
        ILogicalExpression tExpr = XMLQueryTranslator.vre(this.translateExpression(ieNode.getThenExpr(), tCtx));
        ILogicalExpression eExpr = XMLQueryTranslator.vre(this.translateExpression(ieNode.getElseExpr(), tCtx));
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.IF_THEN_ELSE, cond, tExpr, eExpr), tCtx);
        return lVar;
    }

    private LogicalVariable translateDirectAttributeConstructorNode(TranslationContext tCtx, DirectAttributeConstructorNode dacNode) throws SystemException {
        QName aQName = this.createQName(dacNode.getName());
        ILogicalExpression name = this.ce(SequenceType.create(BuiltinTypeRegistry.XS_QNAME, Quantifier.QUANT_ONE), aQName);
        ArrayList<ILogicalExpression> content = new ArrayList<ILogicalExpression>();
        block3: for (ASTNode aVal : dacNode.getValue()) {
            switch (aVal.getTag()) {
                case CONTENT_CHARS: {
                    String contentChars = ((ContentCharsNode)aVal).getContent();
                    ILogicalExpression cce = this.ce(SequenceType.create(BuiltinTypeRegistry.XS_UNTYPED_ATOMIC, Quantifier.QUANT_ONE), contentChars);
                    content.add(cce);
                    continue block3;
                }
            }
            content.add(XMLQueryTranslator.vre(this.translateExpression(aVal, tCtx)));
        }
        ILogicalExpression contentExpr = content.size() == 1 ? (ILogicalExpression)content.get(0) : XMLQueryTranslator.sfce(BuiltinOperators.CONCATENATE, content.toArray(new ILogicalExpression[content.size()]));
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.ATTRIBUTE_CONSTRUCTOR, name, contentExpr), tCtx);
        return lVar;
    }

    private LogicalVariable translateDirectElementConstructorNode(TranslationContext tCtx, DirectElementConstructorNode decNode) throws SystemException {
        QNameNode startName = decNode.getStartTagName();
        QNameNode endName = decNode.getEndTagName();
        if (!(endName == null || startName.getPrefix().equals(endName.getPrefix()) && startName.getLocalName().equals(endName.getLocalName()))) {
            throw new SystemException(ErrorCode.XPST0003, endName.getSourceLocation());
        }
        this.pushContext();
        for (DirectAttributeConstructorNode acNode : decNode.getAttributes()) {
            QNameNode aName = acNode.getName();
            if (!"xmlns".equals(aName.getPrefix())) continue;
            List<ASTNode> values = acNode.getValue();
            if (values.size() != 1 || !ASTTag.CONTENT_CHARS.equals((Object)values.get(0).getTag())) {
                throw new SystemException(ErrorCode.XQST0022, acNode.getSourceLocation());
            }
            this.currCtx.registerNamespaceUri(aName.getLocalName(), XMLQueryTranslator.unquote(((ContentCharsNode)values.get(0)).getContent()));
        }
        ArrayList<ILogicalExpression> content = new ArrayList<ILogicalExpression>();
        for (DirectAttributeConstructorNode acNode : decNode.getAttributes()) {
            QNameNode aName = acNode.getName();
            if ("xmlns".equals(aName.getPrefix())) continue;
            content.add(XMLQueryTranslator.vre(this.translateExpression(acNode, tCtx)));
        }
        ILogicalExpression name = this.ce(SequenceType.create(BuiltinTypeRegistry.XS_QNAME, Quantifier.QUANT_ONE), this.createQName(startName, this.moduleCtx.getDefaultElementNamespaceUri()));
        block5: for (ASTNode cVal : decNode.getContent()) {
            switch (cVal.getTag()) {
                case CONTENT_CHARS: {
                    String contentChars = ((ContentCharsNode)cVal).getContent();
                    ILogicalExpression cce = this.ce(SequenceType.create(BuiltinTypeRegistry.XS_UNTYPED_ATOMIC, Quantifier.QUANT_ONE), contentChars);
                    content.add(XMLQueryTranslator.sfce(BuiltinOperators.TEXT_CONSTRUCTOR, cce));
                    continue block5;
                }
            }
            content.add(XMLQueryTranslator.vre(this.translateExpression(cVal, tCtx)));
        }
        this.popContext();
        ILogicalExpression contentExpr = content.size() == 1 ? (ILogicalExpression)content.get(0) : XMLQueryTranslator.sfce(BuiltinOperators.CONCATENATE, content.toArray(new ILogicalExpression[content.size()]));
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.ELEMENT_CONSTRUCTOR, name, contentExpr), tCtx);
        return lVar;
    }

    private LogicalVariable translateDirectCommentConstructorNode(TranslationContext tCtx, DirectCommentConstructorNode dccNode) throws SystemException {
        String content = dccNode.getContent();
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.COMMENT_CONSTRUCTOR, this.ce(SequenceType.create(BuiltinTypeRegistry.XS_STRING, Quantifier.QUANT_ONE), content)), tCtx);
        return lVar;
    }

    private LogicalVariable translateDirectPIConstructorNode(TranslationContext tCtx, DirectPIConstructorNode dpicNode) throws SystemException {
        String target = dpicNode.getTarget();
        String content = dpicNode.getContent();
        LogicalVariable lVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinOperators.PI_CONSTRUCTOR, this.ce(SequenceType.create(BuiltinTypeRegistry.XS_STRING, Quantifier.QUANT_ONE), target), this.ce(SequenceType.create(BuiltinTypeRegistry.XS_STRING, Quantifier.QUANT_ONE), content)), tCtx);
        return lVar;
    }

    private LogicalVariable translateLiteralNode(TranslationContext tCtx, LiteralNode lNode) throws SystemException {
        String image = lNode.getImage();
        LiteralNode.LiteralType lType = lNode.getType();
        SequenceType t = null;
        Object value = null;
        switch (lType) {
            case DECIMAL: {
                t = SequenceType.create(BuiltinTypeRegistry.XS_DECIMAL, Quantifier.QUANT_ONE);
                value = Double.parseDouble(image);
                break;
            }
            case DOUBLE: {
                t = SequenceType.create(BuiltinTypeRegistry.XS_DOUBLE, Quantifier.QUANT_ONE);
                value = Double.parseDouble(image);
                break;
            }
            case INTEGER: {
                t = SequenceType.create(BuiltinTypeRegistry.XS_INTEGER, Quantifier.QUANT_ONE);
                try {
                    value = Long.parseLong(image);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new SystemException(ErrorCode.FOAR0002);
                }
            }
            case STRING: {
                t = SequenceType.create(BuiltinTypeRegistry.XS_STRING, Quantifier.QUANT_ONE);
                value = XMLQueryTranslator.unquote(image);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + (Object)((Object)lType));
            }
        }
        LogicalVariable lVar = this.createAssignment(this.ce(t, value), tCtx);
        return lVar;
    }

    private LogicalVariable translateParenthisizedExprNode(TranslationContext tCtx, ParenthesizedExprNode peNode) throws SystemException {
        ASTNode eNode = peNode.getExpr();
        if (eNode == null) {
            return this.createConcatenation(Collections.<LogicalVariable>emptyList(), tCtx);
        }
        return this.translateExpression(peNode.getExpr(), tCtx);
    }

    private LogicalVariable translateExtensionExprNode(TranslationContext tCtx, ExtensionExprNode eNode) throws SystemException {
        if (eNode.getExpr() == null) {
            throw new SystemException(ErrorCode.XQST0079, eNode.getSourceLocation());
        }
        return this.translateExpression(eNode.getExpr(), tCtx);
    }

    private LogicalVariable translateTypeExprNode(TranslationContext tCtx, TypeExprNode teNode) throws SystemException {
        LogicalVariable var = this.translateExpression(teNode.getExpr(), tCtx);
        SequenceType type = this.createSequenceType(teNode.getType());
        ILogicalExpression expr = null;
        switch (teNode.getOperator()) {
            case CAST: {
                expr = this.cast(XMLQueryTranslator.vre(var), type);
                break;
            }
            case CASTABLE: {
                expr = this.castable(XMLQueryTranslator.vre(var), type);
                break;
            }
            case INSTANCEOF: {
                expr = this.instanceOf(XMLQueryTranslator.vre(var), type);
                break;
            }
            case TREAT: {
                expr = this.treat(XMLQueryTranslator.vre(var), type);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type operator: " + (Object)((Object)teNode.getOperator()));
            }
        }
        LogicalVariable lVar = this.createAssignment(expr, tCtx);
        return lVar;
    }

    private LogicalVariable translateFunctionExprNode(TranslationContext tCtx, FunctionExprNode fnNode) throws SystemException {
        Function[] fns;
        ArrayList<LogicalVariable> args = new ArrayList<LogicalVariable>();
        for (ASTNode an : fnNode.getArguments()) {
            args.add(this.translateExpression(an, tCtx));
        }
        QName name = this.createQName(fnNode.getName());
        SchemaType type = this.moduleCtx.lookupSchemaType(name);
        if (type != null && args.size() < 2) {
            if (!type.isAtomicType()) {
                throw new SystemException(ErrorCode.XPST0051, fnNode.getName().getSourceLocation());
            }
            LogicalVariable var = args.isEmpty() ? tCtx.varScope.lookupVariable(XMLQueryCompilerConstants.DOT_VAR_NAME).getLogicalVariable() : (LogicalVariable)args.get(0);
            ILogicalExpression expr = this.cast(XMLQueryTranslator.vre(var), SequenceType.create((ItemType)((Object)type), Quantifier.QUANT_QUESTION));
            return this.createAssignment(expr, tCtx);
        }
        QName fName = this.createQName(fnNode.getName(), this.moduleCtx.getDefaultFunctionNamespaceUri());
        if (BuiltinFunctions.FN_POSITION_QNAME.equals(fName)) {
            XQueryVariable var = tCtx.varScope.lookupVariable(XMLQueryCompilerConstants.POS_VAR_NAME);
            return var.getLogicalVariable();
        }
        if (BuiltinFunctions.FN_LAST_QNAME.equals(fName)) {
            XQueryVariable var = tCtx.varScope.lookupVariable(XMLQueryCompilerConstants.LAST_VAR_NAME);
            return var.getLogicalVariable();
        }
        int nArgs = fnNode.getArguments().size();
        Function fn = this.moduleCtx.lookupFunction(fName, nArgs);
        if (fn != null && fn.useContextImplicitly()) {
            args.add(tCtx.varScope.lookupVariable(XMLQueryCompilerConstants.DOT_VAR_NAME).getLogicalVariable());
            fn = this.moduleCtx.lookupFunction(fName, nArgs + 1);
        }
        if (fn == null && (fns = this.moduleCtx.lookupFunctions(fName)) != null) {
            for (int i = 0; i < fns.length && i <= nArgs; ++i) {
                if (fns[i] == null || !fns[i].getSignature().isVarArgs()) continue;
                fn = fns[i];
                break;
            }
        }
        if (fn == null) {
            throw new SystemException(ErrorCode.XPST0017, fnNode.getName().getSourceLocation());
        }
        Signature sign = fn.getSignature();
        ArrayList<Mutable<ILogicalExpression>> argExprs = new ArrayList<Mutable<ILogicalExpression>>();
        for (int i = 0; i < args.size(); ++i) {
            SequenceType argType = sign.getParameterType(i);
            argExprs.add(XMLQueryTranslator.mutable(this.normalize(XMLQueryTranslator.vre((LogicalVariable)args.get(i)), argType)));
        }
        LogicalVariable lVar = this.createAssignment((ILogicalExpression)new ScalarFunctionCallExpression((IFunctionInfo)fn, argExprs), tCtx);
        return lVar;
    }

    private LogicalVariable translateEnclosedExprNode(TranslationContext tCtx, EnclosedExprNode ee) throws SystemException {
        return this.translateExpression(ee.getExpression(), tCtx);
    }

    private LogicalVariable translateInfixExprNode(TranslationContext tCtx, InfixExprNode ie) throws SystemException {
        Function operator = this.getOperator(ie.getOperator());
        Signature sign = operator.getSignature();
        LogicalVariable varLeft = this.translateExpression(ie.getLeftExpr(), tCtx);
        LogicalVariable varRight = this.translateExpression(ie.getRightExpr(), tCtx);
        ILogicalExpression arg1 = this.normalize(XMLQueryTranslator.vre(varLeft), sign.getParameterType(0));
        ILogicalExpression arg2 = this.normalize(XMLQueryTranslator.vre(varRight), sign.getParameterType(1));
        if (BuiltinOperators.EXCEPT.equals(operator) || BuiltinOperators.INTERSECT.equals(operator)) {
            arg1 = XMLQueryTranslator.sfce(BuiltinOperators.SORT_DISTINCT_NODES_ASC, arg1);
            arg2 = XMLQueryTranslator.sfce(BuiltinOperators.SORT_DISTINCT_NODES_ASC, arg2);
        }
        ILogicalExpression result = XMLQueryTranslator.sfce(operator, arg1, arg2);
        if (BuiltinOperators.UNION.equals(operator)) {
            result = XMLQueryTranslator.sfce(BuiltinOperators.SORT_DISTINCT_NODES_ASC, result);
        }
        LogicalVariable lVar = this.createAssignment(result, tCtx);
        return lVar;
    }

    private LogicalVariable translateUnaryExprNode(TranslationContext tCtx, UnaryExprNode ueNode) throws SystemException {
        boolean neg = false;
        for (UnaryExprNode.Sign s : ueNode.getSigns()) {
            if (!UnaryExprNode.Sign.MINUS.equals((Object)s)) continue;
            neg = !neg;
        }
        LogicalVariable var = this.translateExpression(ueNode.getExpr(), tCtx);
        if (neg) {
            ILogicalExpression nExpr = this.normalize(XMLQueryTranslator.vre(var), BuiltinOperators.NUMERIC_UNARY_MINUS.getSignature().getParameterType(0));
            ILogicalExpression negExpr = XMLQueryTranslator.sfce(BuiltinOperators.NUMERIC_UNARY_MINUS, nExpr);
            var = this.createAssignment(negExpr, tCtx);
        }
        return var;
    }

    private LogicalVariable translateExprNode(TranslationContext tCtx, ExprNode node) throws SystemException {
        return this.createConcatenation(this.translateExpressionList(node.getExpressions(), tCtx), tCtx);
    }

    private LogicalVariable translatePathExpr(PathExprNode pe, TranslationContext tCtx) throws SystemException {
        ILogicalExpression ctxExpr = null;
        XQueryConstants.PathType type = pe.getPathType();
        if (type != null) {
            XQueryVariable dotVar = tCtx.varScope.lookupVariable(XMLQueryCompilerConstants.DOT_VAR_NAME);
            ILogicalExpression root = XMLQueryTranslator.sfce(BuiltinFunctions.FN_ROOT_1, XMLQueryTranslator.vre(dotVar.getLogicalVariable()));
            ctxExpr = XQueryConstants.PathType.SLASH.equals((Object)type) ? root : XMLQueryTranslator.sfce(BuiltinOperators.DESCENDANT_OR_SELF, this.treat(root, SequenceType.create(AnyNodeType.INSTANCE, Quantifier.QUANT_STAR)));
        }
        if (pe.getPaths() != null) {
            for (RelativePathExprNode rpen : pe.getPaths()) {
                boolean asc = true;
                if (XQueryConstants.PathType.SLASH_SLASH.equals((Object)rpen.getPathType())) {
                    ctxExpr = XMLQueryTranslator.sfce(BuiltinOperators.DESCENDANT_OR_SELF, this.treat(ctxExpr, SequenceType.create(AnyNodeType.INSTANCE, Quantifier.QUANT_STAR)));
                }
                boolean popScope = false;
                if (ctxExpr != null) {
                    popScope = true;
                    tCtx = tCtx.pushContext();
                    tCtx.pushVariableScope();
                    this.iterateOver(ctxExpr, tCtx);
                    ctxExpr = null;
                }
                List<ASTNode> predicates = null;
                ASTNode pathNode = rpen.getPath();
                if (ASTTag.AXIS_STEP.equals((Object)pathNode.getTag())) {
                    AxisStepNode axisNode = (AxisStepNode)pathNode;
                    predicates = axisNode.getPredicates();
                    AxisStepNode.Axis axis = axisNode.getAxis();
                    if (ctxExpr == null) {
                        ctxExpr = XMLQueryTranslator.vre(tCtx.varScope.lookupVariable(XMLQueryCompilerConstants.DOT_VAR_NAME).getLogicalVariable());
                    }
                    Function axisFn = this.translateAxis(axis);
                    NodeType nt = this.translateNodeTest(axis, axisNode.getNodeTest());
                    int ntCode = this.currCtx.encodeSequenceType(SequenceType.create(nt, Quantifier.QUANT_ONE));
                    ctxExpr = XMLQueryTranslator.sfce(axisFn, this.treat(ctxExpr, SequenceType.create(AnyNodeType.INSTANCE, Quantifier.QUANT_STAR)), this.ce(SequenceType.create(BuiltinTypeRegistry.XS_INT, Quantifier.QUANT_ONE), ntCode));
                    asc = this.isForwardAxis(axis);
                } else if (ASTTag.FILTER_EXPRESSION.equals((Object)pathNode.getTag())) {
                    FilterExprNode filterNode = (FilterExprNode)pathNode;
                    predicates = filterNode.getPredicates();
                    ctxExpr = XMLQueryTranslator.vre(this.translateExpression(filterNode.getExpr(), tCtx));
                } else {
                    throw new IllegalStateException("Unknown path node: " + (Object)((Object)pathNode.getTag()));
                }
                if (predicates != null && !predicates.isEmpty()) {
                    ctxExpr = XMLQueryTranslator.sfce(asc ? BuiltinOperators.SORT_DISTINCT_NODES_ASC_OR_ATOMICS : BuiltinOperators.SORT_DISTINCT_NODES_DESC_OR_ATOMICS, ctxExpr);
                    for (ASTNode pn : predicates) {
                        tCtx = tCtx.pushContext();
                        tCtx.pushVariableScope();
                        this.iterateOver(ctxExpr, tCtx);
                        LogicalVariable pLVar = this.translateExpression(pn, tCtx);
                        ILogicalExpression tTest = this.instanceOf(XMLQueryTranslator.vre(pLVar), SequenceType.create(BuiltinTypeRegistry.XSEXT_NUMERIC, Quantifier.QUANT_ONE));
                        ILogicalExpression posTest = XMLQueryTranslator.sfce(BuiltinOperators.VALUE_EQ, XMLQueryTranslator.vre(pLVar), XMLQueryTranslator.vre(tCtx.varScope.lookupVariable(XMLQueryCompilerConstants.POS_VAR_NAME).getLogicalVariable()));
                        ILogicalExpression boolTest = XMLQueryTranslator.sfce(BuiltinFunctions.FN_BOOLEAN_1, XMLQueryTranslator.vre(pLVar));
                        SelectOperator select = new SelectOperator(XMLQueryTranslator.mutable(XMLQueryTranslator.sfce(BuiltinOperators.IF_THEN_ELSE, tTest, posTest, boolTest)));
                        select.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
                        tCtx.op = (ILogicalOperator)select;
                        ctxExpr = XMLQueryTranslator.vre(tCtx.varScope.lookupVariable(XMLQueryCompilerConstants.DOT_VAR_NAME).getLogicalVariable());
                        tCtx.popVariableScope();
                        tCtx = tCtx.popContext();
                    }
                }
                if (!popScope) continue;
                tCtx.popVariableScope();
                ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
                ArrayList<Mutable<ILogicalExpression>> exprs = new ArrayList<Mutable<ILogicalExpression>>();
                LogicalVariable var = this.newLogicalVariable();
                vars.add(var);
                exprs.add(XMLQueryTranslator.mutable(XMLQueryTranslator.afce(BuiltinOperators.SEQUENCE, false, ctxExpr)));
                AggregateOperator aop = new AggregateOperator(vars, exprs);
                aop.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
                tCtx.op = (ILogicalOperator)aop;
                tCtx = tCtx.popContext();
                ctxExpr = XMLQueryTranslator.vre(var);
                ctxExpr = XMLQueryTranslator.sfce(asc ? BuiltinOperators.SORT_DISTINCT_NODES_ASC_OR_ATOMICS : BuiltinOperators.SORT_DISTINCT_NODES_DESC_OR_ATOMICS, XMLQueryTranslator.vre(var));
            }
        }
        LogicalVariable lVar = this.createAssignment(ctxExpr, tCtx);
        return lVar;
    }

    private void iterateOver(ILogicalExpression ctxExpr, TranslationContext tCtx) {
        LogicalVariable seqLVar = this.createAssignment(ctxExpr, tCtx);
        LogicalVariable lastLVar = this.createAssignment(XMLQueryTranslator.sfce(BuiltinFunctions.FN_COUNT_1, XMLQueryTranslator.vre(seqLVar)), tCtx);
        tCtx.varScope.registerVariable(new XQueryVariable(XMLQueryCompilerConstants.LAST_VAR_NAME, SequenceType.create(BuiltinTypeRegistry.XS_INTEGER, Quantifier.QUANT_ONE), lastLVar));
        LogicalVariable forLVar = this.newLogicalVariable();
        LogicalVariable posLVar = this.newLogicalVariable();
        UnnestOperator unnest = new UnnestOperator(forLVar, XMLQueryTranslator.mutable(XMLQueryTranslator.ufce(BuiltinOperators.ITERATE, XMLQueryTranslator.vre(seqLVar))), posLVar, null);
        SequenceType forVarType = SequenceType.create(AnyItemType.INSTANCE, Quantifier.QUANT_ONE);
        XQueryVariable forVar = new XQueryVariable(XMLQueryCompilerConstants.DOT_VAR_NAME, forVarType, forLVar);
        tCtx.varScope.registerVariable(forVar);
        XQueryVariable posVar = new XQueryVariable(XMLQueryCompilerConstants.POS_VAR_NAME, SequenceType.create(BuiltinTypeRegistry.XS_INTEGER, Quantifier.QUANT_ONE), posLVar);
        tCtx.varScope.registerVariable(posVar);
        unnest.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
        tCtx.op = (ILogicalOperator)unnest;
    }

    private boolean isForwardAxis(AxisStepNode.Axis axis) {
        switch (axis) {
            case ABBREV: 
            case CHILD: 
            case ABBREV_ATTRIBUTE: 
            case ATTRIBUTE: 
            case DESCENDANT: 
            case DESCENDANT_OR_SELF: 
            case FOLLOWING: 
            case FOLLOWING_SIBLING: 
            case SELF: {
                return true;
            }
            case ANCESTOR: 
            case ANCESTOR_OR_SELF: 
            case DOT_DOT: 
            case PARENT: 
            case PRECEDING: 
            case PRECEDING_SIBLING: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown axis: " + (Object)((Object)axis));
    }

    private NodeType translateNodeTest(AxisStepNode.Axis axis, ASTNode nodeTest) throws SystemException {
        NodeType nt = AnyNodeType.INSTANCE;
        if (nodeTest != null) {
            switch (nodeTest.getTag()) {
                case NAME_TEST: {
                    NameTestNode ntn = (NameTestNode)nodeTest;
                    String uri = null;
                    if (ntn.getPrefix() != null) {
                        if (!"".equals(ntn.getPrefix())) {
                            uri = this.currCtx.lookupNamespaceUri(ntn.getPrefix());
                            if (uri == null) {
                                throw new SystemException(ErrorCode.XPST0081, ntn.getSourceLocation());
                            }
                        } else {
                            uri = "";
                        }
                    }
                    String localName = ntn.getLocalName();
                    NameTest nameTest = new NameTest(uri == null ? null : this.createUTF8String(uri), localName == null ? null : this.createUTF8String(ntn.getLocalName()));
                    if (axis == AxisStepNode.Axis.ATTRIBUTE || axis == AxisStepNode.Axis.ABBREV_ATTRIBUTE) {
                        nt = new AttributeType(nameTest, BuiltinTypeRegistry.XS_ANY_ATOMIC);
                        break;
                    }
                    nt = new ElementType(nameTest, AnyType.INSTANCE, true);
                    break;
                }
                case ANY_NODE_TEST: 
                case DOCUMENT_TEST: 
                case TEXT_TEST: 
                case COMMENT_TEST: 
                case PI_TEST: 
                case ATTRIBUTE_TEST: 
                case SCHEMA_ATTRIBUTE_TEST: 
                case ELEMENT_TEST: 
                case SCHEMA_ELEMENT_TEST: {
                    nt = (NodeType)this.createItemType(nodeTest);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown node: " + (Object)((Object)nodeTest.getTag()));
                }
            }
        }
        return nt;
    }

    private Function translateAxis(AxisStepNode.Axis axis) {
        switch (axis) {
            case ABBREV: 
            case CHILD: {
                return BuiltinOperators.CHILD;
            }
            case ABBREV_ATTRIBUTE: 
            case ATTRIBUTE: {
                return BuiltinOperators.ATTRIBUTE;
            }
            case ANCESTOR: {
                return BuiltinOperators.ANCESTOR;
            }
            case ANCESTOR_OR_SELF: {
                return BuiltinOperators.ANCESTOR_OR_SELF;
            }
            case DESCENDANT: {
                return BuiltinOperators.DESCENDANT;
            }
            case DESCENDANT_OR_SELF: {
                return BuiltinOperators.DESCENDANT_OR_SELF;
            }
            case DOT_DOT: 
            case PARENT: {
                return BuiltinOperators.PARENT;
            }
            case FOLLOWING: {
                return BuiltinOperators.FOLLOWING;
            }
            case FOLLOWING_SIBLING: {
                return BuiltinOperators.FOLLOWING_SIBLING;
            }
            case PRECEDING: {
                return BuiltinOperators.PRECEDING;
            }
            case PRECEDING_SIBLING: {
                return BuiltinOperators.PRECEDING_SIBLING;
            }
            case SELF: {
                return BuiltinOperators.SELF;
            }
        }
        throw new IllegalStateException("Unknown axis: " + (Object)((Object)axis));
    }

    private static String unquote(String image) throws SystemException {
        StringBuilder buffer = new StringBuilder();
        char quoteChar = image.charAt(0);
        image = image.substring(1, image.length() - 1);
        Matcher m = UNQUOTER.matcher(image);
        int i = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (i < start) {
                buffer.append(image, i, start);
            }
            if (m.start(1) >= 0) {
                buffer.append('<');
            } else if (m.start(2) >= 0) {
                buffer.append('>');
            } else if (m.start(3) >= 0) {
                buffer.append('\'');
            } else if (m.start(4) >= 0) {
                buffer.append('&');
            } else if (m.start(5) >= 0) {
                buffer.append('\"');
            } else if (m.start(6) >= 0) {
                buffer.append(quoteChar == '\"' ? Character.valueOf('\"') : "\"\"");
            } else if (m.start(7) >= 0) {
                buffer.append(quoteChar == '\'' ? Character.valueOf('\'') : "''");
            } else {
                if (m.start(8) >= 0) {
                    try {
                        buffer.appendCodePoint(Integer.parseInt(image.substring(start + 2, end - 1)));
                    }
                    catch (NumberFormatException e) {
                        throw new SystemException(ErrorCode.XQST0090);
                    }
                }
                if (m.start(9) >= 0) {
                    try {
                        buffer.appendCodePoint(Integer.parseInt(image.substring(start + 3, end - 1), 16));
                    }
                    catch (NumberFormatException e) {
                        throw new SystemException(ErrorCode.XQST0090);
                    }
                }
            }
            i = m.end();
        }
        if (i < image.length()) {
            buffer.append(image, i, image.length());
        }
        return buffer.toString();
    }

    private QName createQName(QNameNode qnNode) throws SystemException {
        return this.createQName(qnNode, "");
    }

    private QName createQName(QNameNode qnNode, String defaultUri) throws SystemException {
        String uri;
        String prefix = qnNode.getPrefix();
        String local = qnNode.getLocalName();
        if (!"".equals(prefix)) {
            uri = this.currCtx.lookupNamespaceUri(prefix);
            if (uri == null) {
                throw new SystemException(ErrorCode.XPST0081, qnNode.getSourceLocation());
            }
        } else {
            uri = defaultUri;
        }
        return new QName(uri, local, prefix);
    }

    private static ILogicalExpression afce(Function fn, boolean isTwoStep, ILogicalExpression ... argExprs) {
        ArrayList<Mutable<ILogicalExpression>> args = new ArrayList<Mutable<ILogicalExpression>>();
        for (ILogicalExpression e : argExprs) {
            args.add(XMLQueryTranslator.mutable(e));
        }
        return new AggregateFunctionCallExpression((IFunctionInfo)fn, isTwoStep, args);
    }

    private static ILogicalExpression ufce(Function fn, ILogicalExpression ... argExprs) {
        ArrayList<Mutable<ILogicalExpression>> args = new ArrayList<Mutable<ILogicalExpression>>();
        for (ILogicalExpression e : argExprs) {
            args.add(XMLQueryTranslator.mutable(e));
        }
        return new UnnestingFunctionCallExpression((IFunctionInfo)fn, args);
    }

    private static ILogicalExpression sfce(Function fn, ILogicalExpression ... argExprs) {
        ArrayList<Mutable<ILogicalExpression>> args = new ArrayList<Mutable<ILogicalExpression>>();
        for (ILogicalExpression e : argExprs) {
            args.add(XMLQueryTranslator.mutable(e));
        }
        return new ScalarFunctionCallExpression((IFunctionInfo)fn, args);
    }

    private Function getOperator(InfixExprNode.InfixOperator operator) {
        switch (operator) {
            case AND: {
                return BuiltinOperators.AND;
            }
            case DIV: {
                return BuiltinOperators.DIVIDE;
            }
            case EXCEPT: {
                return BuiltinOperators.EXCEPT;
            }
            case FOLLOWS: {
                return BuiltinOperators.NODE_AFTER;
            }
            case GENERAL_EQ: {
                return BuiltinOperators.GENERAL_EQ;
            }
            case GENERAL_GE: {
                return BuiltinOperators.GENERAL_GE;
            }
            case GENERAL_GT: {
                return BuiltinOperators.GENERAL_GT;
            }
            case GENERAL_LE: {
                return BuiltinOperators.GENERAL_LE;
            }
            case GENERAL_LT: {
                return BuiltinOperators.GENERAL_LT;
            }
            case GENERAL_NE: {
                return BuiltinOperators.GENERAL_NE;
            }
            case IDIV: {
                return BuiltinOperators.IDIV;
            }
            case INTERSECT: {
                return BuiltinOperators.INTERSECT;
            }
            case IS: {
                return BuiltinOperators.IS_SAME_NODE;
            }
            case MINUS: {
                return BuiltinOperators.SUBTRACT;
            }
            case MOD: {
                return BuiltinOperators.MOD;
            }
            case MULTIPLY: {
                return BuiltinOperators.MULTIPLY;
            }
            case OR: {
                return BuiltinOperators.OR;
            }
            case PLUS: {
                return BuiltinOperators.ADD;
            }
            case PRECEDES: {
                return BuiltinOperators.NODE_BEFORE;
            }
            case RANGE: {
                return BuiltinOperators.TO;
            }
            case UNION: {
                return BuiltinOperators.UNION;
            }
            case VALUE_EQ: {
                return BuiltinOperators.VALUE_EQ;
            }
            case VALUE_GE: {
                return BuiltinOperators.VALUE_GE;
            }
            case VALUE_GT: {
                return BuiltinOperators.VALUE_GT;
            }
            case VALUE_LE: {
                return BuiltinOperators.VALUE_LE;
            }
            case VALUE_LT: {
                return BuiltinOperators.VALUE_LT;
            }
            case VALUE_NE: {
                return BuiltinOperators.VALUE_NE;
            }
        }
        throw new IllegalStateException("Unknown operator: " + (Object)((Object)operator));
    }

    private ILogicalExpression ce(SequenceType type, Object value) throws SystemException {
        try {
            ItemType it = type.getItemType();
            if (it.isAtomicType()) {
                AtomicType at = (AtomicType)it;
                byte[] bytes = null;
                switch (at.getTypeId()) {
                    case 43: {
                        this.baaos.reset();
                        this.dOut.write(43);
                        this.dOut.writeByte((Boolean)value != false ? 1 : 0);
                        break;
                    }
                    case 29: {
                        this.baaos.reset();
                        this.dOut.write(29);
                        this.dOut.writeInt(((Number)value).intValue());
                        break;
                    }
                    case 25: {
                        this.baaos.reset();
                        this.dOut.write(25);
                        this.dOut.writeLong(((Number)value).longValue());
                        break;
                    }
                    case 23: {
                        this.baaos.reset();
                        this.dOut.write(23);
                        this.dOut.writeDouble(((Number)value).doubleValue());
                        break;
                    }
                    case 4: {
                        this.baaos.reset();
                        this.dOut.write(4);
                        this.stringVB.write((CharSequence)value, this.dOut);
                        break;
                    }
                    case 24: {
                        this.baaos.reset();
                        DoublePointable doublep = (DoublePointable)DoublePointable.FACTORY.createPointable();
                        doublep.set(new byte[DoublePointable.TYPE_TRAITS.getFixedLength()], 0, DoublePointable.TYPE_TRAITS.getFixedLength());
                        doublep.setDouble(((Number)value).doubleValue());
                        CastToDecimalOperation castToDecimal = new CastToDecimalOperation();
                        castToDecimal.convertDouble(doublep, this.dOut);
                        break;
                    }
                    case 47: {
                        QName qname = (QName)value;
                        this.baaos.reset();
                        this.dOut.write(47);
                        this.stringVB.write(qname.getNamespaceURI(), this.dOut);
                        this.stringVB.write(qname.getPrefix(), this.dOut);
                        this.stringVB.write(qname.getLocalPart(), this.dOut);
                        break;
                    }
                    case 14: {
                        this.baaos.reset();
                        this.dOut.write(14);
                        this.stringVB.write((CharSequence)value, this.dOut);
                        break;
                    }
                    default: {
                        throw new SystemException(ErrorCode.SYSE0001);
                    }
                }
                bytes = Arrays.copyOf(this.baaos.getByteArray(), this.baaos.size());
                return new ConstantExpression((IAlgebricksConstantValue)new VXQueryConstantValue(type, bytes));
            }
            throw new UnsupportedOperationException();
        }
        catch (IOException e) {
            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
        }
    }

    private static ILogicalExpression vre(LogicalVariable var) {
        if (var == null) {
            throw new NullPointerException();
        }
        return new VariableReferenceExpression(var);
    }

    private LogicalVariable createConcatenation(List<LogicalVariable> vars, TranslationContext tCtx) {
        if (vars.size() == 1) {
            return vars.get(0);
        }
        return this.createFunctionCall(BuiltinOperators.CONCATENATE, vars, tCtx);
    }

    private LogicalVariable createFunctionCall(Function fn, List<LogicalVariable> vars, TranslationContext tCtx) {
        return this.createAssignment(XMLQueryTranslator.createFunctionCall(fn, vars), tCtx);
    }

    private LogicalVariable createAssignment(ILogicalExpression expr, TranslationContext tCtx) {
        if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return ((VariableReferenceExpression)expr).getVariableReference();
        }
        LogicalVariable result = this.newLogicalVariable();
        AssignOperator aOp = new AssignOperator(result, XMLQueryTranslator.mutable(expr));
        aOp.getInputs().add(XMLQueryTranslator.mutable(tCtx.op));
        tCtx.op = (ILogicalOperator)aOp;
        return result;
    }

    private static ILogicalExpression createFunctionCall(Function fn, List<LogicalVariable> vars) {
        ArrayList<Mutable<ILogicalExpression>> args = new ArrayList<Mutable<ILogicalExpression>>();
        for (LogicalVariable var : vars) {
            args.add(XMLQueryTranslator.mutable((ILogicalExpression)new VariableReferenceExpression(var)));
        }
        return new ScalarFunctionCallExpression((IFunctionInfo)fn, args);
    }

    private ILogicalExpression normalize(ILogicalExpression expr, SequenceType type) throws SystemException {
        if (type.getItemType().isAtomicType()) {
            ScalarFunctionCallExpression atomizedExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.FN_DATA_1, Collections.singletonList(XMLQueryTranslator.mutable(expr)));
            AtomicType aType = (AtomicType)type.getItemType();
            if (TypeUtils.isSubtypeTypeOf(aType, BuiltinTypeRegistry.XS_BOOLEAN)) {
                return new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.FN_BOOLEAN_1, Collections.singletonList(XMLQueryTranslator.mutable((ILogicalExpression)atomizedExpr)));
            }
            return this.promote((ILogicalExpression)atomizedExpr, type);
        }
        return this.treat(expr, type);
    }

    private ILogicalExpression promote(ILogicalExpression expr, SequenceType type) throws SystemException {
        int typeCode = this.currCtx.lookupSequenceType(type);
        return XMLQueryTranslator.sfce(BuiltinOperators.PROMOTE, expr, this.ce(SequenceType.create(BuiltinTypeRegistry.XS_INT, Quantifier.QUANT_ONE), typeCode));
    }

    private ILogicalExpression treat(ILogicalExpression expr, SequenceType type) throws SystemException {
        int typeCode = this.currCtx.lookupSequenceType(type);
        return XMLQueryTranslator.sfce(BuiltinOperators.TREAT, expr, this.ce(SequenceType.create(BuiltinTypeRegistry.XS_INT, Quantifier.QUANT_ONE), typeCode));
    }

    private ILogicalExpression cast(ILogicalExpression expr, SequenceType type) throws SystemException {
        int typeCode = this.currCtx.lookupSequenceType(type);
        return XMLQueryTranslator.sfce(BuiltinOperators.CAST, expr, this.ce(SequenceType.create(BuiltinTypeRegistry.XS_INT, Quantifier.QUANT_ONE), typeCode));
    }

    private ILogicalExpression castable(ILogicalExpression expr, SequenceType type) throws SystemException {
        int typeCode = this.currCtx.lookupSequenceType(type);
        return XMLQueryTranslator.sfce(BuiltinOperators.CASTABLE, expr, this.ce(SequenceType.create(BuiltinTypeRegistry.XS_INT, Quantifier.QUANT_ONE), typeCode));
    }

    private ILogicalExpression instanceOf(ILogicalExpression expr, SequenceType type) throws SystemException {
        int typeCode = this.currCtx.lookupSequenceType(type);
        return XMLQueryTranslator.sfce(BuiltinOperators.INSTANCE_OF, expr, this.ce(SequenceType.create(BuiltinTypeRegistry.XS_INT, Quantifier.QUANT_ONE), typeCode));
    }

    private List<LogicalVariable> translateExpressionList(List<ASTNode> expressions, TranslationContext tCtx) throws SystemException {
        ArrayList<LogicalVariable> result = new ArrayList<LogicalVariable>();
        for (ASTNode e : expressions) {
            result.add(this.translateExpression(e, tCtx));
        }
        return result;
    }

    private static Mutable<ILogicalExpression> mutable(ILogicalExpression expr) {
        return new MutableObject((Object)expr);
    }

    private static Mutable<ILogicalOperator> mutable(ILogicalOperator op) {
        return new MutableObject((Object)op);
    }

    private LogicalVariable newLogicalVariable() {
        return new LogicalVariable(this.varCounter++);
    }

    private static class ExpressionVariableScope
    implements IVariableScope {
        private final IVariableScope parent;
        private final Map<QName, XQueryVariable> varMap;

        public ExpressionVariableScope(IVariableScope parent) {
            this.parent = parent;
            this.varMap = new HashMap<QName, XQueryVariable>();
        }

        @Override
        public IVariableScope getParentScope() {
            return this.parent;
        }

        @Override
        public XQueryVariable lookupVariable(QName name) {
            if (this.varMap.containsKey(name)) {
                return this.varMap.get(name);
            }
            return this.parent.lookupVariable(name);
        }

        @Override
        public void registerVariable(XQueryVariable var) {
            this.varMap.put(var.getName(), var);
        }
    }

    private static interface IVariableScope {
        public IVariableScope getParentScope();

        public XQueryVariable lookupVariable(QName var1);

        public void registerVariable(XQueryVariable var1);
    }

    private class TranslationContext {
        private final TranslationContext parent;
        private ILogicalOperator op;
        private IVariableScope varScope;

        public TranslationContext(TranslationContext parent, ILogicalOperator op) {
            this.parent = parent;
            this.op = op;
            this.varScope = parent == null ? XMLQueryTranslator.this.rootVarScope : parent.varScope;
        }

        TranslationContext pushContext() {
            SubplanOperator sOp = new SubplanOperator();
            sOp.getInputs().add(XMLQueryTranslator.mutable(this.op));
            this.op = sOp;
            NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator(XMLQueryTranslator.mutable((ILogicalOperator)sOp));
            TranslationContext childCtx = new TranslationContext(this, (ILogicalOperator)ntsOp);
            return childCtx;
        }

        TranslationContext popContext() {
            SubplanOperator sOp = (SubplanOperator)this.parent.op;
            sOp.setRootOp(XMLQueryTranslator.mutable(this.op));
            return this.parent;
        }

        void pushVariableScope() {
            this.varScope = new ExpressionVariableScope(this.varScope);
        }

        void popVariableScope() {
            this.varScope = this.varScope.getParentScope();
        }
    }

    private class RootVariableScope
    implements IVariableScope {
        private RootVariableScope() {
        }

        @Override
        public IVariableScope getParentScope() {
            return null;
        }

        @Override
        public XQueryVariable lookupVariable(QName name) {
            return XMLQueryTranslator.this.moduleCtx.lookupVariable(name);
        }

        @Override
        public void registerVariable(XQueryVariable var) {
            XMLQueryTranslator.this.moduleCtx.registerVariable(var);
        }
    }
}

