/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.xmlquery.query;

import java.io.Reader;
import java.util.List;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.util.SourceLocation;
import org.apache.vxquery.xmlquery.ast.ModuleNode;
import org.apache.vxquery.xmlquery.query.ParseException;
import org.apache.vxquery.xmlquery.query.TokenMgrError;
import org.apache.vxquery.xmlquery.query.XMLQuery;

public class XMLQueryParser {
    public static ModuleNode parse(String sourceName, Reader input) throws SystemException {
        XMLQuery parser = new XMLQuery(input);
        parser.setSourceName(sourceName);
        try {
            return parser.CUnit();
        }
        catch (TokenMgrError tme) {
            throw new SystemException(ErrorCode.XPST0003, (Throwable)tme);
        }
        catch (ParseException pe) {
            List<SystemException> exceptions = parser.getExceptions();
            if (!exceptions.isEmpty()) {
                throw exceptions.get(0);
            }
            throw new SystemException(ErrorCode.XPST0003, new SourceLocation(sourceName, pe.currentToken.beginLine, pe.currentToken.beginColumn));
        }
    }

    private XMLQueryParser() {
    }
}

