/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.xmlquery.query;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.exceptions.NotImplementedException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.compiler.api.HeuristicCompilerFactoryBuilder;
import edu.uci.ics.hyracks.algebricks.compiler.api.ICompiler;
import edu.uci.ics.hyracks.algebricks.compiler.api.ICompilerFactory;
import edu.uci.ics.hyracks.algebricks.compiler.rewriter.rulecontrollers.PrioritizedRuleController;
import edu.uci.ics.hyracks.algebricks.compiler.rewriter.rulecontrollers.SequentialFixpointRuleController;
import edu.uci.ics.hyracks.algebricks.compiler.rewriter.rulecontrollers.SequentialOnceRuleController;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionEvalSizeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.INullableTypeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.AbstractRuleController;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IOptimizationContextFactory;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import edu.uci.ics.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import edu.uci.ics.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import edu.uci.ics.hyracks.algebricks.data.IBinaryHashFunctionFactoryProvider;
import edu.uci.ics.hyracks.algebricks.data.IBinaryHashFunctionFamilyProvider;
import edu.uci.ics.hyracks.algebricks.data.IBinaryIntegerInspectorFactory;
import edu.uci.ics.hyracks.algebricks.data.ISerializerDeserializerProvider;
import edu.uci.ics.hyracks.algebricks.data.ITypeTraitProvider;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.api.job.JobSpecification;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.vxquery.compiler.CompilerControlBlock;
import org.apache.vxquery.compiler.algebricks.VXQueryBinaryBooleanInspectorFactory;
import org.apache.vxquery.compiler.algebricks.VXQueryBinaryIntegerInspectorFactory;
import org.apache.vxquery.compiler.algebricks.VXQueryComparatorFactoryProvider;
import org.apache.vxquery.compiler.algebricks.VXQueryConstantValue;
import org.apache.vxquery.compiler.algebricks.VXQueryExpressionRuntimeProvider;
import org.apache.vxquery.compiler.algebricks.VXQueryNullWriterFactory;
import org.apache.vxquery.compiler.algebricks.VXQueryPrinterFactoryProvider;
import org.apache.vxquery.compiler.algebricks.prettyprint.VXQueryLogicalExpressionPrettyPrintVisitor;
import org.apache.vxquery.compiler.rewriter.RewriteRuleset;
import org.apache.vxquery.compiler.rewriter.VXQueryOptimizationContext;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.metadata.VXQueryMetadataProvider;
import org.apache.vxquery.runtime.provider.VXQueryBinaryHashFunctionFactoryProvider;
import org.apache.vxquery.runtime.provider.VXQueryBinaryHashFunctionFamilyProvider;
import org.apache.vxquery.types.BuiltinTypeRegistry;
import org.apache.vxquery.types.Quantifier;
import org.apache.vxquery.types.SequenceType;
import org.apache.vxquery.xmlquery.ast.ModuleNode;
import org.apache.vxquery.xmlquery.query.Module;
import org.apache.vxquery.xmlquery.query.NoopXQueryCompilationListener;
import org.apache.vxquery.xmlquery.query.XMLQueryParser;
import org.apache.vxquery.xmlquery.query.XMLQueryTypeChecker;
import org.apache.vxquery.xmlquery.query.XQueryCompilationListener;
import org.apache.vxquery.xmlquery.translator.XMLQueryTranslator;

public class XMLQueryCompiler {
    private final XQueryCompilationListener listener;
    private final ICompilerFactory cFactory;
    private LogicalOperatorPrettyPrintVisitor pprinter;
    private ModuleNode moduleNode;
    private Module module;
    private ICompiler compiler;
    private int frameSize;
    private String[] nodeList;

    public XMLQueryCompiler(XQueryCompilationListener listener, String[] nodeList, int frameSize) {
        this(listener, nodeList, frameSize, -1);
    }

    public XMLQueryCompiler(XQueryCompilationListener listener, String[] nodeList, int frameSize, int availableProcessors) {
        this.listener = listener == null ? NoopXQueryCompilationListener.INSTANCE : listener;
        this.frameSize = frameSize;
        this.nodeList = nodeList;
        HeuristicCompilerFactoryBuilder builder = new HeuristicCompilerFactoryBuilder(new IOptimizationContextFactory(){

            public IOptimizationContext createOptimizationContext(int varCounter, IExpressionEvalSizeComputer expressionEvalSizeComputer, IMergeAggregationExpressionFactory mergeAggregationExpressionFactory, IExpressionTypeComputer expressionTypeComputer, INullableTypeComputer nullableTypeComputer, PhysicalOptimizationConfig physicalOptimizationConfig) {
                return new VXQueryOptimizationContext(varCounter, expressionEvalSizeComputer, mergeAggregationExpressionFactory, expressionTypeComputer, nullableTypeComputer, physicalOptimizationConfig, XMLQueryCompiler.this.pprinter);
            }
        });
        builder.getPhysicalOptimizationConfig().setFrameSize(this.frameSize);
        builder.setLogicalRewrites(XMLQueryCompiler.buildDefaultLogicalRewrites());
        builder.setPhysicalRewrites(XMLQueryCompiler.buildDefaultPhysicalRewrites());
        builder.setSerializerDeserializerProvider(new ISerializerDeserializerProvider(){

            public ISerializerDeserializer getSerializerDeserializer(Object type) throws AlgebricksException {
                return null;
            }
        });
        builder.setHashFunctionFactoryProvider((IBinaryHashFunctionFactoryProvider)VXQueryBinaryHashFunctionFactoryProvider.INSTANCE);
        builder.setHashFunctionFamilyProvider((IBinaryHashFunctionFamilyProvider)VXQueryBinaryHashFunctionFamilyProvider.INSTANCE);
        builder.setTypeTraitProvider(new ITypeTraitProvider(){

            public ITypeTraits getTypeTrait(Object type) {
                return VoidPointable.TYPE_TRAITS;
            }
        });
        builder.setPrinterProvider(VXQueryPrinterFactoryProvider.INSTANCE);
        builder.setExpressionRuntimeProvider((IExpressionRuntimeProvider)new VXQueryExpressionRuntimeProvider());
        builder.setComparatorFactoryProvider((IBinaryComparatorFactoryProvider)new VXQueryComparatorFactoryProvider());
        builder.setBinaryBooleanInspectorFactory((IBinaryBooleanInspectorFactory)new VXQueryBinaryBooleanInspectorFactory());
        builder.setBinaryIntegerInspectorFactory((IBinaryIntegerInspectorFactory)new VXQueryBinaryIntegerInspectorFactory());
        builder.setExpressionTypeComputer(new IExpressionTypeComputer(){

            public Object getType(ILogicalExpression expr, IMetadataProvider<?, ?> metadataProvider, IVariableTypeEnvironment env) throws AlgebricksException {
                if (expr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                    ConstantExpression ce = (ConstantExpression)expr;
                    IAlgebricksConstantValue acv = ce.getValue();
                    if (acv == ConstantExpression.TRUE.getValue() || acv == ConstantExpression.FALSE.getValue()) {
                        return SequenceType.create(BuiltinTypeRegistry.XS_BOOLEAN, Quantifier.QUANT_ONE);
                    }
                    VXQueryConstantValue cv = (VXQueryConstantValue)acv;
                    return cv.getType();
                }
                return null;
            }
        });
        builder.setNullableTypeComputer(new INullableTypeComputer(){

            public Object makeNullableType(Object type) throws AlgebricksException {
                throw new NotImplementedException("NullableTypeComputer is not implented");
            }
        });
        builder.setNullWriterFactory((INullWriterFactory)new VXQueryNullWriterFactory());
        if (availableProcessors < 1) {
            builder.setClusterLocations(VXQueryMetadataProvider.getClusterLocations(nodeList));
        } else {
            builder.setClusterLocations(VXQueryMetadataProvider.getClusterLocations(nodeList, availableProcessors));
        }
        this.cFactory = builder.create();
    }

    public void compile(String name, Reader query, CompilerControlBlock ccb, int optimizationLevel) throws SystemException {
        JobSpecification jobSpec;
        this.moduleNode = XMLQueryParser.parse(name, query);
        this.listener.notifyParseResult(this.moduleNode);
        this.module = new XMLQueryTranslator(ccb).translateModule(this.moduleNode);
        this.pprinter = new LogicalOperatorPrettyPrintVisitor((ILogicalExpressionVisitor)new VXQueryLogicalExpressionPrettyPrintVisitor(this.module.getModuleContext()));
        VXQueryMetadataProvider mdProvider = new VXQueryMetadataProvider(this.nodeList, ccb.getSourceFileMap());
        this.compiler = this.cFactory.createCompiler(this.module.getBody(), (IMetadataProvider)mdProvider, 0);
        this.listener.notifyTranslationResult(this.module);
        XMLQueryTypeChecker.typeCheckModule(this.module);
        this.listener.notifyTypecheckResult(this.module);
        try {
            this.compiler.optimize();
        }
        catch (AlgebricksException e) {
            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
        }
        this.listener.notifyOptimizedResult(this.module);
        try {
            jobSpec = this.compiler.createJob(null, null);
            jobSpec.setFrameSize(this.frameSize);
        }
        catch (AlgebricksException e) {
            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
        }
        this.module.setHyracksJobSpecification(jobSpec);
        this.listener.notifyCodegenResult(this.module);
    }

    public ModuleNode getModuleNode() {
        return this.moduleNode;
    }

    public Module getModule() {
        return this.module;
    }

    private static List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> buildDefaultLogicalRewrites() {
        ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> defaultLogicalRewrites = new ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>>();
        SequentialFixpointRuleController seqCtrlNoDfs = new SequentialFixpointRuleController(false);
        SequentialFixpointRuleController seqCtrlFullDfs = new SequentialFixpointRuleController(true);
        SequentialOnceRuleController seqOnceCtrl = new SequentialOnceRuleController(true);
        PrioritizedRuleController priorityCtrl = new PrioritizedRuleController();
        defaultLogicalRewrites.add(new Pair((Object)priorityCtrl, RewriteRuleset.buildPathStepNormalizationRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)priorityCtrl, RewriteRuleset.buildXQueryNormalizationRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlFullDfs, RewriteRuleset.buildRedundantExpressionNormalizationRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)priorityCtrl, RewriteRuleset.buildNestedDataSourceRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqOnceCtrl, RewriteRuleset.buildTypeInferenceRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlFullDfs, RewriteRuleset.buildNormalizationRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RewriteRuleset.buildCondPushDownRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RewriteRuleset.buildJoinInferenceRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RewriteRuleset.buildOpPushDownRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqOnceCtrl, RewriteRuleset.buildDataExchangeRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RewriteRuleset.buildConsolidationRuleCollection()));
        return defaultLogicalRewrites;
    }

    private static List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> buildDefaultPhysicalRewrites() {
        ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> defaultPhysicalRewrites = new ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>>();
        SequentialOnceRuleController seqOnceCtrlAllLevels = new SequentialOnceRuleController(true);
        SequentialOnceRuleController seqOnceCtrlTopLevel = new SequentialOnceRuleController(false);
        defaultPhysicalRewrites.add(new Pair((Object)seqOnceCtrlAllLevels, RewriteRuleset.buildPhysicalRewritesAllLevelsRuleCollection()));
        defaultPhysicalRewrites.add(new Pair((Object)seqOnceCtrlTopLevel, RewriteRuleset.buildPhysicalRewritesTopLevelRuleCollection()));
        defaultPhysicalRewrites.add(new Pair((Object)seqOnceCtrlAllLevels, RewriteRuleset.prepareForJobGenRuleCollection()));
        return defaultPhysicalRewrites;
    }
}

