/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.xmlparser;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.apache.vxquery.exceptions.VXQueryFileNotFoundException;
import org.apache.vxquery.exceptions.VXQueryParseException;
import org.apache.vxquery.xmlparser.ITreeNodeIdProvider;
import org.apache.vxquery.xmlparser.SAXContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLParser {
    XMLReader parser;
    SAXContentHandler handler;

    public XMLParser(boolean attachTypes, ITreeNodeIdProvider idProvider) throws HyracksDataException {
        try {
            this.parser = XMLReaderFactory.createXMLReader();
            this.handler = new SAXContentHandler(attachTypes, idProvider);
            this.parser.setContentHandler(this.handler);
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this.handler);
        }
        catch (Exception e) {
            throw new HyracksDataException(e.toString());
        }
    }

    public void parseFile(File file, InputSource in, ArrayBackedValueStorage abvs) throws HyracksDataException {
        try {
            if (file.getName().toLowerCase().endsWith(".xml.gz")) {
                in.setCharacterStream(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
            } else {
                in.setCharacterStream(new InputStreamReader(new FileInputStream(file)));
            }
            this.parser.parse(in);
            this.handler.write(abvs);
        }
        catch (FileNotFoundException e) {
            throw new VXQueryFileNotFoundException(e, file);
        }
        catch (SAXException e) {
            throw new VXQueryParseException(e, file);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

