/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.xmlparser;

import org.apache.vxquery.xmlparser.ITreeNodeIdProvider;

public class TreeNodeIdProvider
implements ITreeNodeIdProvider {
    private final short partitionDataSource;
    private final short dataSouceScanId;
    private final byte dataSourceBits;
    private short currentId;

    public TreeNodeIdProvider(short partitionDataSource, short dataSouceScanId, short totalDataSources) {
        this.partitionDataSource = partitionDataSource;
        this.dataSouceScanId = dataSouceScanId;
        this.dataSourceBits = this.getBitsNeeded(totalDataSources);
        this.currentId = 0;
    }

    public TreeNodeIdProvider(short partition) {
        this.partitionDataSource = partition;
        this.dataSouceScanId = 0;
        this.dataSourceBits = 0;
        this.currentId = 0;
    }

    @Override
    public int getId() {
        short p = this.partitionDataSource;
        short dssi = this.dataSouceScanId;
        short s = this.currentId;
        this.currentId = (short)(s + 1);
        return p << 16 | dssi << 16 - this.dataSourceBits | s;
    }

    private byte getBitsNeeded(int number) {
        byte count = 0;
        while (number > 0) {
            count = (byte)(count + 1);
            number >>= 1;
        }
        return count;
    }
}

